init = func {
  var ambtemp = getprop("/environment/temperature-degc");
  setprop("/engines/engine[0]/oil-temp", ambtemp);
  setprop("/engines/engine[0]/oil-press", 0);
  setprop("/engines/engine[0]/cyl-temp", ambtemp);
  oil_temp_ind();
  main_loop();
}

##### PRIMER #####
##################
setlistener("/controls/engines/engine[0]/primer", func(n) {
  var pos2=n.getValue();
  if(pos2 > 0.9){
    setprop("/engines/engine[0]/out-of-fuel",0);
    setprop("/consumables/fuel/tank[0]/selected",1);
    setprop("/consumables/fuel/tank[1]/selected",1);
  }else{
    setprop("/engines/engine[0]/out-of-fuel",1);
    setprop("/consumables/fuel/tank[0]/selected",0);
    setprop("/consumables/fuel/tank[1]/selected",0);
  };
},1);

##### Check Engine Started #####
#######################
setlistener("/engines/engine[0]/rpm", func(n) {
  var rev3=n.getValue();
  if(rev3 < 100){
    setprop("/engines/engine[0]/running",0);
  };
},1);

##### KILL ENGINE ON CRASH ######
#################################
setlistener("/sim[0]/crashed", func(n) {
  var crash=n.getValue();
  if(crash){
    setprop("/engines/engine[0]/running", 0);
    setprop("/engines/engine[0]/out-of-fuel",1);
    setprop("/consumables/fuel/tank[0]/selected",0);
    setprop("/consumables/fuel/tank[1]/selected",0);
  };
},1);

##### kill engine on prop hitting ground ######
###############################################
setlistener("position/altitude-agl-ft", func(n) {
  var hght=n.getValue();
  if(hght < 3.5){
    setprop("/engines/engine[0]/running", 0);
    setprop("/engines/engine[0]/out-of-fuel",1);
    setprop("/consumables/fuel/tank[0]/selected",0);
    setprop("/consumables/fuel/tank[1]/selected",0);
  };
},1);

##### some coughing when too much wear ######
#############################################
setlistener("/engines/engine[0]/seize-strain", func(n) {
  var cough1=n.getValue();
  if(cough1 > 500 ){
    var timer = rand()*5;
    var eng_off = func {setprop("/engines/engine[0]/running", 0)};
    settimer(eng_off, timer+1);
    var eng_on = func {setprop("/engines/engine[0]/running", 1)};
    settimer(eng_on, timer+2.5);
  };
},1);

setlistener("/engines/engine[0]/rev-strain", func(n) {
  cough2=n.getValue();
  if(cough2 > 175000 ){
    var timer = rand()*7;
    var eng_off = func {setprop("/engines/engine[0]/running", 0)};
    settimer(eng_off, timer+1);
    var eng_on = func {setprop("/engines/engine[0]/running", 1)};
    settimer(eng_on, timer+2.5);
  };
},1);



main_loop = func {

### kill engine when overreved
  var rev2 = getprop("/engines/engine[0]/rpm");
  var rstrain = getprop("/engines/engine[0]/rev-strain");

  if (rstrain > 350000) {
    setprop("/engines/engine[0]/overrev", 1);
    setprop("/engines/engine[0]/running", 0);
    setprop("/engines/engine[0]/out-of-fuel",1);
    setprop("/consumables/fuel/tank[0]/selected",0);
    setprop("/consumables/fuel/tank[1]/selected",0);
  }

  if (rev2 > 2400) {
    if (rev2 > 2600) {
      var strain = rev2 - 2550;
    }else{
      var strain = 0.1 * (rev2 - 2400);
    }
    setprop("/engines/engine[0]/rev-strain", rstrain + strain);
  }

### coolant temp
  if (getprop("/engines/engine[0]/running") == 1) {
    var rev = getprop("/engines/engine[0]/rpm");
    var thr = getprop("/engines/engine[0]/prop-thrust");
    var ct = getprop("/engines/engine[0]/cyl-temp");
    var cp = getprop("/controls/engines/engine[0]/cowl-flaps-norm");
    var as = getprop("/velocities/airspeed-kt");
    var egt = 0.55 * (getprop("/engines/engine[0]/egt-degf") - 32);
    var et0 = getprop("/environment/temperature-degc");
    var mp = getprop("/engines/engine[0]/mp-osi");
    var mix = getprop("/controls/engines/engine[0]/mixture");
    var visc = getprop("/engines/engine[0]/oil-visc");
    var seizure = getprop("/engines/engine[0]/seize-strain");
    var press1 = getprop("/engines/engine[0]/oil-press");
    #carb temperature
    var cbt = et0 + 0.66 * mp;
    interpolate ("/engines/engine[0]/carb-temp-degc", cbt, 10);
    #cyl-head temperature
    var temp = 2.6 * cbt + 0.32 * rev + 0.5 * egt - 0.0025 * as * as - 0.068 * thr * (1.25 * cp + 0.1) - 20 * mix;
    interpolate ("/engines/engine[0]/cyl-temp", temp* 0.4, 10);
    #oil temperature
    var otemp = getprop("/engines/engine[0]/oil-temp");
    var dtemp =  0.225 *temp + 0.18 *et0 - 1.375 *otemp;
    var newtemp = (otemp + dtemp);
    interpolate ("/engines/engine[0]/oil-temp" , newtemp, 10);

    var otemp1 = getprop("/engines/engine[0]/oil-temp-ind");
    if (otemp1 > 120.0) {
      var strain1 = (otemp1 - 120.0)/15.0;
      setprop("/engines/engine[0]/seize-strain", seizure + strain1);
      setprop("/engines/engine[0]/oil-visc", visc - 0.003);
    }

### oil and viscosity
    if (visc < 1.0 ) {
      setprop("/engines/engine[0]/oil-visc", visc + 0.003);
      if (rev2 > 1200) {
	setprop("/engines/engine[0]/rev-strain", rstrain + (550/visc));
      }
    }

    if (rev > 100){
      if (rev > 2500) {
	press1 = press1 + 0.25;
      }else{
	press1 = 10.5 - 5 * (1-visc);
      }
      interpolate("/engines/engine[0]/oil-press", press1, 3);
    }

    if (seizure > 1000) {
      setprop("/engines/engine[0]/seized", 1);
      setprop("/engines/engine[0]/running", 0);
      setprop("/engines/engine[0]/out-of-fuel",1);
      setprop("/consumables/fuel/tank[0]/selected",0);
      setprop("/consumables/fuel/tank[1]/selected",0);
    }
  }

  settimer(main_loop, 0.2)
}

oil_temp_ind = func{
  var oiltempinst = getprop("/engines/engine[0]/oil-temp");
  interpolate("/engines/engine[0]/oil-temp-ind", oiltempinst, 7.5);
  settimer(oil_temp_ind, 7.5);
}

starter = func {
  var starter_power = getprop("/systems/electrical/volts");
  if (arg[0] == 1){
    if( starter_power > 0){
      setprop("/controls/engines/engine[0]/starter",1);
    }
  }else{
    setprop("/controls/engines/engine[0]/starter",0);
  }
}