// sidstar.hxx - a class to store and maintain data for SID and STAR
// procedures. 
// Written by Durk Talsma, started March 2009.
//
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//
// $Id: sidstar.hxx,v 1.1 2009/03/08 17:14:25 durk Exp $


#ifndef _SIDSTAR_HXX_
#define _SIDSTAR_HXX_

#include <string>

#include <simgear/misc/sg_path.hxx>

#include <simgear/xml/easyxml.hxx>

#include <ATC/trafficcontrol.hxx>
#include <AIModel/AIFlightPlan.hxx>
#include "parking.hxx"
#include "groundnetwork.hxx"
#include "runwayprefs.hxx"


using std::string;

class FGAirport;

typedef vector<FGAIFlightPlan*>           FlightPlanVec;
typedef vector<FGAIFlightPlan*>::iterator FlightPlanVecIterator;

typedef std::map < std::string, FlightPlanVec > FlightPlanVecMap;


class FGSidStar 
{
   private:
      string id;
      bool initialized;
      FlightPlanVecMap data;

   public:
      FGSidStar(FGAirport *ap);
      FGSidStar(const FGSidStar &other);

      string getId() { return id; };
      void load(SGPath path);
      FGAIFlightPlan *getBest(string activeRunway, double heading);
};



#endif