/* ===========================================================
 * FgfsSharp project - 2008/11/17
 * Built with -
 * Microsoft Visual Studio 2005 - Version 8.0.50727.762  (SP.050727-7600)
 * Microsoft .NET Framework - Version 2.0.50727 SP1
 * Installed Edition: C# Express - Microsoft Visual C# 2005
 * 
 * Original from: http://linkslink.wordpress.com/a-gentle-start/
 * Many thanks for that start ...
 * 
 * The original used SpeechLib (http://code.google.com/p/speechlib/source/checkout)
 * BUT, this ALSO required Boost (http://www.boost.org/), which is a massive checkout
 * 
 * SO, I opted for Microsoft Speech API (SAPI) instead, but this MAY require
 * a download of the SDK 5.1 (http://msdn.microsoft.com/en-us/library/ms723627.aspx)
 * It seems quite OLD, circa 2001-2005, but seems to work fine. This was in XP.
 * 
 * NOTE: When compiled in Vista, using MSVC9 (2008), it appears this Speech library
 * is aleady available, but the 'compile' showed some 57 warnings, mainly about
 * 'cannot be marshalled ... may require unsafe code to manipulate', but NO errors
 * and it seemed to run FINE ;=()
 * 
 * If you do NOT want to include this, then you can undefine the USING_MS_SAPI
 * and maybe remove the SpeechLib in Solution Explorer -> References
 * 
 * TO RUN this application WITH speech, you must also have the
 * Interop.SpeechLib.dll, or the DLL registered ... and it is kind of cute
 * to have the ATC message SPOKEN ;=)) as it should be ...
 * 
 * Also, while the enumeration of the machine IPs often yields the current
 * IP perhaps assigned by your router, I used the localhost IP 127.0.0.1 mostly.
 * 
 * Open Source
 * 2008/11/17 - geoff mclane - http://geoffair.net/fg/
 * =========================================================== */

#define USING_MS_SAPI

#region Usings
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Collections;
using System.IO;
using System.IO.Ports;
#if USING_MS_SAPI
using SpeechLib;    // Requires MS Speech SDK - and COM ref. added
#endif
#endregion 

namespace FgfsSharp
{
    public partial class FgfsMainForm : Form, IObserver
    {
        public delegate void UpdateObserverDelegate(FgfsDataObject dataObject);

        #region Privates

        private FgfsServer _server;
        private FgfsDataObject _dataObject;
        private FgfsDataHelper _dataHelper;
        private ArrayList _registredDisplays;
        private SerialPort _sPort;
        private FgfsLog _swLog = null;

        private byte[] _byteArray = new byte[3];
        private int _pitchLevel;
        private int _leftRoll;
        private MenuStrip menuStrip1;
        private ToolStripMenuItem fileToolStripMenuItem;
        private ToolStripMenuItem exitToolStripMenuItem;
        private GroupBox groupBox1;
        private CheckBox _soundCheckBox;
        private CheckBox _rs232CheckBox;
        private GroupBox groupBox2;
        private ComboBox IpComboBox;
        private TextBox PortBox;
        private Label label1;
        private Button _startBtn;
        private GroupBox groupBox3;
        private TrackBar PitchBar;
        private TrackBar RollBar;
        private Label label3;
        private Label label2;
        private TextBox AltitudeBox;
        private TextBox SpeedBox;
        private Label ChoosePortLabel;
        private TextBox LogTextBox;
        private CheckBox LogFileBox;
        private TextBox fgfsMessageBox;
        private Timer timer1;
        private IContainer components;
        private int _rightRoll;
        private TextBox TimerBox;
        private Label label4;
        private Button button1;
        private Label label5;
        private TextBox MsgCntBox;
        private long _timerticks = 0;
        private long _messagecount = 0;
        private int _max_pitch, _min_pitch;
        private int _max_roll, _min_roll;
        private int pitch_scale, roll_scale;
        private int pitch_scale2, roll_scale2;
        private int pitch_max, pitch_min, roll_max, roll_min;
        private TextBox TimeBox;

        // Speech SDK
#if USING_MS_SAPI
        private SpeechVoiceSpeakFlags SpFlags;
        private SpVoice ms_Voice;
        private string _last_spoken;
        //private SpeechLib.SpVoice _speechObj;
#endif
        private TextBox RollValBox;
        private Label label7;
        private Label label6;
        private TextBox PitchValBox;
        #endregion

        #region Properties

        private FgfsServer Server
        {
            get { return _server; }
            set { _server = value; }
        }

        private FgfsDataObject DataObject
        {
            get { return _dataObject; }
            set { _dataObject = value; }
        }

        private FgfsDataHelper DataHelper
        {
            get { return _dataHelper; }
        }

        #endregion

        #region Constructor

        public FgfsMainForm()
        {
            Console.WriteLine("Constructor: FgfsMainForm");

            InitializeComponent();
            InitializePrivates();

            //register the window as observer
            DataObject.RegisterObserver(this);
        }

        #endregion

        #region IObserver - Methods
        public void UpdateObserver(FgfsDataObject dataObject)
        {
            if (this.InvokeRequired == false)
            {
                DataObject = dataObject;
                DisplayData();
            }
            else
            {
                UpdateObserverDelegate updateDelegate = new UpdateObserverDelegate(UpdateObserver);
                this.BeginInvoke(updateDelegate, new object[] { dataObject });
            }
        }

        public void DisplayData()
        {
            int npitch, nroll;
            try
            {
                _messagecount++;
                MsgCntBox.Text = _messagecount.ToString();

                //update the visual displays
                SpeedBox.Text = DataObject.Speed.ToString();
                AltitudeBox.Text = DataObject.Altitude.ToString();

                int pitch = DataObject.Pitch;
                int roll = DataObject.Roll;
                // get MAX/MIN values
                // Pitch has MAX  90, MIN  -90
                // Roll  has MAX 180, MIN -180
                if (pitch > _max_pitch)
                    _max_pitch = pitch;
                if (pitch < _min_pitch)
                    _min_pitch = pitch;
                if (roll > _max_roll)
                    _max_roll = roll;
                if (roll < _min_roll)
                    _min_roll = roll;
                // The sliders are set to a scale of 0 to 10 
                // Modify pitch and roll to values 0 to 10
                // (maybe should be larger, and would love a log scale)
                npitch = pitch_min + pitch_scale2 +
                    (int)(((double)pitch / 90.0) * (double)pitch_scale2);
                nroll = roll_min + roll_scale2 + 
                    (int)(((double)roll / 180.0) * (double)roll_scale2);

                // show actual value received
                this.RollValBox.Text = roll.ToString();
                this.PitchValBox.Text = pitch.ToString();
                // set sliders per modified values
                SetBar(nroll, ref RollBar);
                SetBar(npitch, ref PitchBar);

                if (this._sPort != null)
                {
                    this.setModelOrientation(RollBar.Value, PitchBar.Value, ref this._byteArray);
                    this._sPort.Write(this._byteArray, 0, 3);
                }
                if (this._swLog != null)
                {
                    this._swLog.LogWrite(DataObject.Message);
                }

                fgfsMessageBox.Text = DataObject.ATC;

#if USING_MS_SAPI
                if (Wants_Speech() && (_last_spoken != DataObject.ATC))
                {
                    _last_spoken = DataObject.ATC;
                    this.ms_Voice.Speak(_last_spoken, SpFlags);
                }
#endif
            }
            catch (Exception portException)
            {
                Console.WriteLine("DisplayData:Exception: " + portException.Message);
            }
        }

        #endregion

        #region Private Methods

        private void InitializePrivates()
        {
            Console.WriteLine("Init the privates ...");
            //init the privates
            _dataObject = new FgfsDataObject();
            _dataHelper = new FgfsDataHelper(_dataObject);
            _registredDisplays = new ArrayList();
            //_display = new FgfsDisplay();

#if USING_MS_SAPI
            // MS Speech SDK
            //SpeechVoiceSpeakFlags SpFlags = SpeechVoiceSpeakFlags.SVSFlagsAsync;
            SpFlags = SpeechVoiceSpeakFlags.SVSFlagsAsync;
            ms_Voice = null;
            //this._speechObj = null;
#else
            this._soundCheckBox.Enabled = false;
#endif

            this._sPort = null;
            this._swLog = null;

            //prepare the gui
            IpComboBox.DataSource = FgfsServer.DeterminePossibleIPs();

            // initialize pitch/roll max/min
            _max_pitch = -1;
            _min_pitch = 999999;
            _max_roll = -1;
            _min_roll = 999999;

            pitch_max = this.PitchBar.Maximum;
            pitch_min = this.PitchBar.Minimum;
            roll_max = this.RollBar.Maximum;
            roll_min = this.RollBar.Minimum;
            pitch_scale = pitch_max - pitch_min;
            roll_scale = roll_max - roll_min;
            pitch_scale2 = pitch_scale / 2;
            roll_scale2 = roll_scale / 2;
            Console.WriteLine("pitch {0} {1} {2} {3} roll {4} {5} {6} {7}",
                pitch_min, pitch_max, pitch_scale, pitch_scale2,
                roll_min, roll_max, roll_scale, roll_scale2);

        }

        #endregion

#if USING_MS_SAPI
        private bool Wants_Speech()
        {
            if ((this._soundCheckBox.Checked == true) && (ms_Voice != null))
            {
                return true;
            }
            return false;
        }
#endif

        private bool Is_Server_Running()
        {
            if (this._startBtn.Text == "Stop Server")
            {
                return true;
            }
            return false;
        }

        private void Stop_Server()
        {
            string msg = "Stopping server.";
#if USING_MS_SAPI
            if (Wants_Speech())
                ms_Voice.Speak(msg, SpFlags);
#endif
            Console.WriteLine(msg);
            Server = FgfsServer.GetInstance();
            Server.SuspendServer();
            this._startBtn.Text = "Start Server";
            ChoosePortLabel.Visible = true;
            _timerticks = 0;    // restart the seconds counter
            _messagecount = 0;
        }

        private void Start_Server()
        {
            ChoosePortLabel.Visible = false;
            string ip = IpComboBox.SelectedItem.ToString();
            int port = Convert.ToInt32(PortBox.Text);

            Server = FgfsServer.GetInstance();
            Server.StartServer(ip, port, DataHelper);

#if USING_MS_SAPI
            if (Wants_Speech())
            {
                string speechOut = string.Format("Server I.P. is {0}, on Port {1}", ip, port);
                this.ms_Voice.Speak(speechOut, SpFlags);
                //this._speechObj.Speak(speechOut, SpeechLib.SpeechVoiceSpeakFlags.SVSFDefault);
                //this._speechObj.WaitUntilDone(5000000);
            }
#endif
            //this._startBtn.Enabled = false;
            this._startBtn.Text = "Stop Server";
            _timerticks = 0;    // restart the seconds counter
            _messagecount = 0;
        }

        #region UI - HandlerMethods


        private void _startBtn_Click(object sender, EventArgs e)
        {
            if (Is_Server_Running())
            {
                Stop_Server();
            }
            else
            {
                // start server
                if (PortBox.Text != string.Empty)
                {
                    Start_Server();
                }
                else
                {
                    ChoosePortLabel.Visible = true;
                }
            }
        }

        #endregion

        private void Application_Exit()
        {
            string tmsg = "Bye! for now...";
            if (Is_Server_Running())
            {
                Stop_Server();
            }
            if (Is_Log_Running())
            {
                if (_swLog != null)
                {
                    Close_Log_File();
                }
            }

            Console.Write(tmsg);
#if USING_MS_SAPI
            if (Wants_Speech())
            {
                this.ms_Voice.Speak(tmsg, SpFlags);
                this.ms_Voice.WaitUntilDone(5000);
            }
#endif
            // this.Dispose(); // maybe NOT required
            Application.Exit();
        }

        #region Menu
        private void exitToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Application_Exit();
        }

        /* ==========================
        private void optionsToolStripMenuItem_Click(object sender, EventArgs e)
        {
            FgfsOptionView OptionView = new FgfsOptionView();
            OptionView.ShowDialog();
        }

        private void exitToolStripMenuItem_Click(object sender, EventArgs e)
        {
            this.Hide();
            this.TrayIcon.Visible = true;
        }

        private void TrayIcon_MouseDoubleClick(object sender, MouseEventArgs e)
        {
            this.Show();
            this.TrayIcon.Visible = false;
        }

        private void aboutToolStripMenuItem1_Click(object sender, EventArgs e)
        {
            AboutDialog aboutDialog = new AboutDialog();
            aboutDialog.Show();
        }
        =================== */

        #endregion

        private void _soundCheckBox_CheckedChanged(object sender, EventArgs e)
        {
            if (this._soundCheckBox.Checked == true)
            {
#if USING_MS_SAPI
                string msg = "Voice setup done...";
                try
                {
                    this.ms_Voice = new SpVoice();
                    this.ms_Voice.Speak(msg, SpFlags);
                    //this._speechObj = new SpeechLib.SpVoice();
                    //SpeechVoiceSpeakFlags SpFlags = SpeechVoiceSpeakFlags.SVSFlagsAsync;
                }
                catch (Exception SpeechException)
                {
                    string failureMessage = string.Format("Something with the Speech-Output ran out of control: {0}", SpeechException.Message);
                    this._soundCheckBox.Checked = false;
                    MessageBox.Show(failureMessage);
                }
#endif
            }
            else
            {
                // leave this until EXIT
                //this._speechObj = null;
            }

        }

        private void _rs232CheckBox_CheckedChanged(object sender, EventArgs e)
        {
            if (this._rs232CheckBox.Checked == true)
            {
                try
                {
                    this._sPort = new SerialPort();
                    this._sPort.BaudRate = 9600;
                    this._sPort.Open();
                }
                catch (Exception portException)
                {
                    string failureMessage = string.Format("Your COM-Port FAILED: {0}", portException.Message);
                    this._rs232CheckBox.Checked = false;
                    MessageBox.Show(failureMessage);
                }
            }
            else
            {
                if (this._sPort != null)
                {
                    this._sPort.Close();
                    this._sPort.Dispose();
                    this._sPort = null;
                }
            }
        }

        private bool Is_Log_Running()
        {
            if (this.LogFileBox.Checked == true)
            {
                return true;
            }
            return false;
        }

        private void Close_Log_File()
        {
            string maxmin = string.Format("END: Pitch max={0} min={1}, Roll max={2} min={3}",
                _max_pitch.ToString(), _min_pitch.ToString(),
                _max_roll.ToString(), _min_roll.ToString());
            _swLog.LogWrite(maxmin);
            _swLog.Close();
            _swLog = null;
        }

        private void LogFileBox_CheckedChanged(object sender, EventArgs e)
        {
            if (Is_Log_Running())
            {
                // create output stream writer, if OUTPUT file given
                string file = LogTextBox.Text;
                if ((file.Length > 0) && (file != "<add file name>"))
                {
                    _swLog = new FgfsLog(file);
                    _swLog.AddTime = true;  // add TIME to messages
                }
                else
                {
                    LogTextBox.Text = "<add file name>";
                }
            }
            else
            {
                // close output stream writer
                if (_swLog != null)
                {
                    Close_Log_File();
                }
            }
        }

        public void WriteLog(string incoming)
        {
            if (_swLog != null)
            {
                _swLog.LogWrite(incoming);
            }
        }

        private void SetBar(int value, ref System.Windows.Forms.TrackBar bar)
        {
            if (value >= 0)
            {
                if (value > bar.Minimum)
                {
                    if (value < bar.Maximum)
                    {
                        bar.Value = value;
                    }
                    else
                    {
                        bar.Value = bar.Maximum;
                    }
                }
                else 
                {
                    bar.Value = bar.Minimum; 
                }
            }
        }

        private void setModelOrientation(int roll, int pitch, ref byte[] byteArray)
        {

            //right turn, so rigth side must be pulled down

            if (roll > 0)
            {
                _rightRoll = (int)160 - roll / 2;
                _leftRoll = (int)225 + roll / 2;

            }
            else if (roll < 0)
            {
                _pitchLevel = (int)95 + pitch / 2;
                _leftRoll -= (int)pitch / 2;
                _rightRoll -= (int)pitch / 2;
            }   //and if the value equals null, set the motor to mid-position
            else
            {
                _pitchLevel = 95;
            }

            byteArray[0] = byte.Parse(_leftRoll.ToString());
            byteArray[1] = byte.Parse(_rightRoll.ToString());
            byteArray[2] = byte.Parse(_pitchLevel.ToString());
        }

        #region Initialize
        private void InitializeComponent()
        {
            this.components = new System.ComponentModel.Container();
            this.menuStrip1 = new System.Windows.Forms.MenuStrip();
            this.fileToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.exitToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.groupBox1 = new System.Windows.Forms.GroupBox();
            this.LogTextBox = new System.Windows.Forms.TextBox();
            this.LogFileBox = new System.Windows.Forms.CheckBox();
            this._rs232CheckBox = new System.Windows.Forms.CheckBox();
            this._soundCheckBox = new System.Windows.Forms.CheckBox();
            this.groupBox2 = new System.Windows.Forms.GroupBox();
            this.ChoosePortLabel = new System.Windows.Forms.Label();
            this._startBtn = new System.Windows.Forms.Button();
            this.PortBox = new System.Windows.Forms.TextBox();
            this.label1 = new System.Windows.Forms.Label();
            this.IpComboBox = new System.Windows.Forms.ComboBox();
            this.groupBox3 = new System.Windows.Forms.GroupBox();
            this.label7 = new System.Windows.Forms.Label();
            this.label6 = new System.Windows.Forms.Label();
            this.PitchValBox = new System.Windows.Forms.TextBox();
            this.RollValBox = new System.Windows.Forms.TextBox();
            this.TimeBox = new System.Windows.Forms.TextBox();
            this.fgfsMessageBox = new System.Windows.Forms.TextBox();
            this.label3 = new System.Windows.Forms.Label();
            this.label2 = new System.Windows.Forms.Label();
            this.AltitudeBox = new System.Windows.Forms.TextBox();
            this.SpeedBox = new System.Windows.Forms.TextBox();
            this.PitchBar = new System.Windows.Forms.TrackBar();
            this.RollBar = new System.Windows.Forms.TrackBar();
            this.timer1 = new System.Windows.Forms.Timer(this.components);
            this.TimerBox = new System.Windows.Forms.TextBox();
            this.label4 = new System.Windows.Forms.Label();
            this.button1 = new System.Windows.Forms.Button();
            this.label5 = new System.Windows.Forms.Label();
            this.MsgCntBox = new System.Windows.Forms.TextBox();
            this.menuStrip1.SuspendLayout();
            this.groupBox1.SuspendLayout();
            this.groupBox2.SuspendLayout();
            this.groupBox3.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.PitchBar)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.RollBar)).BeginInit();
            this.SuspendLayout();
            // 
            // menuStrip1
            // 
            this.menuStrip1.Items.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this.fileToolStripMenuItem});
            this.menuStrip1.Location = new System.Drawing.Point(0, 0);
            this.menuStrip1.Name = "menuStrip1";
            this.menuStrip1.Size = new System.Drawing.Size(322, 24);
            this.menuStrip1.TabIndex = 0;
            this.menuStrip1.Text = "menuStrip1";
            // 
            // fileToolStripMenuItem
            // 
            this.fileToolStripMenuItem.DropDownItems.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this.exitToolStripMenuItem});
            this.fileToolStripMenuItem.Name = "fileToolStripMenuItem";
            this.fileToolStripMenuItem.Size = new System.Drawing.Size(35, 20);
            this.fileToolStripMenuItem.Text = "File";
            // 
            // exitToolStripMenuItem
            // 
            this.exitToolStripMenuItem.Name = "exitToolStripMenuItem";
            this.exitToolStripMenuItem.Size = new System.Drawing.Size(103, 22);
            this.exitToolStripMenuItem.Text = "Exit";
            this.exitToolStripMenuItem.Click += new System.EventHandler(this.exitToolStripMenuItem_Click);
            // 
            // groupBox1
            // 
            this.groupBox1.Controls.Add(this.LogTextBox);
            this.groupBox1.Controls.Add(this.LogFileBox);
            this.groupBox1.Controls.Add(this._rs232CheckBox);
            this.groupBox1.Controls.Add(this._soundCheckBox);
            this.groupBox1.Location = new System.Drawing.Point(13, 28);
            this.groupBox1.Name = "groupBox1";
            this.groupBox1.Size = new System.Drawing.Size(297, 93);
            this.groupBox1.TabIndex = 1;
            this.groupBox1.TabStop = false;
            this.groupBox1.Text = "Options";
            // 
            // LogTextBox
            // 
            this.LogTextBox.Location = new System.Drawing.Point(83, 16);
            this.LogTextBox.Name = "LogTextBox";
            this.LogTextBox.Size = new System.Drawing.Size(208, 20);
            this.LogTextBox.TabIndex = 3;
            this.LogTextBox.Text = "tempFgfsLog.txt";
            // 
            // LogFileBox
            // 
            this.LogFileBox.AutoSize = true;
            this.LogFileBox.Location = new System.Drawing.Point(8, 19);
            this.LogFileBox.Name = "LogFileBox";
            this.LogFileBox.Size = new System.Drawing.Size(69, 17);
            this.LogFileBox.TabIndex = 2;
            this.LogFileBox.Text = "Log File: ";
            this.LogFileBox.UseVisualStyleBackColor = true;
            this.LogFileBox.CheckedChanged += new System.EventHandler(this.LogFileBox_CheckedChanged);
            // 
            // _rs232CheckBox
            // 
            this._rs232CheckBox.AutoSize = true;
            this._rs232CheckBox.Location = new System.Drawing.Point(8, 42);
            this._rs232CheckBox.Name = "_rs232CheckBox";
            this._rs232CheckBox.Size = new System.Drawing.Size(127, 17);
            this._rs232CheckBox.TabIndex = 1;
            this._rs232CheckBox.Text = "Enable COM1 Output";
            this._rs232CheckBox.UseVisualStyleBackColor = true;
            this._rs232CheckBox.CheckedChanged += new System.EventHandler(this._rs232CheckBox_CheckedChanged);
            // 
            // _soundCheckBox
            // 
            this._soundCheckBox.AutoSize = true;
            this._soundCheckBox.Location = new System.Drawing.Point(8, 65);
            this._soundCheckBox.Name = "_soundCheckBox";
            this._soundCheckBox.Size = new System.Drawing.Size(208, 17);
            this._soundCheckBox.TabIndex = 0;
            this._soundCheckBox.Text = "Enable FlightGear Message to Speech";
            this._soundCheckBox.UseVisualStyleBackColor = true;
            this._soundCheckBox.CheckedChanged += new System.EventHandler(this._soundCheckBox_CheckedChanged);
            // 
            // groupBox2
            // 
            this.groupBox2.Controls.Add(this.ChoosePortLabel);
            this.groupBox2.Controls.Add(this._startBtn);
            this.groupBox2.Controls.Add(this.PortBox);
            this.groupBox2.Controls.Add(this.label1);
            this.groupBox2.Controls.Add(this.IpComboBox);
            this.groupBox2.Location = new System.Drawing.Point(12, 127);
            this.groupBox2.Name = "groupBox2";
            this.groupBox2.Size = new System.Drawing.Size(298, 108);
            this.groupBox2.TabIndex = 2;
            this.groupBox2.TabStop = false;
            this.groupBox2.Text = "Server Settings";
            // 
            // ChoosePortLabel
            // 
            this.ChoosePortLabel.AutoSize = true;
            this.ChoosePortLabel.Location = new System.Drawing.Point(6, 22);
            this.ChoosePortLabel.Name = "ChoosePortLabel";
            this.ChoosePortLabel.Size = new System.Drawing.Size(120, 13);
            this.ChoosePortLabel.TabIndex = 4;
            this.ChoosePortLabel.Text = "Choose Server and Port";
            // 
            // _startBtn
            // 
            this._startBtn.Location = new System.Drawing.Point(6, 65);
            this._startBtn.Name = "_startBtn";
            this._startBtn.Size = new System.Drawing.Size(286, 37);
            this._startBtn.TabIndex = 3;
            this._startBtn.Text = "Start Server";
            this._startBtn.UseVisualStyleBackColor = true;
            this._startBtn.Click += new System.EventHandler(this._startBtn_Click);
            // 
            // PortBox
            // 
            this.PortBox.Location = new System.Drawing.Point(202, 39);
            this.PortBox.Name = "PortBox";
            this.PortBox.Size = new System.Drawing.Size(91, 20);
            this.PortBox.TabIndex = 2;
            this.PortBox.Text = "5555";
            // 
            // label1
            // 
            this.label1.AutoSize = true;
            this.label1.Location = new System.Drawing.Point(178, 41);
            this.label1.Name = "label1";
            this.label1.Size = new System.Drawing.Size(18, 13);
            this.label1.TabIndex = 1;
            this.label1.Text = "@";
            // 
            // IpComboBox
            // 
            this.IpComboBox.FormattingEnabled = true;
            this.IpComboBox.Location = new System.Drawing.Point(7, 38);
            this.IpComboBox.Name = "IpComboBox";
            this.IpComboBox.Size = new System.Drawing.Size(166, 21);
            this.IpComboBox.TabIndex = 0;
            this.IpComboBox.Text = "127.0.0.1";
            // 
            // groupBox3
            // 
            this.groupBox3.Controls.Add(this.label7);
            this.groupBox3.Controls.Add(this.label6);
            this.groupBox3.Controls.Add(this.PitchValBox);
            this.groupBox3.Controls.Add(this.RollValBox);
            this.groupBox3.Controls.Add(this.TimeBox);
            this.groupBox3.Controls.Add(this.fgfsMessageBox);
            this.groupBox3.Controls.Add(this.label3);
            this.groupBox3.Controls.Add(this.label2);
            this.groupBox3.Controls.Add(this.AltitudeBox);
            this.groupBox3.Controls.Add(this.SpeedBox);
            this.groupBox3.Controls.Add(this.PitchBar);
            this.groupBox3.Controls.Add(this.RollBar);
            this.groupBox3.Location = new System.Drawing.Point(12, 241);
            this.groupBox3.Name = "groupBox3";
            this.groupBox3.Size = new System.Drawing.Size(298, 169);
            this.groupBox3.TabIndex = 3;
            this.groupBox3.TabStop = false;
            this.groupBox3.Text = "Controls";
            // 
            // label7
            // 
            this.label7.AutoSize = true;
            this.label7.Location = new System.Drawing.Point(8, 111);
            this.label7.Name = "label7";
            this.label7.Size = new System.Drawing.Size(14, 13);
            this.label7.TabIndex = 12;
            this.label7.Text = "P";
            // 
            // label6
            // 
            this.label6.AutoSize = true;
            this.label6.Location = new System.Drawing.Point(8, 69);
            this.label6.Name = "label6";
            this.label6.Size = new System.Drawing.Size(15, 13);
            this.label6.TabIndex = 11;
            this.label6.Text = "R";
            // 
            // PitchValBox
            // 
            this.PitchValBox.Location = new System.Drawing.Point(28, 108);
            this.PitchValBox.Name = "PitchValBox";
            this.PitchValBox.ReadOnly = true;
            this.PitchValBox.Size = new System.Drawing.Size(32, 20);
            this.PitchValBox.TabIndex = 10;
            // 
            // RollValBox
            // 
            this.RollValBox.Location = new System.Drawing.Point(28, 66);
            this.RollValBox.Name = "RollValBox";
            this.RollValBox.ReadOnly = true;
            this.RollValBox.Size = new System.Drawing.Size(32, 20);
            this.RollValBox.TabIndex = 9;
            // 
            // TimeBox
            // 
            this.TimeBox.Location = new System.Drawing.Point(9, 143);
            this.TimeBox.Name = "TimeBox";
            this.TimeBox.ReadOnly = true;
            this.TimeBox.Size = new System.Drawing.Size(59, 20);
            this.TimeBox.TabIndex = 8;
            // 
            // fgfsMessageBox
            // 
            this.fgfsMessageBox.Location = new System.Drawing.Point(70, 143);
            this.fgfsMessageBox.Name = "fgfsMessageBox";
            this.fgfsMessageBox.ReadOnly = true;
            this.fgfsMessageBox.Size = new System.Drawing.Size(222, 20);
            this.fgfsMessageBox.TabIndex = 7;
            // 
            // label3
            // 
            this.label3.AutoSize = true;
            this.label3.Location = new System.Drawing.Point(86, 111);
            this.label3.Name = "label3";
            this.label3.Size = new System.Drawing.Size(57, 13);
            this.label3.TabIndex = 6;
            this.label3.Text = "Altitude (ft)";
            // 
            // label2
            // 
            this.label2.AutoSize = true;
            this.label2.Location = new System.Drawing.Point(87, 73);
            this.label2.Name = "label2";
            this.label2.Size = new System.Drawing.Size(56, 13);
            this.label2.TabIndex = 5;
            this.label2.Text = "Speed (kt)";
            // 
            // AltitudeBox
            // 
            this.AltitudeBox.Location = new System.Drawing.Point(163, 108);
            this.AltitudeBox.Name = "AltitudeBox";
            this.AltitudeBox.ReadOnly = true;
            this.AltitudeBox.Size = new System.Drawing.Size(72, 20);
            this.AltitudeBox.TabIndex = 4;
            // 
            // SpeedBox
            // 
            this.SpeedBox.Location = new System.Drawing.Point(165, 70);
            this.SpeedBox.Name = "SpeedBox";
            this.SpeedBox.ReadOnly = true;
            this.SpeedBox.Size = new System.Drawing.Size(72, 20);
            this.SpeedBox.TabIndex = 4;
            // 
            // PitchBar
            // 
            this.PitchBar.Location = new System.Drawing.Point(247, 19);
            this.PitchBar.Name = "PitchBar";
            this.PitchBar.Orientation = System.Windows.Forms.Orientation.Vertical;
            this.PitchBar.Size = new System.Drawing.Size(45, 127);
            this.PitchBar.TabIndex = 1;
            this.PitchBar.Value = 5;
            // 
            // RollBar
            // 
            this.RollBar.Location = new System.Drawing.Point(49, 19);
            this.RollBar.Name = "RollBar";
            this.RollBar.Size = new System.Drawing.Size(166, 45);
            this.RollBar.TabIndex = 0;
            this.RollBar.Value = 5;
            // 
            // timer1
            // 
            this.timer1.Enabled = true;
            this.timer1.Interval = 1000;
            this.timer1.Tick += new System.EventHandler(this.timer1_Tick);
            // 
            // TimerBox
            // 
            this.TimerBox.Location = new System.Drawing.Point(71, 416);
            this.TimerBox.Name = "TimerBox";
            this.TimerBox.ReadOnly = true;
            this.TimerBox.Size = new System.Drawing.Size(44, 20);
            this.TimerBox.TabIndex = 4;
            // 
            // label4
            // 
            this.label4.AutoSize = true;
            this.label4.Location = new System.Drawing.Point(20, 419);
            this.label4.Name = "label4";
            this.label4.Size = new System.Drawing.Size(52, 13);
            this.label4.TabIndex = 5;
            this.label4.Text = "Seconds:";
            // 
            // button1
            // 
            this.button1.Location = new System.Drawing.Point(249, 416);
            this.button1.Name = "button1";
            this.button1.Size = new System.Drawing.Size(61, 20);
            this.button1.TabIndex = 6;
            this.button1.Text = "Exit";
            this.button1.UseVisualStyleBackColor = true;
            this.button1.Click += new System.EventHandler(this.button1_Click);
            // 
            // label5
            // 
            this.label5.AutoSize = true;
            this.label5.Location = new System.Drawing.Point(121, 419);
            this.label5.Name = "label5";
            this.label5.Size = new System.Drawing.Size(50, 13);
            this.label5.TabIndex = 7;
            this.label5.Text = "Updates:";
            // 
            // MsgCntBox
            // 
            this.MsgCntBox.Location = new System.Drawing.Point(175, 417);
            this.MsgCntBox.Name = "MsgCntBox";
            this.MsgCntBox.ReadOnly = true;
            this.MsgCntBox.Size = new System.Drawing.Size(52, 20);
            this.MsgCntBox.TabIndex = 8;
            // 
            // FgfsMainForm
            // 
            this.ClientSize = new System.Drawing.Size(322, 441);
            this.Controls.Add(this.MsgCntBox);
            this.Controls.Add(this.label5);
            this.Controls.Add(this.button1);
            this.Controls.Add(this.label4);
            this.Controls.Add(this.TimerBox);
            this.Controls.Add(this.groupBox3);
            this.Controls.Add(this.groupBox2);
            this.Controls.Add(this.groupBox1);
            this.Controls.Add(this.menuStrip1);
            this.MainMenuStrip = this.menuStrip1;
            this.Name = "FgfsMainForm";
            this.Text = "FgfsSharp";
            this.menuStrip1.ResumeLayout(false);
            this.menuStrip1.PerformLayout();
            this.groupBox1.ResumeLayout(false);
            this.groupBox1.PerformLayout();
            this.groupBox2.ResumeLayout(false);
            this.groupBox2.PerformLayout();
            this.groupBox3.ResumeLayout(false);
            this.groupBox3.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this.PitchBar)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.RollBar)).EndInit();
            this.ResumeLayout(false);
            this.PerformLayout();

        }
        #endregion

        private void timer1_Tick(object sender, EventArgs e)
        {
            _timerticks++;
            TimerBox.Text = _timerticks.ToString();
            Server = FgfsServer.GetInstance();
            if (Server.Status == 2)
            {
                // thread exited
                if (Is_Server_Running())
                {
                    Console.WriteLine("Stopping server, on timer tick...");
                    Stop_Server();
                }
            }
            // TimeBox.Text = DateTime.Now.ToShortTimeString();
            TimeBox.Text = DateTime.Now.ToLongTimeString();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            Application_Exit();
        }

    }
}

