/* ============================================================================
 * circa June 28, 2007 by slink - http://linkslink.wordpress.com/94-fgfsdatahelper/
 * 2008/11/17 - geoff mclane - http://geoffair.net/fg/
 * Added check of split, and ONLY do the 'update' when there is
 * a change in one of the parameters. 
 * ============================================================================ */

#region Usings

using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Net;
using System.Threading;

#endregion

namespace FgfsSharp
{
    //TODO: Documentation
    class FgfsDataHelper
    {
        #region Privates

        private FgfsDataObject _dataObject;
        private string m_atc;
        private int m_speed;
        private int m_altitude;
        private int m_pitch;
        private int m_roll;


        #endregion

        #region Properties

        public FgfsDataObject DataObject
        {
            get { return _dataObject;}
            private set {_dataObject = value;}
        }

        #endregion

        #region Constructor

        public FgfsDataHelper(FgfsDataObject dataObject)
        {
            Console.WriteLine("Constructor: FgfsDataHelper");
            this.DataObject = dataObject;
        }

        #endregion

        #region Interface Methods

        public void UpdateDataObject(StreamReader streamReader)
        {

            string incoming = streamReader.ReadLine();
            // think about using a propery!
            string[] plainData = incoming.Split(new char[] { '|' });
            int leng = plainData.Length;
            int changed = 0;
            if( leng > 0 )
            {
                int nv = Convert.ToInt32(plainData[0]);
                if (nv != m_speed)
                {
                    changed++;
                    m_speed = nv;
                }
                if (leng > 1)
                {
                    nv = Convert.ToInt32(plainData[1]);
                    if (nv != m_altitude)
                    {
                        changed++;
                        m_altitude = nv;
                    }
                    if( leng > 2 )
                    {
                        nv = Convert.ToInt32(plainData[2]);
                        if ( nv != m_pitch )
                        {
                            changed++;
                            m_pitch = nv;
                        }
                        if ( leng > 3 )
                        {
                            nv = Convert.ToInt32(plainData[3]);
                            if ( nv != m_roll )
                            {
                                changed++;
                                m_roll = nv;
                            }
                            if ( leng > 4 )
                            {
                                string atc = plainData[4];
                                if ( atc != m_atc )
                                {
                                    changed++;
                                    m_atc = atc;
                                }
                            }
                        }
                    }
                }
            }
            if ( changed > 0 )
            {
                // ONLY IF SOME CHANGE
                // ===================
                Console.WriteLine("Update: {0}, split {1}",
                    incoming.ToString(),
                    leng.ToString());
                lock (DataObject)
                {
                    DataObject.Message = incoming;  // set the message line
                    DataObject.Speed = m_speed;
                    DataObject.Altitude = m_altitude;
                    DataObject.Pitch = m_pitch;
                    DataObject.Roll = m_roll;
                    DataObject.ATC = m_atc;
                }
                DataObject.NotifyObservers();
            }
            Thread.Sleep(1);
        }

        #endregion 

        #region Public Method (obsolete)

        public void PrintObject()
        {
            Console.WriteLine("Speed: {0}, Alt: {1}", DataObject.Speed, DataObject.Altitude);
        }

        #endregion
    }
}
