// fgio.cpp : Defines the entry point for the console application.
//
#ifndef _CRT_SECURE_NO_WARNINGS
#define _CRT_SECURE_NO_WARNINGS
#endif
#pragma warning(disable:4996)

#include <simgear/compiler.h>
#include <cstdlib>             // atoi()
#include <string>
#include <simgear/debug/logstream.hxx>
#include <simgear/io/iochannel.hxx>
#include <simgear/io/sg_file.hxx>
#include <simgear/io/sg_serial.hxx>
#include <simgear/io/sg_socket.hxx>
#include <simgear/io/sg_socket_udp.hxx>
//#include <simgear/math/sg_types.hxx>
//#include <simgear/timing/timestamp.hxx>
//#include <simgear/misc/strutils.hxx>

#include <time.h> // for clock_t, and more ...
#include "fgio.h"
#include <conio.h>      // for _kbhit() and _getch()

#define  ISNUM(a) (( a >= '0' )&&( a <= '9' ))

// Pauses for a specified number of milliseconds.
void sleep_loop( clock_t wait )
{
   clock_t goal;
   goal = wait + clock();
   while( goal > clock() )
      ;
}
void sleep( clock_t ms )
{
   Sleep(ms);
}

int check_key_available( void )
{
   int chr = _kbhit();
   if(chr)
      chr = _getch();
   return chr;
}


int   kbd_sleep( int secs )
{
   int   chr = check_key_available();
   if(chr)
      return chr;
   int   ms = secs * 1000;
   int   sms;
   if(ms > 100)
      sms = 100;
   else
      sms = ms;
   sleep(sms);
   chr = check_key_available();
   if(chr)
      return chr;
   ms -= sms;
   while(ms)
   {
      if(ms > 100)
         sms = 100;
      else
         sms = ms;
      sleep(sms);
      ms -= sms;
      chr = check_key_available();
      if(chr)
         return chr;
   }
   return chr;
}

int   delay = 3;  // seconds

int   speed = 100;
int   speed_max = 500;
int   speed_min = 0;
int   speed_step = 50;
int   speed_up = 1;

int   height = 50;
int   height_max = 5000;
int   height_min = 0;
int   height_step = 100;
int   height_up = 1;

int   pitch = 5;
int   pitch_max = 90;
int   pitch_min = -90;
int   pitch_step = 10;
int   pitch_up = 1;

int   roll = 5;
int   roll_max = 180;
int   roll_min = -180;
int   roll_step = 15;
int   roll_up = 0;

void get_next_item( int * pcurr, int * pup, int step, int max, int min )
{
   int curr = *pcurr;
   int   up = *pup;
   if(up)
   {
      curr += step;
      if(curr >= max)
      {
         curr = max;
         up = 0;
      }
   }
   else
   {
      curr -= step;
      if(curr <= min)
      {
         curr = min;
         up = 1;
      }
   }
   *pcurr = curr;
   *pup = up;
}

static TCHAR _s_szMess[256];
char * get_message( int cnt )
{
   char * pmsg = _s_szMess;

   get_next_item( &speed, &speed_up, speed_step, speed_max, speed_min );
   get_next_item( &height, &height_up, height_step, height_max, height_min );
   get_next_item( &pitch, &pitch_up, pitch_step, pitch_max, pitch_min );
   get_next_item( &roll, &roll_up, roll_step, roll_max, roll_min );

   sprintf(pmsg, "%d|%d|%d|%d|%d spd=%d hgt=%d pit=%d roll=%d\n",
      speed, height, pitch, roll,
      cnt,
      speed, height, pitch, roll );
   return pmsg;
}

void test_kbd_sleep( int secs )
{
   int   cnt = 0;
   bool pause = false;

         printf("ESC to exit, +/- change delay, p=pause\n" );
         while(1)
         {
            if (! pause )
            {
               cnt++;
               char * pmsg = get_message(cnt);
               printf( "%d: write: %s", cnt, pmsg );
               //sock->write( pmsg, strlen(pmsg) );
            }
            int chr = kbd_sleep( delay );
            if(chr == 0x1b) {
               printf("Exit key ...\n");
               break;
            } else if(chr == '+') {
               delay++;
               printf("Delay increased to %d ...\n", delay);
            } else if(chr == '-') {
               if(delay) delay--;
               printf("Delay decreased to %d ...\n", delay);
            } else if(chr == 'p') {
               pause = !pause;
               printf("Pause is %s ...\n", (pause ? "On" : "Off"));
            }
         }

   exit(1);
}


void test_socket ( string host, string port, string style )
{
   int   cnt = 0;
   bool  pause = false;

   SGSocket *sock = new SGSocket(host, port, style);
   if(sock)
   {
      if( sock->open(SG_IO_OUT) )
      {
         printf( "SGSocket->open(SG_IO_OUT) to %s, on %s, by %s SUCCESS.\n",
            host.c_str(), port.c_str(), style.c_str() );

         printf("ESC to exit, +/- change delay, p=pause\n" );
         while(1)
         {
            if (! pause )
            {
               cnt++;
               char * pmsg = get_message(cnt);
               printf( "%d: write: %s", cnt, pmsg );
               sock->write( pmsg, strlen(pmsg) );
            }
            int chr = kbd_sleep( delay );
            if(chr == 0x1b) {
               printf("Exit key ...\n");
               break;
            } else if(chr == '+') {
               delay++;
               printf("Delay increased to %d ...\n", delay);
            } else if(chr == '-') {
               if(delay) delay--;
               printf("Delay decreased to %d ...\n", delay);
            } else if(chr == 'p') {
               pause = !pause;
               printf("Pause is %s ...\n", (pause ? "On" : "Off"));
            }
         }

         printf( "Written %d messages ...\n", cnt );
         sock->close();
      }
      else
      {
         printf( "SGSocket->open(SG_IO_OUT) to %s, on %s, by %s FAILED!\n",
            host.c_str(), port.c_str(), style.c_str() );
         printf( "Note, the socket reader (server) needs to be running first!\n" );
      }

   }

}

void give_help ( char * pname, const char * pip, const char * pport )
{
   printf( "%s [ip=<address>] [-port=<number>]\n" );
   printf( "Default ip=%s, port=%s\n", pip, pport );
   printf( "Aborting ...\n" );
   exit(0);
}

int _tmain(int argc, _TCHAR* argv[])
{
   string host = "127.0.0.1";
   string port = "5555";
   string style = "tcp";
   printf( "Running %s, compile %s, at %s\n", argv[0], __DATE__, __TIME__ );

   int   i;
   for( i = 1; i < argc; i++)
   {
      char * arg = argv[i];
      if(arg && *arg)
      {
         if(*arg == '-')
         {
            do { arg++; } while (*arg == '-');
            if( strncmp(arg,"ip=", 3) == 0 )
            {
               arg += 3;
               if(*arg == 0)
                  goto Cmd_ERROR;
               host = arg;
            }
            else if( strncmp(arg, "port=", 5) == 0 )
            {
               arg += 5;
               if(*arg == 0)
                  goto Cmd_ERROR;
               if(!ISNUM(*arg))
                  goto Cmd_ERROR;
               port = arg;
            }
            else if( strncmp(arg, "?", 1) == 0 )
            {
               give_help( argv[0], host.c_str(), port.c_str() );
            }
            else
            {
               goto Cmd_ERROR;
            }
         }
         else
         {
Cmd_ERROR:
            printf("ERROR: Unknown argument [%s] ... aborting ...\n", argv[i]);
            exit(1);
         }
      }
   }

//   test_kbd_sleep( 10 );

   test_socket (host, port, style);
   
	return 0;
}

