@setlocal
@echo Zip the binaries...
@set TEMPSGV=01
@set TEMPZ1=SG-%TEMPSGV%-MD-bin.zip
@set TEMPZ2=SG-%TEMPSGV%-MD-lib.zip
@set TEMPZ3=SG-%TEMPSGV%-MD-msvc.zip
@set TEMPZ4=SG-%TEMPSGV%-MD-src.zip

@REM zip the binaries
@set OPT=-a
@if EXIST %TEMPZ1% (
	@set OPT=-u
)
@call zip8 %OPT% -P -r -o -x*.ilk %TEMPZ1% bin\*.*

@REM Zip the static libraries
@set OPT=-a
@if EXIST %TEMPZ2% (
	@set OPT=-u
)
@call zip8 %OPT% -P -r -o %TEMPZ2% lib\*.*

@REM Zip the msvc directory
@set OPT=-a
@if EXIST %TEMPZ3% (
	@set OPT=-u
)
@call zip8 %OPT% -o -x*.zip %TEMPZ3% *.dsw *.dsp *.sln *.vcproj *.bat *.h

@REM Finally, zip the whole source, excluding msvc and temp
@set OPT=-a
@if EXIST %TEMPZ4% (
	@set OPT=-u
)
@if EXIST ..\msvc\zipsg.bat (
@cd ..
@call zip8 %OPT% -p -r -o -xmsvc\*.* -xtemp\*.* msvc\%TEMPZ4% *.*
@cd msvc
) else (
@echo A problem! Can NOT find self at ..\msvc\zipsg.bat!
@pause
)
@echo.
@echo Finally, the LIST of zips created...
@call dirmin %TEMPZ1%
@call dirmin %TEMPZ2%
@call dirmin %TEMPZ3%
@call dirmin %TEMPZ4%

:END
@endlocal


