/* tggui_utils.h
    file: tggui_utils.cpp

    Written by Geoff R. Mclane, started May 2011.

    Copyright (C) 2011  Geoff R. McLane - reports@geoffair.info

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: 0.0.1 2001-05-07 - version 0.0.1 $
    Some utility functions
 */

#ifndef TGGUI_UTILS_H
#define TGGUI_UTILS_H

#include <QString>
#include <QStringList>
#include <QDir>
#include <QMessageBox>
#include <QProcess>
#include <QTime>

#include "newbucket.h"

typedef struct tagLL {
    double lat;
    double lon;
}LL, * PLL;

extern QStringList findFiles(const QString &startDir, QStringList filters, bool recurse = false);
// return
// 1 = Ok was clicked - the default
// 0 = Cancel or otherwise
extern int getYesNo( QString title, QString msg);
// givem millisecond, return appropriate string
extern QString getElapTimeStg(int ms);

// return COUNT of array files found on path <chunk>/<tile>/<index>
extern int countDataFound(QString path, QString selectedMaterials, QString workDirectory);

// is lat,lon in world range
extern bool latlonInWorld( double lat, double lon );

// general test of runninging an application
extern int util_testApplication(QString cmd, QString & msg);
// specfic test for 'wget' application
extern bool util_getWgetVersion(QString & vers);
// specific test for 'fgfs-construct'
extern int util_lookslike_Fgfs_Construct( QString info );
// specific test for 'hgtchop'
extern int util_lookslike_hgtchop( QString info );
// specific test for 'terrafit'
extern int util_lookslike_terrafit( QString info );
// specifci test for 'shape-decode, and hopefully ogr-decode
extern int util_lookslike_shape_decode( QString info );
// specific test for 'genapts'
extern int util_lookslike_genapts( QString info );

// list like from multiple strings like
// array_file = /home/geoff/fg/fg14/scenery/work/SRTM-30/e150s40/e150s31/5410553.arr.gz
extern QStringList util_getArrayFileList(QString info);

// get Date/Time QString of form ("yyyy/MM/dd HH:mm:ss")
extern QString util_getDTstg(void);

/* LOG FILE */
// set log file name
extern void util_setLogFile(QString file);
// create/truncate a log file, and set name
extern bool util_createLogFile(QString file);
// write to that log file, but must do one of above FIRST
extern void outLog(QString s);

// default list of materials
extern QStringList util_getMaterialList(void);
// list of custom scenery shapefiles (mapserver)
extern QStringList util_getCustomShapes(void);

// run a process with 'arguments', in 'dir', if any
extern QString util_runProcess(QString arguments, QString dir,
                               int * pErr = 0);
// rename 'file' to file.OLD, file.BAK, file.BAK1, file.BAK2, etc
// never deletes anything - returns -1 if error
// returns 0 if nothing done, 1 if to .old, if to .bak, 3++ .bak[n]
extern int util_renameToOLDBAK(QString file);
// reconstruct the extension used in above function
extern QString util_getRenameExt(int n);

// verify MAIN PROJECT Directory - with dialog if failed
extern bool util_verifyProjDir(QString path);
// create directory, if not exisitng - with dialog if failed
extern bool util_createDirectory(QString path);

// specialised to extract the output file from wget
// needs more testing
extern QString util_extractZipFile(QString info);

// given say e151s34 - the 1x1 tile id of YSSY, YCOB,
// return lat=-34, lon=151, and true
extern bool util_ValidTileId(QString tileId, PLL pLL);
// say e150s40 - 10x10 chunk id of YSSY, YCOB, ...
extern bool util_ValidChunkId(QString chunkId, PLL pLL);

// remove Cr (\n) from line.
extern void util_CleanLine( QString & line );

// UNDER DEVELOPMENT - put up a TIMED message
extern void timedMessage( QString title, QString msg, int secs);

// this is REALY only for diagnostics - to waste some time only
extern void util_uselessWait(int secs);

// deal with priorities and usgsmap text files
extern QString util_get_UsgsMap_text(void);
extern QString util_get_Default_Priorities_text(void);
extern bool util_ensure_Priorities_Text(QString workDir,
                                 QString defIn,
                                 QString usgsIn);

// extract output file name from fgfs-construct output
extern QStringList util_getOutputFiles( QString info );

// some message get too big for a message box
extern bool util_trimLongMessage( int max, QString & info );


#endif // TGGUI_UTILS_H
// eof - tggui_utils.h
