#!/bin/sh
#< ziptgscenery.sh
# 2011-10-08 - Another minor fix, so version 05
BN=`basename $0`

VERS="05"

ZIP="TgScenery-$VERS".zip
DIR="TgScenery"

if [ ! -f ../$DIR/$BN ]; then
    echo "$BN: ERROR: Can NOT locate [$DIR] directory..."
    exit 1
fi


OPTS="-r -o -x$DIR/TgScenery.pro.user"

echo "$BN: First doing a cleanup of backup file..."
delbu -r
echo "$BN: Done cleanup..."

cd ..
if [ -f "$ZIP" ]; then
    echo "$BN: Zip file already exists! Doing UPDATE only..."
    OPTS="$OPTS -u"
fi

echo "$BN: Doing: zip $OPTS $ZIP $DIR/*"
zip $OPTS $ZIP $DIR/*
if [ ! -f "$ZIP" ]; then
    echo "$BN: Zip file [$ZIP] not created!"
    exit 1
fi
ls -all $ZIP
echo "$BN: Done $ZIP"
cd $DIR
