/* ==================================================
   TgTake2 project
   Created: Geoff R. McLane - Aug 2011
   License: GPL2 (or later)
   ================================================== */
#include "mainwindow.h"

MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent)
{
#ifdef TRY_GLOBAL_SETTINGS
    m_Settings = new QSettings();
    restoreGeometry(m_Settings->value("mainWindowGeometry").toByteArray());
#else
    QSettings settings;
    restoreGeometry(settings.value("mainWindowGeometry").toByteArray());
#endif

    do_quit = false;
    util_setStdLogFile();

    //====================================================
    //** Main Central Widget and Layout
    //====================================================
    QWidget *widget = new QWidget;
    setCentralWidget(widget);

    QVBoxLayout *mainLayout = new QVBoxLayout();
    //mainLayout->setContentsMargins(10, 10, 10, 10);
    mainLayout->setContentsMargins(0, 0, 0, 0);
    mainLayout->setSpacing(0);
    widget->setLayout(mainLayout);

    //== File Menu
    menuFile = new QMenu(tr("&File"));
    //exitAct = menuFile->addAction(QIcon(":/icon/quit"), tr("&Quit"), this, SLOT(on_quit()));
    exitAct = menuFile->addAction(tr("&Quit"), this, SLOT(on_quit()));
    exitAct->setShortcuts(QKeySequence::Quit);
    exitAct->setStatusTip(tr("Quit the application"));
    menuFile->addAction(exitAct);
    //exitAct->setIconVisibleInMenu(true);

    menuHelp = new QMenu(tr("&Help"));
    //exitAct = menuFile->addAction(QIcon(":/icon/quit"), tr("&Quit"), this, SLOT(on_quit()));
    aboutAct = menuHelp->addAction(tr("&About"), this, SLOT(on_about()));
    aboutAct->setStatusTip(tr("Show About dialog"));
    //exitAct->setIconVisibleInMenu(true);
    menuHelp->addAction(tr("About Qt"), this, SLOT(on_about_qt()));

    menuBar()->addMenu(menuFile);
    menuBar()->addMenu(menuHelp);

    // CENTER - Tab Widget
    tabWidget = new QTabWidget(this);

    tabsetup = new tabSetup(this);
    tabWidget->addTab(tabsetup,"Setup");

    tabelevations = new tabElevations(this);
    tabWidget->addTab(tabelevations,"Elevations");

    tablanduse = new tabLanduse(this);
    tabWidget->addTab(tablanduse,"Landuse");

    tabairports = new tabAirports(this);
    tabWidget->addTab(tabairports,"Airports");

    tabconstruction = new tabConstruction(this);
    tabWidget->addTab(tabconstruction,"Constructions");

    tabadvanced = new tabAdvanced(this);
    tabWidget->addTab(tabadvanced,"Advanced");

    mainLayout->addWidget(tabWidget);

    // BOTTOM - Status Bar
    sb = statusBar();
    connect(sb, SIGNAL(messageChanged(QString)),
            this, SLOT(on_message_changed(QString)));
    statusBar()->showMessage("Ready");
    QString msg = util_getTimestg();
    labelTimer = new QLabel(msg);
    //label->setFixedWidth(50);
    labelTimer->setFrameStyle(QFrame::Panel | QFrame::Raised);
    //label->setMargin(1);
    statusBar()->addPermanentWidget(labelTimer);
    timer = new QTimer(this);
    connect(timer, SIGNAL(timeout()), this, SLOT(on_timer()));
    timer->start(1000);

    // now see if any command line over-rulling anything
    processCommands();
}

MainWindow::~MainWindow()
{

}

void MainWindow::closeEvent(QCloseEvent *event)
{
    saveSettings();
    outLog(util_getDateTimestg()+" - Application closeEvent()",0x8001);
    event->accept();
}

void MainWindow::saveSettings()
{
#ifdef TRY_GLOBAL_SETTINGS
    m_Settings->setValue("mainWindowGeometry", saveGeometry());
    m_Settings->setValue("mainWindowState", saveState());
#else
    QSettings settings;
    settings.setValue("mainWindowGeometry", saveGeometry());
    settings.setValue("mainWindowState", saveState());
#endif
}

QString MainWindow::getCommandHelp()
{
    QString msg;
    msg = "Command Help\n";
    msg.append(" --fg-scenery <path>\n");
    msg.append(" --tg-tools <path>\n");
    msg.append(" --fg-root <path>\n");
    msg.append(" --minlat <degs>\n");
    msg.append(" --maxlat <degs>\n");
    msg.append(" --minlon <degs>\n");
    msg.append(" --maxlon <degs>\n");
    return msg;
}


void MainWindow::processCommands()
{
    int i, i2, max;
    QString msg, arg, num;
    QStringList cmd_args = QCoreApplication::arguments();
    max = cmd_args.count();
    bool need_update = false;
    bool need_validate = false;
    for (i = 0; i < max; i++) {
        i2 = i + 1;
        num.sprintf("CMD %2d: ", i2);
        arg = cmd_args.at(i);
        num.append(arg);
        if (i) {
            if ((arg == "--help")||(arg == "-?")||(arg == "-h")) {
                msg = getCommandHelp();
                msg.append("\nAborting on OK");
                if (!do_quit)
                    QMessageBox::information(this,"HELP COMMAND",msg);
                do_quit = true;
            } else if (i2 < max) {
                if (arg == "--fg-scenery") {
                    i++;
                    arg = cmd_args.at(i);
                    num.append(" "+arg);
                    tabsetup->projdirEdit->setText(arg);
                    need_validate = true;
                } else if (arg == "--tg-tools") {
                    i++;
                    arg = cmd_args.at(i);
                    num.append(" "+arg);
                    tabsetup->tgtoolEdit->setText(arg);
                    need_validate = true;
                } else if (arg == "--fg-root") {
                    i++;
                    arg = cmd_args.at(i);
                    num.append(" "+arg);
                    tabsetup->fgrootEdit->setText(arg);
                    need_validate = true;
                } else if (arg == "--minlat") {
                    i++;
                    arg = cmd_args.at(i);
                    num.append(" "+arg);
                    tabsetup->minlatEdit->setText(arg);
                    need_update = true;
                } else if (arg == "--maxlat") {
                    i++;
                    arg = cmd_args.at(i);
                    num.append(" "+arg);
                    tabsetup->maxlatEdit->setText(arg);
                    need_update = true;
                } else if (arg == "--minlon") {
                    i++;
                    arg = cmd_args.at(i);
                    num.append(" "+arg);
                    tabsetup->minlonEdit->setText(arg);
                    need_update = true;
                } else if (arg == "--maxlon") {
                    i++;
                    arg = cmd_args.at(i);
                    num.append(" "+arg);
                    tabsetup->maxlonEdit->setText(arg);
                    need_update = true;
                } else {
                    msg = "Unknown Command ["+arg+"]!\n";
                    msg.append(getCommandHelp());
                    msg.append("\nAborting on OK");
                    if (!do_quit)
                        QMessageBox::critical(this,"BAD COMMAND ARGUMENT",msg);
                    do_quit = true;
                }
            } else {
                msg = "Command ["+arg+"] requires a following argument!\n";
                msg.append(getCommandHelp());
                msg.append("\nAborting on OK");
                if (!do_quit)
                    QMessageBox::critical(this,"BAD COMMAND ARGUMENT",msg);
                do_quit = true;
            }
        }
        outLog(num);
        if (do_quit)
            break;
    }
    if (!do_quit) {
        if (need_validate)
            tabsetup->validate_dirs();
        if (need_update)
            tabsetup->on_range_change(); // fix the ranges
    }
}

void MainWindow::on_quit()
{
    close();
}

void MainWindow::on_about()
{
    QString msg(PGM_NAME);
    msg.append(" Version: ");
    msg.append(PGM_VERSION);
    msg.append(", dated ");
    msg.append(PGM_DATE);
    msg.append("\n");
    msg.append("Built: ");
    msg.append(__DATE__);
    msg.append(" at ");
    msg.append(__TIME__);
    msg.append("\n\n");
    msg.append("TerraGear Scenery Building Tool\n\n");
    msg.append("License: GPL v2 or later\n\n");
    //msg.append("Source: http://geoffair.org/projects/qt_test_gui.htm");
    QMessageBox::about(this, tr("About TgTake2"), msg);
}

void MainWindow::on_about_qt()
{
    QMessageBox::aboutQt(this, "About Qt");
}

void MainWindow::on_timer()
{
    QString msg = util_getTimestg();
    if (do_quit)
        on_quit();
    labelTimer->setText(msg);
}
void MainWindow::on_message_changed(QString msg)
{
    if (msg.isEmpty())
        statusBar()->showMessage("Ready");

}
