/* ==================================================
   TgTake2 project
   Created: Geoff R. McLane - Aug 2011
   License: GPL2 (or later)
   ================================================== */
#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QtGui/QMainWindow>
#include <QSettings>
#include <QCloseEvent>
#include <QCoreApplication>
#include <QVBoxLayout>
#include <QMenu>
#include <QAction>
#include <QMessageBox>
#include <QMenuBar>
#include <QFrame>
#include <QLabel>
#include <QTimer>
#include <QStatusBar>
#include <QTabWidget>
#include <QString>

#include "app_config.h"
#include "tabs/tabsetup.h"
#include "tabs/tabelevations.h"
#include "tabs/tablanduse.h"
#include "tabs/tabairports.h"
#include "tabs/tabconstruction.h"
#include "tabs/tabadvanced.h"

#include "utilities/utilities.h"

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    MainWindow(QWidget *parent = 0);
    ~MainWindow();
    void closeEvent(QCloseEvent *event);
    void saveSettings();
    void processCommands();
#ifdef TRY_GLOBAL_SETTINGS
    QSettings * m_Settings;
#endif
    //= Menu Bar
    QMenu *menuFile;
    //QMenu *menuTest;
    QMenu *menuHelp;
    //= Actions
    QAction *exitAct;
    QAction *aboutAct;

    QTabWidget *tabWidget;

    QLabel *labelTimer;
    QTimer *timer;
    QStatusBar *sb;
    tabSetup *tabsetup;
    tabElevations *tabelevations;
    tabLanduse *tablanduse;
    tabAirports *tabairports;
    tabConstruction *tabconstruction;
    tabAdvanced *tabadvanced;
    bool do_quit;
    QString getCommandHelp();

public slots:
    void on_quit();
    void on_about();
    void on_about_qt();
    void on_timer();
    void on_message_changed(QString);
};

#endif // MAINWINDOW_H
