/* ==================================================
   TgTake2 project
   Created: Geoff R. McLane - Aug 2011
   License: GPL2 (or later)
   ================================================== */
#include "app_config.h"
#include "tabsetup.h"
#include "mainwindow.h"
#include <QSpacerItem>
#include <QSizePolicy>
#include "utilities/srtm_utils.h"
#include "utilities/workThread.h"

tabSetup::tabSetup(QWidget *parent) :
    QWidget(parent)
{
#ifndef TRY_GLOBAL_SETTINGS
    QSettings settings;
#endif
    QString tmp;

    main = (MainWindow *)parent;
    setup_state = 0;

    QVBoxLayout *mainLayout = new QVBoxLayout();
    mainLayout->setContentsMargins(0, 0, 0, 0);
    mainLayout->setSpacing(0);
    setLayout(mainLayout);

    QGridLayout *fileLayout = new QGridLayout;
    fileLayout->setContentsMargins(10, 0, 10, 0);
    fileLayout->setSpacing(0);
    //mainLayout->addLayout(fileLayout);

    QGroupBox *fileGroup = new QGroupBox(tr("Directory Setting - green=ok, red=not valid"));
    // Project directory
    projdirLabel = new QLabel(tr("Project Directory:"));
#ifdef TRY_GLOBAL_SETTINGS
    tmp = main->m_Settings->value(dirsprojectPath,"").toString();
#else
    //tmp = settings.value("dirs/project",DEF_APT810_FILE).toString();
    tmp = settings.value(dirsprojectPath,"").toString();
#endif
    projdirEdit = new QLineEdit(tmp,this);
    connect(projdirEdit,SIGNAL(editingFinished()),this,SLOT(on_projdir_edit()));
    projdirBrowse = new QPushButton("...",this);
    connect(projdirBrowse,SIGNAL(pressed()),this,SLOT(on_projdir_browse()));
    on_projdir_edit();

    // TG Tool directory
    tgtoolLabel = new QLabel(tr("TG Tool Directory:"));
#ifdef TRY_GLOBAL_SETTINGS
    tmp = main->m_Settings->value(dirstgtoolsPath,"").toString();
#else
    //tmp = settings.value("dirs/project",DEF_APT810_FILE).toString();
    tmp = settings.value(dirstgtoolsPath,"").toString();
#endif
    tgtoolEdit = new QLineEdit(tmp,this);
    connect(tgtoolEdit,SIGNAL(editingFinished()),this,SLOT(on_tgtool_edit()));
    tgtoolBrowse = new QPushButton("...",this);
    connect(tgtoolBrowse,SIGNAL(pressed()),this,SLOT(on_tgtool_browse()));
    on_tgtool_edit();

    // FG rool directory
    fgrootLabel = new QLabel(tr("FG Root Directory:"));
#ifdef TRY_GLOBAL_SETTINGS
    tmp = main->m_Settings->value(dirsfgrootPath,"").toString();
#else
    //tmp = settings.value("dirs/project",DEF_APT810_FILE).toString();
    tmp = settings.value(dirsfgrootPath,"").toString();
#endif
    fgrootEdit = new QLineEdit(tmp,this);
    connect(fgrootEdit,SIGNAL(editingFinished()),this,SLOT(on_fgroot_edit()));
    fgrootBrowse = new QPushButton("...",this);
    connect(fgrootBrowse,SIGNAL(pressed()),this,SLOT(on_fgroot_browse()));
    on_fgroot_edit();

    int row = 0;
    fileLayout->addWidget(projdirLabel,row,0);
    fileLayout->addWidget(projdirEdit,row,1);
    fileLayout->addWidget(projdirBrowse,row,2);

    row++;
    fileLayout->addWidget(tgtoolLabel,row,0);
    fileLayout->addWidget(tgtoolEdit,row,1);
    fileLayout->addWidget(tgtoolBrowse,row,2);

    row++;
    fileLayout->addWidget(fgrootLabel,row,0);
    fileLayout->addWidget(fgrootEdit,row,1);
    fileLayout->addWidget(fgrootBrowse,row,2);

    fileGroup->setLayout(fileLayout);
    mainLayout->addWidget(fileGroup);

    QGroupBox *limitsGroup = new QGroupBox(tr("Scenery Limits"));

    mmLabel = new QLabel(tr(""));
    minLabel = new QLabel(tr("Minimum"));
    maxLabel = new QLabel(tr("Maximum"));

    latLabel = new QLabel(tr("Latitude:"));

#ifdef TRY_GLOBAL_SETTINGS
    tmp = main->m_Settings->value(minlatPath,"").toString();
#else
    tmp = settings.value(minlatPath,"").toString();
#endif
    minlatEdit = new QLineEdit(tmp,this);
    connect(minlatEdit, SIGNAL(editingFinished()), this, SLOT(on_range_change()));
    connect(minlatEdit, SIGNAL(textChanged(QString)), this, SLOT(on_range_change()));

#ifdef TRY_GLOBAL_SETTINGS
    tmp = main->m_Settings->value(maxlatPath,"").toString();
#else
    tmp = settings.value(maxlatPath,"").toString();
#endif
    maxlatEdit = new QLineEdit(tmp,this);
    connect(maxlatEdit, SIGNAL(editingFinished()), this, SLOT(on_range_change()));
    connect(maxlatEdit, SIGNAL(textChanged()), this, SLOT(on_range_change()));

    lonLabel = new QLabel(tr("Longitude:"));

#ifdef TRY_GLOBAL_SETTINGS
    tmp = main->m_Settings->value(minlonPath,"").toString();
#else
    tmp = settings.value(minlonPath,"").toString();
#endif
    minlonEdit = new QLineEdit(tmp,this);
    connect(minlonEdit, SIGNAL(editingFinished()), this, SLOT(on_range_change()));
    connect(minlonEdit, SIGNAL(textChanged()), this, SLOT(on_range_change()));

#ifdef TRY_GLOBAL_SETTINGS
    tmp = main->m_Settings->value(maxlonPath,"").toString();
#else
    tmp = settings.value(maxlonPath,"").toString();
#endif
    maxlonEdit = new QLineEdit(tmp,this);
    connect(maxlonEdit, SIGNAL(editingFinished()), this, SLOT(on_range_change()));
    connect(maxlonEdit, SIGNAL(textChanged()), this, SLOT(on_range_change()));

    QGridLayout *limitsLayout = new QGridLayout;
    limitsLayout->setContentsMargins(10, 0, 10, 0);
    limitsLayout->setSpacing(0);

    row = 0;
    int wid = 30;
    int fac = 3;
    QSpacerItem * sp;
    sp = new QSpacerItem(wid*fac,14);
    limitsLayout->addItem(sp,row,0);
    limitsLayout->addWidget(mmLabel,row,1);
    sp = new QSpacerItem(wid,14);
    limitsLayout->addItem(sp,row,2);
    limitsLayout->addWidget(minLabel,row,3);
    sp = new QSpacerItem(wid,14);
    limitsLayout->addItem(sp,row,4);
    limitsLayout->addWidget(maxLabel,row,5);
    sp = new QSpacerItem(wid*fac,14);
    limitsLayout->addItem(sp,row,6);

    row++;
    sp = new QSpacerItem(wid*fac,14);
    limitsLayout->addItem(sp,row,0);
    limitsLayout->addWidget(latLabel,row,1);
    sp = new QSpacerItem(wid,14);
    limitsLayout->addItem(sp,row,2);
    limitsLayout->addWidget(minlatEdit,row,3);
    sp = new QSpacerItem(wid,14);
    limitsLayout->addItem(sp,row,4);
    limitsLayout->addWidget(maxlatEdit,row,5);
    sp = new QSpacerItem(wid*fac,14);
    limitsLayout->addItem(sp,row,6);

    row++;
    sp = new QSpacerItem(wid*fac,14);
    limitsLayout->addItem(sp,row,0);
    limitsLayout->addWidget(lonLabel,row,1);
    sp = new QSpacerItem(wid,14);
    limitsLayout->addItem(sp,row,2);
    limitsLayout->addWidget(minlonEdit,row,3);
    sp = new QSpacerItem(wid,14);
    limitsLayout->addItem(sp,row,4);
    limitsLayout->addWidget(maxlonEdit,row,5);
    sp = new QSpacerItem(wid*fac,14);
    limitsLayout->addItem(sp,row,6);

    limitsGroup->setLayout(limitsLayout);
    mainLayout->addWidget(limitsGroup);

    QGroupBox *currentGroup = new QGroupBox(tr("Current Limits"));
    QGridLayout *currentLayout = new QGridLayout;
    currentLayout->setContentsMargins(10, 0, 10, 0);
    //currentLayout->setSpacing(0);
    currentLayout->setHorizontalSpacing(4);
    // current user values
    QSizePolicy szpol;
    szpol.setVerticalStretch(0);
    centlat1Label = new QLabel(tr("Center Lat:"));
    centlat2Label = new QLabel(tr("     "));
    centlat2Label->setFrameShape(QFrame::Box);
    centlat2Label->setSizePolicy(szpol);
    centlon1Label = new QLabel(tr("Center Lon:"));
    centlon2Label = new QLabel(tr("     "));
    centlon2Label->setFrameShape(QFrame::Box);
    centlon2Label->setSizePolicy(szpol);
    xdist1Label = new QLabel(tr("xdist:"));
    xdist2Label = new QLabel(tr("      "));
    xdist2Label->setFrameShape(QFrame::Box);
    xdist2Label->setSizePolicy(szpol);
    ydist1Label = new QLabel(tr("ydist:"));
    ydist2Label = new QLabel(tr("      "));
    ydist2Label->setFrameShape(QFrame::Box);
    ydist2Label->setSizePolicy(szpol);

    row = 0;
    currentLayout->addWidget(centlat1Label,row,0);
    currentLayout->addWidget(centlat2Label,row,1);
    currentLayout->addWidget(centlon1Label,row,2);
    currentLayout->addWidget(centlon2Label,row,3);
    currentLayout->addWidget(xdist1Label,row,4);
    currentLayout->addWidget(xdist2Label,row,5);
    currentLayout->addWidget(ydist1Label,row,6);
    currentLayout->addWidget(ydist2Label,row,7);

    row++;
    srtm1Label = new QLabel(tr("SRTM Range:"));
    currentLayout->addWidget(srtm1Label,row,0);
    srtm2Label = new QLabel(tr("           "));
    srtm2Label->setFrameShape(QFrame::Box);
    srtm2Label->setSizePolicy(szpol);
    currentLayout->addWidget(srtm2Label,row,1,1,2);
    srtm3Label = new QLabel(tr("           "));
    srtm3Label->setFrameShape(QFrame::Box);
    srtm3Label->setSizePolicy(szpol);
    currentLayout->addWidget(srtm3Label,row,3,1,2);
    srtm4Label = new QLabel(tr("           "));
    currentLayout->addWidget(srtm4Label,row,5);

    currentGroup->setLayout(currentLayout);
    mainLayout->addWidget(currentGroup);

    on_range_change();

}

void tabSetup::on_projdir_edit()
{
    QString tmp;
    QDir f;
    QString style;
    tmp = projdirEdit->text();
    setup_state &= suf_scene;
    if (f.exists(tmp)) {
        style = "color:green";
        saveSetting(dirsprojectPath,tmp);
        setup_state |= suf_scene;
    } else {
        style = "color:red";
    }
    projdirLabel->setStyleSheet(style);

}

void tabSetup::on_projdir_browse()
{
    main->statusBar()->showMessage("Set Project Directory",5000);
    QString prompt(tr("Select Project Directory"));
    QString current = projdirEdit->text();
    QString filePath = util_browseDirectory(prompt,current);
    QDir d;
    if (!filePath.isEmpty() && d.exists(filePath)) {
        projdirEdit->setText(filePath);
        on_projdir_edit();
    }

}

void tabSetup::on_tgtool_edit()
{
    QString tmp;
    QDir d;
    QString style;
    tmp = tgtoolEdit->text();
    setup_state &= ~suf_tools;
    if (d.exists(tmp)) {
        style = "color:green";
        saveSetting(dirstgtoolsPath,tmp);
        setup_state |= suf_tools;
    } else {
        style = "color:red";
    }
    tgtoolLabel->setStyleSheet(style);
}

void tabSetup::on_tgtool_browse()
{
    main->statusBar()->showMessage("Set TG Tool Directory",5000);
    QString prompt(tr("Select TG Tool Directory"));
    QString current = tgtoolEdit->text();
    QString filePath = util_browseDirectory(prompt,current);
    QDir d;
    if (!filePath.isEmpty() && d.exists(filePath)) {
        tgtoolEdit->setText(filePath);
        on_tgtool_edit();
    }
}

void tabSetup::on_fgroot_edit()
{
    QString tmp;
    QDir d;
    QString style;
    tmp = fgrootEdit->text();
    setup_state &= ~suf_root;
    if (d.exists(tmp)) {
        style = "color:green";
        saveSetting(dirsfgrootPath,tmp);
        setup_state |= suf_root;
    } else {
        style = "color:red";
    }
    fgrootLabel->setStyleSheet(style);
}

void tabSetup::on_fgroot_browse()
{
    main->statusBar()->showMessage("Set FG Root Directory",5000);
    QString prompt(tr("Select FG Rool Directory"));
    QString current = fgrootEdit->text();
    QString filePath = util_browseDirectory(prompt,current,this);
    QDir d;
    if (!filePath.isEmpty() && d.exists(filePath)) {
        fgrootEdit->setText(filePath);
        on_fgroot_edit();
    }
}

void tabSetup::validate_dirs()
{
    on_projdir_edit();
    on_tgtool_edit();
    on_fgroot_edit();
}

void tabSetup::saveSetting(QString path, QString value)
{
#ifdef TRY_GLOBAL_SETTINGS
    main->m_Settings->setValue(path,value);
#else
    QSettings settings;
    settings.setValue(path,value);
#endif
}

#define dnorth maxlat
#define dsouth minlat
#define deast  maxlon
#define dwest  minlon

void tabSetup::on_range_change()
{
    QString msg;
    QString style;
    QString sminlat(minlatEdit->text());
    QString smaxlat(maxlatEdit->text());
    QString sminlon(minlonEdit->text());
    QString smaxlon(maxlonEdit->text());
    double minlat = sminlat.toDouble();
    double maxlat = smaxlat.toDouble();
    double minlon = sminlon.toDouble();
    double maxlon = smaxlon.toDouble();
    setup_state &= ~suf_ranges;
    if ((util_inWorldRange(minlat, minlon))&&
        (util_inWorldRange(maxlat, maxlon))&&
        (minlat <= maxlat)&&
        (minlon <= minlon)&&
        !sminlat.isEmpty() && !smaxlat.isEmpty() &&
        !sminlon.isEmpty() && !smaxlon.isEmpty())
    {
        double centlat = (minlat + maxlat) / 2.0;
        double centlon = (minlon + maxlon) / 2.0;
        double latdiff = maxlat - minlat;
        double londiff = maxlon - minlon;
        msg = util_trimDoubleStg(centlat);
        centlat2Label->setText(msg);
        msg = util_trimDoubleStg(centlon);
        centlon2Label->setText(msg);
        msg = util_trimDoubleStg(londiff);
        xdist2Label->setText(msg);
        msg = util_trimDoubleStg(latdiff);
        ydist2Label->setText(msg);
        // ***TBD*** SRTM Range
        // max. elevation SRTM - north and east
        QString maxElev = srtm_latlonToHGTBase( dnorth, deast );
        // min. elevation SRTM - south and west
        QString minElev = srtm_latlonToHGTBase( dsouth, dwest );

        style = "color:green";
        msg = "ok ";
        // THIS HAS TO BE DONE ON A THREAD
        // msg.append(srtm_getSRTMListstg(dsouth, dwest, dnorth, deast));
        srtm1Label->setStyleSheet(style);
        srtm1Label->setText("SRTM Range:");
        srtm2Label->show();
        srtm3Label->show();
        srtm4Label->show();

        srtm2Label->setText(minElev);
        srtm3Label->setText(maxElev);

        srtm4Label->setStyleSheet(style);
        srtm4Label->setText(msg);
#ifdef TRY_GLOBAL_SETTINGS
        main->m_Settings->setValue(minlatPath,sminlat);
        main->m_Settings->setValue(maxlatPath,smaxlat);
        main->m_Settings->setValue(minlonPath,sminlon);
        main->m_Settings->setValue(maxlonPath,smaxlon);
#endif
        setup_state |= suf_ranges;
    } else {
        style = "color:red";
        msg = "Range error: ";
        if (sminlat.isEmpty()||smaxlat.isEmpty()||sminlon.isEmpty()||smaxlon.isEmpty()) {
            if (sminlat.isEmpty())
                msg.append("min.lon is empty ");
            if (smaxlat.isEmpty())
                msg.append("max.lat is empty ");
            if (sminlon.isEmpty())
                msg.append("min.lon is empty ");
            if (smaxlon.isEmpty())
                msg.append("max.lon is empty ");
        } else if (minlat > maxlat)
            msg = "min.lat GT max.lat";
        else if (minlon > maxlon)
            msg = "min.lon GT max.lon";
        srtm2Label->hide();
        srtm3Label->hide();
        srtm4Label->hide();
        srtm1Label->setStyleSheet(style);
        srtm1Label->setText(msg);
    }
}
