#!/bin/sh
#< build of Atlas 2008
BN=`basename $0`

USE_FG25=1
# ESTABLISH CORRECT PATHS
# ====================================
if [ "$USE_FG25" = "1" ]; then
echo "$BN: Using FG 2.5..."
FGBASE="$HOME/fg/fg16/fgfs/data"
SIMGEAR="$HOME/fg/fg16/install/simgear"
OSG="$HOME/fg/fg16/install/OSG301"
PLIB=
else
echo "$BN: Using FG 2.0..."
FGBASE="$HOME/fg/fg14/fgfs/data"
SIMGEAR="$HOME/fg/fg14/install/simgear"
OSG="$HOME/fg/fg14/install/OSG283"
PLIB="$HOME//fg/fg14/install/plib"
fi
# ====================================

CFGFILE="configure"
AUTOGEN="autogen.sh"
CFGLOG="config.log"

# should NOT need to alter anything after here

if [ ! -d "$FGBASE" ]; then
    echo "$BN: Directory [$FGBASE] does NOT exist. FIX FGBASE SCRIPT, and retry..."
    exit 1
fi
if [ ! -f "$FGBASE/version" ]; then
    echo "$BN: File [$FGBASE/version] does NOT exist. FIX FGBASE IN SCRIPT, and retry..."
    exit 1
fi

if [ ! -d "$SIMGEAR" ]; then
    echo "$BN: Directory [$SIMGEAR] does NOT exist. FIX SIMGEAR IN SCRIPT, and retry..."
    exit 1
fi

if [ ! -d "$OSG" ]; then
    echo "$BN: Directory [$OSG] does NOT exist. FIX OSG IN SCRIPT, and retry..."
    exit 1
fi

if [ -f "$CFGFILE" ]; then
    echo "$BN: file $CFGFILE exist, so NOT running $AUTOGEN..."
else
    echo "$BN: No file $CFGFILE! Need to run $AUTOGEN..."
    if [ -f "$AUTOGEN" ]; then
        echo "$BN: Found $AUTOGEN..."
        ls -all "$AUTOGEN"
    else
        echo "$BN: No $AUTOGEN file found! Aborting..."
        exit 1
    fi
    
    if [ -x "$AUTOGEN" ]; then
        echo "$BN: $AUTOGEN already set as executable..."
    else
        echo "$BN: Attempting to set $AUTOGEN as executable..."
        chmod +x "$AUTOGEN"
    fi
    if [ ! -x "$AUTOGEN" ]; then
        echo "$BN: ERROR: FAILED to set $AUTOGEN as executable! Aborting..."
        exit 1
    fi
    echo "$BN: Running $AUTOGEN"
    ./$AUTOGEN
    if [ ! -f "$CFGFILE" ]; then
        echo "$BN: ERROR: FAILED to create file $CFGFILE! Aborting..."
        exit 1
    fi
fi

CFGOPS=
if [ ! -z "$FGBASE" ]; then
    CFGOPTS="$CFGOPTS --with-fgbase=$FGBASE"
fi
if [ ! -z "$SIMGEAR" ]; then
    CFGOPTS="$CFGOPTS --with-simgear=$SIMGEAR"
fi
if [ ! -z "$OSG" ]; then
    CFGOPTS="$CFGOPTS --with-osg=$OSG"
fi
if [ ! -z "$PLIB" ]; then
    CFGOPTS="$CFGOPTS --with-plib=$PLIB"
fi

if [ -f Makefile ]; then
    echo "$BN: Found an existing 'Makefile'..."
fi

./configure $CFGOPTS

make

# eof
