// strsep.cxx
// Just a simple WIN32 port of 'strsep'
#include <string>
#include "strsep.h"

/* ================================================================================
   If *stringp is NULL, the strsep() function returns NULL and does nothing else.
   Otherwise, this function finds the first token in the string *stringp, where
   tokens are delimited by symbols in the string delim.  This token is terminated
   with a '\0' character (by overwriting the delimiter) and *stringp is updated to
   point past the token.  In case no delimiter was found, the token is taken to be
   the entire string *stringp, and *stringp is made NULL.
   ================================================================================ */

char * strsep(char * * stringp, const char * delim)
{
   char * cp = NULL;
   char * found, * fnd;
   const char * match;
   int   cyc = 1;

   if( stringp )
      cp = *stringp;

   if(!cp)
      return NULL;

   if( !delim || (*delim == 0) )
   {
      *stringp = NULL;
      return cp;  /* return whole string as token */
   }

   found = strchr(cp, *delim);
   if(!found)  /* have not even found first match */
   {
      *stringp = NULL;
      return cp;  /* return whole string as token */
   }
   while( cyc )
   {
      match = delim;
      fnd = found;
      match++; /* start matching to this */
      fnd++;   /* commencing next char of found */
      while(*match) {
         if( *match != *fnd ) {
            /* failed to match string */
            fnd = found + 1;  /* move on one char */
            found = strchr(fnd, *delim);  /* do another search for first */
            if( !found )   /* if NOT found ... it is all over */
            {
               *stringp = NULL;  /* null the next, and */
               return cp;        /* return whole string as token */
            }
         }
         match++; /* bump to next match */
         fnd++;   /* and next in string */
      }

      /* ran out of match, thus a successful find */
      *stringp = fnd;   /* return pointer to next after match */
      *found = 0;       /* send found zero - MODIFYING the string */
      cyc = 0;          /* release from cycle - could just break */
   }
   return cp;  /* return start of token, now zero terminated */
}

// eof - strsep.cxx
