// timegm.cxx
// WIN32 port of GNU timegm()
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif // #ifdef HAVE_CONFIG_H

#include <time.h>
#include <stdlib.h>
#include "timegm.h"

time_t
timegm(struct tm *tm)
{
   time_t ret;
   char *tz;

   tz = getenv("TZ");
   _putenv("TZ=1");
   tzset();
   ret = mktime(tm);
   if (tz)
       _putenv(tz);
   //else
   //    unsetenv("TZ");
   tzset();
   return ret;
}

time_t alt_timegm(struct tm *t) 
{
   time_t tl, tb;
   struct tm *tg;

   tl = mktime (t);
   if (tl == -1)
   {
      t->tm_hour--;
      tl = mktime (t);
      if (tl == -1)
         return -1; /* can't deal with output from strptime */
      tl += 3600;
   }

   tg = gmtime (&tl);
   tg->tm_isdst = 0;
   tb = mktime (tg);
   if (tb == -1)
   {
      tg->tm_hour--; 
      tb = mktime (tg); 
      if (tb == -1) 
        return -1; /* can't deal with output from gmtime */ 
      tb += 3600;
   }

   return (tl - (tb - tl));
} 

// eof - timegm.cxx


