// rint.cxx
// Permisssion to use for all purposes commercial and otherwise granted. 
// THIS MATERIAL IS PROVIDED "AS IS" WITHOUT WARRANTY, OR ANY CONDITION OR 
// OTHER TERM OF ANY KIND INCLUDING, WITHOUT LIMITATION, ANY WARRANTY 
// OF MERCHANTABILITY, SATISFACTORY QUALITY, OR FITNESS FOR A PARTICULAR 
// PURPOSE. 

// native WIN32 port of rint
// moved out of overlays.cxx
#include <math.h>

/* =========================================================================
// New rint() - December, 2008 - Geoff R. McLane
//
// In WIN32, the largest unsigned value is __int64, 64-bits, which has a 
// maximum hex 0xffffffffffffffff, decimal 18446744073709551615,
// scientific 1.84467E+019, and the Tor rint(d) implementation below will FAIL
// if given a double larger (or smaller) than this MAXIMUM __int64!
//
// So have implemented this all double rint(), which works ;=))
// It matches the value from Ubuntu 64-bit rint() for all examples tested.
// ======================================================================== */
double rint( double x )
{
   if ( x > 0.0 )
      return floor( x + 0.5 );
   if ( x < 0.0 )
      return ceil( x - 0.5 );
   return 0.0;
}

// Copyright (C) 2001 Tor M. Aamodt, University of Toronto 
// Permisssion to use for all purposes commercial and otherwise granted. 
// THIS MATERIAL IS PROVIDED "AS IS" WITHOUT WARRANTY, OR ANY CONDITION OR 
// OTHER TERM OF ANY KIND INCLUDING, WITHOUT LIMITATION, ANY WARRANTY 
// OF MERCHANTABILITY, SATISFACTORY QUALITY, OR FITNESS FOR A PARTICULAR 
// PURPOSE. 
double __cdecl Tor_rint( double x) 
{ 
    if( x > 0 ) { 
        __int64 xint = (__int64) (x+0.5); 
        if( xint % 2 ) { 
            // then we might have an even number... 
            double diff = x - (double)xint; 
            if( diff == -0.5 ) 
                return double(xint-1); 
        } 
        return double(xint); 
    } else { 
        __int64 xint = (__int64) (x-0.5); 
        if( xint % 2 ) { 
            // then we might have an even number... 
            double diff = x - (double)xint; 
            if( diff == 0.5 ) 
                return double(xint+1); 
        } 
        return double(xint); 
    } 
}

// eof - rint.cxx
