@if "%1x" == "x" goto HELP
@REM ======================================================================
@REM USER VARIABLES
@REM Establish the USER variables to run Atlas
@REM This has been set all relative to this folder, and assumes FG data
@REM is located at ..\..\data ...
@REM =====================================================================
@set TEMPEXE=Release\Atlas\atlas.exe
@set TEMPRT=..\..\..\data
@set TEMPSC=%TEMPRT%\Scenery
@REM This is using a UNC path to another computer, containing the data
@REM set TEMPSC=\\Dell02\Share\geoff\Scenery-1.0.1
@set TEMPPAL=..\..\src\AtlasPalette
@set TEMPOUT=%1
@set TEMPMAP=Release\Map\map.exe
@REM ======================================================================

@REM TEST FOR EXISTING
@if NOT EXIST %TEMPEXE% goto ERR1
@if NOT EXIST %TEMPRT%\. goto ERR2
@if NOT EXIST %TEMPRT%\version goto ERR3
@if NOT EXIST %TEMPMAP% goto ERR4
@if NOT EXIST %TEMPSC%\. goto ERR5
@if NOT EXIST %TEMPOUT%\. goto CHKFOLD
:DNFOLD
@if NOT EXIST %TEMPOUT%\. goto ERR6

@REM Show some information
@echo Data version is ...
type %TEMPRT%\version
dir %TEMPEXE%

@set TEMPCMD=--airport=KSFO
@set TEMPCMD=%TEMPCMD% --fg-root=%TEMPRT%
@set TEMPCMD=%TEMPCMD% --fg-scenery=%TEMPSC%
@set TEMPCMD=%TEMPCMD% --map-executable=%TEMPMAP%
@set TEMPCMD=%TEMPCMD% --udp
@set TEMPCMD=%TEMPCMD% --path=%TEMPOUT%

@echo Run a Atlas test ... with the following parameters ...
@echo %TEMPCMD% %2 %3 %4 %5 %6 %7 %8 %9
@echo Change to suit your preferences ... Ctrl+C to abort ...
@pause
%TEMPEXE% %TEMPCMD% %2 %3 %4 %5 %6 %7 %8 %9
@REM %TEMPEXE% --help
@goto END

:CHKFOLD
@echo %TEMPOUT% does not EXIST! Do you want it CREATED? Ctlr+C to abort
@pause
md %TEMPOUT%
@if NOT EXIST %TEMPOUT%\. goto ERR6
@if NOT EXIST %TEMPOUT%\lowres md %TEMPOUT%\lowres
@goto DNFOLD

:ERR1
@echo ERROR: Can NOT locate %TEMPEXE% - check name, location ...
@goto END
:ERR2
@echo ERROR: Can NOT locate data folder [%TEMPRT%] ... check and correct ...
@goto END
:ERR3
@echo ERROR: Can NOT locate version file in data folder [%TEMPRT%\version] ... check and correct ...
@goto END
:ERR4
@echo ERROR: Can NOT locate %TEMPMAP% - check name, location ...
@goto END
:ERR5
@echo ERROR: Can NOT locate %TEMPSC% - check name, location ...
@goto END
:ERR6
@echo ERROR: Map folder %TEMPOUT% does NOT exist - check name, location ...
@goto END

:HELP
@echo ERROR: No map directory given ...
@echo Enter either the folder where you have already generated the maps, or
@echo an empty folder, or a folder you want created by this batch file,
@echo and will be filled with the 'map' generated ...
@goto END

:END
