@echo Testing GetMap ...
@echo Info: http://onearth.jpl.nasa.gov/tiled.html
@set TEMPBASE=http://wms.jpl.nasa.gov/wms.cgi
@set TEMPEXE=Release\GetMap\GetMap.exe
@if NOT EXIST %TEMPEXE% goto ERR1
@REM KSFO = --lat=37.621 --lon=-122.381
@REM %TEMPEXE% --help
@REM GetMap - FlightGear mapping retrieval utility
@REM Usage:
@REM   --size=pixels           Create map of size pixels*pixels (default 256)
@REM   --base-url=url          Beginning of the url of the WMS server
@REM   --atlas=path            Create maps of all scenery, and store them in path
@REM   --min-lat               Minimum latitude
@REM   --max-lat               Maximum latitude
@REM   --min-lon               Minimum longitude
@REM   --max-lon               Maximum longitude
@REM   --verbose               Display information during processing
@set TEMPCMD=--base-url="%TEMPBASE%"
@set TEMPCMD=%TEMPCMD% --size=512
@set TEMPCMD=%TEMPCMD% --atlas=temp
@set TEMPCMD=%TEMPCMD% --min-lat=36
@set TEMPCMD=%TEMPCMD% --max-lat=39
@REM set TEMPCMD=%TEMPCMD% --min-lat=30
@REM set TEMPCMD=%TEMPCMD% --max-lat=40
@set TEMPCMD=%TEMPCMD% --min-lon=-123
@set TEMPCMD=%TEMPCMD% --max-lon=-121
@set TEMPCMD=%TEMPCMD% --verbose
@echo Run %TEMPEXE% with commands -
@echo %TEMPCMD%
@pause
%TEMPEXE% %TEMPCMD%
@goto END


:ERR1
@echo Can NOT locate %TEMPEXE% ... check name, location ...
@goto END

:END
