@setlocal
@REM USER VARIABLES BELOW MAY NEED TO BE ADJUST BELOW
@REM TO SUIT YOUR PARTICULAR ENVIRONMENT, and
@REM you must supply the OUTPUT file name, like say 'temp.png'

@if "%1x" == "x" goto HELP
@if NOT EXIST %1 goto DNCHK
@echo WARNING: %1 already EXIST ... to continue will overwrite this file!
:DNCHK

@REM USER VARIABLES - THESE NEED TO BE ADJUSTED TO SUIT YOUR ENVIRONMENT
@REM These have been set all relative to this folder, but absolute paths
@REM can be used. Some adjustments, like adding quotes, may be required if
@REM your path contains spaces ...

@set TEMPRT=..\..\..\data
@set TEMPPAL=..\..\src\AtlasPalette
@set TEMPEXE=Release\Map\Map.exe
@set TEMPOUT=tempout.txt
@REM END USER VARIABLES

@REM Check we have the correct paths
@if NOT EXIST %TEMPRT%\. goto ERR1
@if NOT EXIST %TEMPRT%\version goto ERR2
@if NOT EXIST %TEMPPAL%\. goto ERR3
@if NOT EXIST %TEMPEXE% goto ERR4

@REM This is what Atlas uses when running map internally
@REM 	<< " --fg-root=" << _prefs.fg_root.str()
@REM	<< " --fg-scenery=" << _prefs.scenery_root.str() = will be fg_root + \Scenery unless specified
@REM	<< " --lat=" << _lat    = as desired
@REM	<< " --lon=" << _lon
@REM	<< " --output=" << output.str() = uses form [e|w]nnn[n|s]00.png
@REM	<< " --size=" << size   = default 256
@REM	<< " --headless --autoscale";

@set TEMPCMD=--fg-root=%TEMPRT% --palette=%TEMPPAL% --lat=37.621 --lon=-122.381 --output=%1 --size=256 --autoscale
@REM set TEMPCMD=--fg-root=%TEMPRT% --palette=%TEMPPAL% --lat=37.621 --lon=-122.381 --verbose --enable-airports --enable-navaids --scale=50 --output=%1

@echo Run a MAP test ... with the following parameters ...
@echo %TEMPCMD% %2 %3 %4 %5 %6 %7 %8 %9
@echo Change to suit your preferences ... Ctrl+C to abort ...
@pause
@echo CMD[%TEMPEXE% %TEMPCMD% %2 %3 %4 %5 %6 %7 %8 %9] > %TEMPOUT%
%TEMPEXE% %TEMPCMD% %2 %3 %4 %5 %6 %7 %8 %9 >>%TEMPOUT% 2>&1
@set TEMPERR=%ERRORLEVEL%
@echo Program exited with error level %TEMPERR% ... >> %TEMPOUT%
@echo Program exited with error level %TEMPERR% ...
start tempout.txt
@if "%TEMPERR%x" == "0x" goto LOAD
@goto END
:LOAD
start %1
@goto END

:HELP
@echo Output PNG file name MUST be given ...
@goto END

:ERR1
@echo ERROR: Can NOT locate data folder [%TEMPRT%] ... check and correct ...
@goto WAIT
:ERR2
@echo ERROR: Can NOT locate version file in data folder [%TEMPRT%\version] ... check and correct ...
@goto WAIT
:ERR3
@echo ERROR: Can NOT locate palette file [%TEMPPAL%] ... check and correct ...
@goto WAIT
:ERR4
@echo ERROR: Can NOT locate EXE file [%TEMPEXE%] ... check and correct ...
@goto WAIT

:WAIT
@pause
:END
@endlocal
