// simp_client.cxx
// 2011-03-31 - Some (messy) experiments with SOCKETS

#ifdef _MSC_VER
#pragma warning(disable : 4996 4267 4101)
#include <Winsock2.h>
#include <iostream>
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <fcntl.h>
#include <memory.h>
#include <io.h>
#include <conio.h>
#include <time.h>

using namespace std;
#define bzero ZeroMemory    
#define sleep(a) Sleep(a * 1000)

#else // !_MSC_VER
#include <iostream>
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <netinet/in.h>
#include <fcntl.h>
#include <memory.h>
#include <termios.h>
#include <fcntl.h>
#include <time.h>
#endif // _MSC_VER
#include "simp_common.hxx"

#include "winsockerr.cxx"

static char hostName[MAXSTR];
int out_count = 0;
int wait_4_reply = 0;
int is_paused = 0;
time_t pause_time;
time_t msg_wait_time = 30; // show paused, every 30 seconds

static char m_data[MAXSTR+16];
static char m_answer[MAXSTR+16];

int socket_type = DEF_SOCK_TYPE;

int add_nonblocking = 1;
int max_recv_errors = 2;
int max_send_errors = 2;

INCLIENT hostServ;

void show_help(void)
{
    cout << " ?   = This help..." << endl;
#if 0 // for server
    cout << " e   = Toggle ECHO. Currently " <<
        (do_echo ? "On" : "OFF") << endl;
#endif // 0
    cout << " p   = Toggle PAUSE. Currently " <<
        (is_paused ? "On" : "OFF") << endl;
    cout << "ESC  = EXIT application..." << endl;
}


int check_key(void)
{
    int chr = test_for_input();
    if (chr) {
        switch (chr)
        {
        case '?':
            show_help();
            break;
#if 0 // for server only
        case 'e':
            do_echo = (do_echo ? 0 : 1);
            cout << "e - Toggled ECHO. Currently " <<
                (do_echo ? "On" : "OFF") << endl;
            break;
#endif // 0
        case 'p':
            pause_time = time(0);
            is_paused = (is_paused ? 0 : 1);
            cout << "p - Toggled PAUSE. Currently " <<
                (is_paused ? "On" : "OFF") << endl;
            break;
        case 0x1b:
            cout << "ESC - Commence exit..." << endl;
            return 1;
            break;
        default:
            cout << "Unused key input..." << endl;
            break;
        }
    }
    return 0;
}
// On Windows Sleep(ms) is available, but
// for unix/linux maybe
// int usleep(int usec) {
// static struct {
//      long tv_sec; long tv_usec; } delay;
//    delay.tv_sec = usec / 1000000L;
//    delay.tv_usec = usec % 1000000L;
//    return select( 0, (long *)0, (long *)0, &delay); }
// or struct timeval tv; tv.tv_sec = usec / 100000L;
//    tv.tv_usec = usec % 1000000L;
//    return select( 0, 0, 0, 0, &tv );
// should do the trick
int check_key_sleep(int secs)
{
    int chr = check_key();
    if (chr)
        return chr;
    while (secs--) {
        sleep(1);
        chr = check_key();
        if (chr)
            return chr;
    }
    chr = check_key();
    return chr;
}


int error_is_fatal(int err)
{
    if (err == WSAECONNABORTED)
        return 1;
    if (err == WSAECONNRESET)
        return 1;
    // what other FATAL errors ... or maybe ALL are FATAL
    return 0;
}

int error_is_not_fatal( int wsa_errno )
{
    switch (wsa_errno) {
    case WSAEWOULDBLOCK: // always == NET_EAGAIN?
    case WSAEALREADY:
    case WSAEINPROGRESS:
      return 1;
    }
    return 0;
}

void clean_data(char * dest, char * src, int len)
{
    int i, off, c;
    off = 0;
    for (i = 0; i < len; i++) {
        c = src[i];
        if (c & 0x80) { // got high bit on
            dest[off++] = '@';
            c &= ~0x80;
        }
        if (c < ' ') {
            dest[off++] = '^';
            c += '@';
        }
        dest[off++] = c;
    }
    dest[off] = 0;
}

void show_comp_date(char * name)
{
    cout << "Running: " << name << ", compiled " << __DATE__ <<
        ", at " << __TIME__ << endl;
}

void cmd_help(char * name)
{
    cout << "HELP" << endl;
    cout << " -?    = This help, and exit 0" << endl;
    cout << " -h <host> = Set the HOST name, or IP. Def=" << HOST << endl;
    cout << " -p <port> = Set the PORT number. Def=" << PORTNUM << endl;
    cout << " -u        = Use udp socket. Def=tcp" << endl;
}

int main( int argc, char *argv[])
{
    int portNumber, status;
    int i, c;
    char * arg;
    show_comp_date(argv[0]);
    sock_init();
    strcpy(hostName,HOST);
	portNumber = PORTNUM;
    printf( "Running %s, compile %s, at %s\n", argv[0], __DATE__, __TIME__ );
    for (i = 1; i < argc; i++) {
        arg = argv[i];
        if (*arg == '-') {
            arg++;
            while(*arg == '-') arg++;
            c = *arg;
            switch (c)
            {
            case '?':
                cmd_help(argv[0]);
                return 0;
                break;
            case 'h':
                if ((i + 1) < argc) {
                    i++;
                    strcpy(hostName,argv[i]);
                } else {
                    goto Bad_Arg;
                }
                break;
            case 'p':
                if ((i + 1) < argc) {
                    i++;
                    portNumber = atoi(argv[i]);
                } else {
                    goto Bad_Arg;
                }
                break;
            case 'u':
                socket_type = SOCK_DGRAM;
                break;
            default:
Bad_Arg:
                cerr << "ERROR: Invalid command line! arg [" << argv[i] << "] unknown\n";
                return 1;
                break;
            }
        } else {
            cerr << "ERROR: Invalid command line! arg [" << argv[i] << "] unknown\n";
            return 1;
        }
	}
	cout << "host = [" << hostName << "] port = " << portNumber <<
        " socket type " << 
        ((socket_type == SOCK_STREAM) ? "tcp" : "udp") << endl;

    struct hostent *hostptr;
    if ((hostptr = gethostbyname(hostName)) == NULL) {
		cerr <<"Error locating host : "<< hostName << endl;
		exit(1);	
	}
    cout << "Got host name [" << hostptr->h_name << "]" << endl;

    struct sockaddr_in serv_addr;

	bzero((char *)&serv_addr,sizeof(serv_addr));

	serv_addr.sin_family = AF_INET;
	memcpy((char *)&serv_addr.sin_addr,(char *)hostptr->h_addr,hostptr->h_length);
	serv_addr.sin_port = htons(portNumber);

    int sockfd,newsockfd;
	sockfd = (int)socket(AF_INET,socket_type,0);
    if (SERROR(sockfd)) {
        PERROR("ERROR: creating socket!");
        exit(1);
    }
    cout << "Got socket [" << sockfd << "]" << endl;
    status = connect(sockfd,(struct sockaddr *)&serv_addr,sizeof(serv_addr));
    if (SERROR(status)) {
        PERROR("ERROR: socket connect FAILED!");
        exit(1);
    }
    // show details of server connection
    PINCLIENT pic = &hostServ;
    struct in_addr * pin = (struct in_addr *)&serv_addr.sin_addr;
    char * IP = inet_ntoa ( *pin );
    if (IP) {
        strcpy( pic->IP, IP );
        unsigned int ipval = inet_addr(pic->IP);
        struct hostent * rH = gethostbyaddr((char *)&ipval, sizeof(ipval), AF_INET);
        if (rH)
            strcpy( pic->h_name, rH->h_name );
        else
            strcpy( pic->h_name, "not found");
    } else {
        strcpy( pic->IP, "inet_ntoa failed");
    }
#ifdef _MSC_VER
    if (add_nonblocking) {
        cout << "Adding non-blocking mode..." << endl;
        status = ioctlsocket(sockfd, FIONBIO, (u_long *) &add_nonblocking);
        cout << "ioctlsocket(sockfd, FIONBIO,...) returned " << status << endl;
    }
#endif // _MSC_VER

    cout << "CLIENT: Got connection to server... IP " << pic->IP <<
        ", port " << ntohs(serv_addr.sin_port) <<
        "\n name " << pic->h_name << endl;
    show_help();

    cout << "Entering forever loop..." << endl;
    while (1)
    {
        if (check_key())
            break;
        if (is_paused) {
            if ((time(0) - pause_time) > msg_wait_time) {
                cout << "CLIENT presently PAUSED!" << endl;
                pause_time = time(0);
            }
            sleep(DEF_SLEEP);
            continue;
        }

        if (wait_4_reply) {
            // waiting a REPLY to last send

        } else {
            strcpy(m_data, get_datetime_str());
#if defined(TRY_NB_SERVER)
            out_count++;
            sprintf(EndBuf(m_data),": %d - Hello server!\n", out_count);
#else
        	strcat(m_data, " String to send to the server.");
#endif
            // cin.getline(data,MAXSTR,'\n');
	        // data[strlen(data)] = '\0';
            int slen = (int)strlen(m_data);
            clean_data(m_answer,m_data,slen);
            cout << "[" << m_answer << "] " << slen << " bytes sent. " << endl;
#ifdef _MSC_VER
	        int wlen = send(sockfd,m_data,slen,0);
            if (SERROR(wlen)) {
                PERROR("ERROR: sending to socket!");
                pic->send_errors++;
                if ( error_is_fatal(last_wsa_error) ) {
                    // hm, can either try to connect again, OR ABORT
                    cerr << "CLIENT aborting..." << endl;
                    break;
                }
                if (pic->send_errors > max_send_errors) {
                    cerr << "Maximum send errors exceeded! CLIENT aborting..." << endl;
                    break;
                }
                if (check_key())
                    break;
                sleep(DEF_SLEEP);
                if (check_key())
                    break;
                sleep(DEF_SLEEP);
                if (check_key())
                    break;
                sleep(DEF_SLEEP);
                continue;
            }
#else
	        int wlen = write(sockfd,data,wlen);
            if (wlen < 0) {
                cerr << "ERROR: write to socket FAILED [" << wlen << "]" << endl;
                if (check_key())
                    break;
                sleep(DEF_SLEEP);
                if (check_key())
                    break;
                sleep(DEF_SLEEP);
                if (check_key())
                    break;
                sleep(DEF_SLEEP);
                continue;
            }
#endif
            cout << "Wrote/Sent length " << wlen << "... sleep " <<
                DEF_SLEEP << " secs... ";
            if (check_key()) {
                cout << endl;
                break;
            }
            sleep(DEF_SLEEP);
            if (check_key()) {
                cout << endl;
                break;
            }
            cout << "Read answer... " << endl;
            wait_4_reply = 1;
        }
#ifdef _MSC_VER
	    int rlen = recv(sockfd,m_answer,MAXSTR,0);
        if (SERROR(rlen)) {
            win_set_wsa_msg();
            if (add_nonblocking && error_is_not_fatal(last_wsa_error) ) {
                cout << "ok, got [" << last_wsa_emsg << "]" << endl;
                continue;
            }
            PERROR("ERROR: recv from socket!");
#else
	    int rlen = read(sockfd,(void *)answer,MAXSTR);
        if (rlen < 0) {
            cerr << "read socket failed" << endl;
#endif
            pic->recv_errors++;
            if (pic->recv_errors > max_recv_errors) {
                cerr << "Maximum recv errors exceeded. Aborting..." << endl;
                break;
            }
            if (check_key_sleep(DEF_SLEEP * 2))
                break;
            continue;
        }
        pic->recv_errors = 0; // clear recv errors
        if (rlen > 0)
            wait_4_reply = 0;
        clean_data(m_data,m_answer,rlen);
	    cout << "[" << m_data << "] " << rlen << " bytes read" << endl;
        if (check_key())
            break;
        sleep(DEF_SLEEP);
        if (check_key())
            break;
    }

    cout << "CLIENT: Close socket... ";
    SCLOSE(sockfd);
#ifdef _MSC_VER
    cout << "WSACleanup()... ";
#endif
    sock_end();
    cout << "End app " << get_datetime_str() << endl;
    return 0;
}

// eof - client.cxx
