// simp_common.hxx
#ifndef _SIMP_COMMON_HXX_
#define _SIMP_COMMON_HXX_

#include <stdio.h>
#ifndef _MSC_VER
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/socket.h>
#include <termios.h>
#include <netdb.h>  /* for hostent structure, ... */
#include <netinet/in.h>
#include <arpa/inet.h> /* for inet_ntoa(), ... */
#endif /* !_MSC_VER */

#define DEF_SLEEP 1  /* default SLEEP (in seconds) */
#define DEF_SOCK_TYPE SOCK_STREAM
#define MAXSTR 1024
#define PORTNUM 5050
#define HOST "localhost"

typedef struct tagINCLIENT {
    int sock;
    struct sockaddr addr;
    int addrlen, read_cnt, write_cnt;
    time_t created, last_read;
    int had_rw_error;
    int recv_errors, send_errors;
    char IP[32];
    char h_name[256];
}INCLIENT, * PINCLIENT;


#ifdef _MSC_VER
/* for windows */
#define SERROR(a) (a == SOCKET_ERROR)
#define SCLOSE closesocket
#define PERROR(a) win_wsa_perror(a)
#define SREAD recv
#define SWRITE send
#ifndef EINTR
#define EINTR WSAEINTR
#endif
#else
/* for unix/linux */
#define SERROR(a) (a < 0)
typedef int SOCKET;
#define SCLOSE close
#define PERROR(a) perror(a)
#define SREAD read
#define SWRITE write
#endif

#ifndef GOT_DATETIME_STG
#define GOT_DATETIME_STG
#include <time.h>

static char * set_datetime_stg(char * cp, time_t date)
{
    struct tm *tmr;
    tmr = localtime(&date);
    sprintf (cp, "%02d.%02d.%04d %02d:%02d:%02d ",
        tmr->tm_mday,
        tmr->tm_mon+1,
        tmr->tm_year+1900,
        tmr->tm_hour,
        tmr->tm_min,
        tmr->tm_sec);
    return cp;
}

static char * get_datetime_str( void )
{
    static char _s_ds_buf[64];
    char * cp = _s_ds_buf;
    time_t  date = time(0);
    return set_datetime_stg(cp,date);
}

#endif /* #ifndef GOT_DATETIME_STG */

/* ***************************************** */
/* keyboard check */
#ifndef GOT_KEYBOARD_TEST
#define GOT_KEYBOARD_TEST

#ifdef _MSC_VER
#include <conio.h>
int test_for_input(void)
{
    int chr = _kbhit();
    if (chr)
        chr = _getch();
    return chr;
}
#else
int kbhit(void)
{
  struct termios oldt, newt;
  int ch;
  int oldf;

  tcgetattr(STDIN_FILENO, &oldt);
  newt = oldt;
  newt.c_lflag &= ~(ICANON | ECHO);
  tcsetattr(STDIN_FILENO, TCSANOW, &newt);
  oldf = fcntl(STDIN_FILENO, F_GETFL, 0);
  fcntl(STDIN_FILENO, F_SETFL, oldf | O_NONBLOCK);

  ch = getchar();

  tcsetattr(STDIN_FILENO, TCSANOW, &oldt);
  fcntl(STDIN_FILENO, F_SETFL, oldf);

  if(ch != EOF)
  {
    ungetc(ch, stdin);
    return 1;
  }

  return 0;
}
int test_for_input(void)
{
    int chr = kbhit();
    if (chr)
        chr = getchar();
    return chr;
}
#endif
#endif /* #ifndef GOT_KEYBOARD_TEST */
/* ============================================= */

#define EndBuf(a) ( a + strlen(a) )

/* simple ENDIAN test */
static const int _s_EndianTest = 1;
#define IsLittleEndian (*((char *) &_s_EndianTest ) != 0)
#define IsBigEndian    (*((char *) &_s_EndianTest ) == 0)

#endif /* #ifndef _SIMP_COMMON_HXX_ */
/* eof - simp_common.hxx */

