// sim_server.cxx
// 2011-03-31 - Some (messy) experiments with SOCKETS
/* -------------------------------------------------
   sockaddr

   The sockaddr structure varies depending on the protocol used.
   Except for the sin*_family parameter, sockaddr contents are expressed 
   in network byte order. A 16 byte block

   struct sockaddr {
      u_short sa_family; // address family
      char sa_data[14];  // up to 14 bytes of direct address
   };

   Winsock functions using sockaddr are not strictly interpreted to be 
   pointers to a sockaddr structure. The structure is interpreted 
   differently in the context of different address families. The only 
   requirements are that the first u_short is the address family and 
   the total size of the memory buffer in bytes is namelen. 

   The structures below are used with IPv4 and IPv6, respectively. 
   Other protocols use similar structures.

   struct sockaddr_in {
        short   sin_family;
        u_short sin_port;
        struct  in_addr sin_addr;
        char    sin_zero[8];
   };
   struct sockaddr_in6 {
        short   sin6_family;
        u_short sin6_port;
        u_long  sin6_flowinfo;
        struct  in6_addr sin6_addr;
        u_long  sin6_scope_id;
   };
   struct sockaddr_in6_old {
        short   sin6_family;        
        u_short sin6_port;          
        u_long  sin6_flowinfo;      
        struct  in6_addr sin6_addr;  
   };

   hostent
   * Structures returned by network data base library, taken from the
   * BSD file netdb.h.  All addresses are supplied in host order, and
   * returned in network order (suitable for use in system calls).

   struct  hostent {
        char    FAR * h_name;           // official name of host
        char    FAR * FAR * h_aliases;  // alias list
        short   h_addrtype;             // host address type
        short   h_length;               // length of address 
        char    FAR * FAR * h_addr_list; // list of addresses
     #define h_addr  h_addr_list[0]          // address, for backward compat
   };

   ------------------------------------------------- */

#ifdef _MSC_VER
#pragma warning(disable : 4996 4101 4267)
#include <Winsock2.h>
// #include <simgear\debug\logstream.hxx> // could NOT get this to compile
#include <iostream>
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <io.h>
#include <time.h>
#include <conio.h>

#define bzero ZeroMemory
#define sleep(a) Sleep(a * 1000)

using namespace std;

#else // !_MSC_VER
#include <iostream.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>
//#include <fcntl.h>
#include <memory.h>
#include <string.h>
#include <errno.h>
#include <sys/errno.h>
//#include <sys/wait.h>
#include <termios.h>
#include <fcntl.h>
#include <time.h>
#endif
#include <vector>
//#include <strstream>
#include <sstream>
#include "simp_common.hxx" // common to SERVER and CLIENT

#include "winsockerr.cxx"

typedef vector<PINCLIENT> vIN;
typedef vIN::iterator vINi;

vIN vInClients;

ostringstream g_ss;

int max_rw_errors = 5; // erase a client if errors exceed this...

static hostent* localHost = NULL;
static char* localIP = NULL;
static char hostName[MAXSTR];
int socket_type = DEF_SOCK_TYPE;

int add_nonblocking = 1;
int use_local_ip = 0;

#define MY_MX_SETS 3
struct fd_set ListenSockets[MY_MX_SETS];

INCLIENT hostServ;

// forward reference
void handleRequest(int newsockfd, struct sockaddr* addr, int addrlen);
void process_clients(void);
void clear_client_list(void);

int is_paused = 0;
time_t pause_time;
int do_echo = 1;
time_t msg_wait_time = 30; // show paused, every 30 seconds

//#define OUT_SS(a) cout << a.str(); a.str("")
#define OUT_SS(a) printf(a.str().c_str()); a.str("")
void show_help(void)
{
    ostringstream ss;
    ss << " ?   = This help..." << endl;
    ss << " e   = Toggle ECHO. Currently " <<
        (do_echo ? "On" : "OFF") << endl;
    ss << " p   = Toggle PAUSE. Currently " <<
        (is_paused ? "On" : "OFF") << endl;
    ss << "ESC  = EXIT application..." << endl;
    OUT_SS(ss);
    int i = 0;
}


int check_key(void)
{
    int chr = test_for_input();
    if (chr) {
        switch (chr)
        {
        case '?':
            show_help();
            break;
        case 'e':
            do_echo = (do_echo ? 0 : 1);
            cout << "e - Toggled ECHO. Currently " <<
                (do_echo ? "On" : "OFF") << endl;
            break;
        case 'p':
            pause_time = time(0);
            is_paused = (is_paused ? 0 : 1);
            cout << "p - Toggled PAUSE. Currently " <<
                (is_paused ? "On" : "OFF") << endl;
            break;
        case 0x1b:
            cout << "ESC - Commence exit..." << endl;
            return 1;
            break;
        default:
            cout << "Unused key input..." << endl;
            break;
        }
    }
    return 0;
}

int show_local_host(void)
{
    int iret = 1; // assume success
    // Get the local host information
    localHost = gethostbyname("");
    if (localHost) {
        localIP = inet_ntoa (*(struct in_addr *)*localHost->h_addr_list);
        cout << "LOCAL Host " << localHost->h_name << ", IP " << localIP << endl;
    } else {
#ifdef _MSC_VER
        win_set_wsa_msg();
        cerr << "ERROR: gethostbuname() FAILED! [" <<
            last_wsa_emsg << "]" << last_wsa_error << endl;;
#else // !_MSC_VER
        cerr << "gethostbyname() FAILED!" << endl;
#endif // MSC_VER y/n
        iret = 0;
    }
    return iret; // 1 = succes

}


void show_comp_date(char * name)
{
#ifdef _LOGSTREAM_H
    // UGH! could not get this to compile??????
    sglog().setLogLevels( SG_ALL, SG_INFO );
    sglog().enable_with_date (true);
    //SG_LOG(SG_ALL,SG_INFO, "Running: " << argv[0] << ", compiled " << __DATE__ <<
    //    ", at " << __TIME__ );
    SG_ALERT( SG_SYSTEMS, SG_ALERT, "Running: " );
#else
    cout << "Running: " << name << ", compiled " << __DATE__ <<
        ", at " << __TIME__ << endl;
#endif
}

void cmd_help(char * name)
{
    cout << "HELP" << endl;
    cout << " -?    = This help, and exit 0" << endl;
    cout << " -h <host> = Set the HOST name, or IP. Def=<none>" << endl;
    cout << " -p <port> = Set the PORT number. Def=" << PORTNUM << endl;
    cout << " -u        = Use udp socket. Def=tcp" << endl;
}


int main( int argc, char *argv[])
{
    int iret = 0;
    int portNumber, i, c, status;
    char * arg;
    //char executableName[MAXSTR];
    //struct sigaction action;
    show_comp_date(argv[0]);
    sock_init();
    hostName[0] = 0;
    portNumber = PORTNUM; // set default
	// Validate the command line
    for (i = 1; i < argc; i++)
    {
        arg = argv[i];
        if (*arg == '-')
        {
            arg++;
            while(*arg == '-') arg++;
            c = *arg;
            switch (c)
            {
            case '?':
                cmd_help(argv[0]);
                return 0;
                break;
            case 'h':
                if ((i + 1) < argc) {
                    i++;
                    strcpy(hostName,argv[i]);
                } else {
                    goto Bad_Arg;
                }
                break;
            case 'p':
                if ((i + 1) < argc) {
                    i++;
                    portNumber = atoi(argv[i]);
                } else {
                    goto Bad_Arg;
                }
                break;
            case 'u':
                socket_type = SOCK_DGRAM;
                break;
            default:
Bad_Arg:
                cerr << "ERROR: Invalid command line! arg [" << argv[i] << "] unknown\n";
                return 1;
                break;
            }
        } else {
            cerr << "ERROR: Invalid command line! arg [" << argv[i] << "] unknown\n";
            return 1;
        }
	}

    show_local_host();

	// cout << "host = " << hostName << " port = " << portNumber << endl;
	cout << "host = " <<
        (hostName[0] ? hostName : "localhost") <<
        ", port = " << portNumber <<
        " socket type " << 
        ((socket_type == SOCK_STREAM) ? "tcp" : "udp") << endl;
	// At this point, the command line has been validated.

    int sockfd,newsockfd,clilen,childpid;
    struct sockaddr_in serv_addr,cli_addr;

	// Create a new TCP socket...
	sockfd = (int)socket(AF_INET,socket_type,0);
	if (SERROR(sockfd))
	{
        PERROR("ERROR: Can't open socket STREAM!");
		exit(1);
	}

    struct sockaddr Hostname;
    int Hostname_len = sizeof(Hostname);
    cout << "Got socket " << sockfd;

    // can NOT be done BEFORE 'bind'. else get WSAEINVAL
    // status = getsockname( sockfd, &Hostname, &Hostname_len );

    bzero((char *)&serv_addr,sizeof(serv_addr)) ;
	serv_addr.sin_family = AF_INET; // = 2 - internetwork: UDP, TCP, etc.
    if (use_local_ip && localHost && localIP) {
        memcpy((char *)&serv_addr.sin_addr,(char *)localHost->h_addr,localHost->h_length);
        cout << " setting IP " << localIP << endl;
    } else {
        serv_addr.sin_addr.s_addr = htonl(INADDR_ANY);
        cout << " setting IP INADDR_ANY" << endl;
    }
	serv_addr.sin_port = htons(portNumber);

	// Bind the socket to the server's ( this process ) address.
    status = bind(sockfd,(struct sockaddr *)&serv_addr,sizeof(serv_addr));
	if (SERROR(status))
	{
        PERROR("ERROR: Can't bind address!");
		iret = 1;
        goto End_App;
	}

    cout << "bound to port " << 	portNumber << endl;
    status = getsockname( sockfd, &Hostname, &Hostname_len );
    if (SERROR(status)) {
        PERROR("ERROR: getsockname() FAILED!");
        iret = 1;
        goto End_App;
    }
    cout << "getsockname ok " << endl;

#ifdef _MSC_VER
    if (add_nonblocking) {
        cout << "Adding non-blocking mode..." << endl;
        status = ioctlsocket(sockfd, FIONBIO, (u_long *) &add_nonblocking);
        cout << "ioctlsocket(sockfd, FIONBIO,...) returned " << status << endl;
    }
#endif // _MSC_VER

    // get some more details of the server
    PINCLIENT pic = &hostServ;
    struct in_addr * pin = (struct in_addr *)&serv_addr;
    char * IP = inet_ntoa ( *pin );
    if (IP) {
        strcpy( pic->IP, IP );
        unsigned int ipval = inet_addr(pic->IP);
        struct hostent * rH = gethostbyaddr((char *)&ipval, sizeof(ipval), AF_INET);
        if (rH)
            strcpy( pic->h_name, rH->h_name );
        else
            strcpy( pic->h_name, "not found");
    } else {
        strcpy( pic->IP, "inet_ntoa failed");
    }

    cout << "SERVER: Got connection... IP " << pic->IP <<
        "\n name " << pic->h_name << endl;

    if (socket_type == SOCK_STREAM) {
    	// Listen for connections in this socket
        cout << "listen for TCP connection..." << endl;
	    status = listen(sockfd,5);
#ifdef _MSC_VER
	    if (SERROR(status))
	    {
            win_set_wsa_msg();
            cerr << "ERROR: Can't listen on local address! [" <<
                last_wsa_emsg << "]" << last_wsa_error << endl;
#else
        if (status < 0)
        {
            cerr << "ERROR: Can't listen on local address!" << endl;
#endif
            iret = 1;
            goto End_App;
        }
        cout << "listen status : " << status << endl;
    }

    cout <<  "Connected to port : " << portNumber << endl;

    show_help();

	// repeat forever... or until ESC key exit
    while (1)
    {
        if (check_key())
            break;

        if (is_paused) {
            if ((time(0) - pause_time) > msg_wait_time) {
                cout << "SERVER presently PAUSED!" << endl;
                pause_time = time(0);
            }
            sleep(DEF_SLEEP);
            continue;
        }

        process_clients(); // process existing clients first

        if (socket_type == SOCK_STREAM) {
		    clilen = sizeof(cli_addr);
            bzero((char *)&cli_addr,clilen);
		    // Accept a client's request, and get the client's address info into the local variable cli_addr.
		    newsockfd = (int)accept(sockfd,(struct sockaddr *)&cli_addr,&clilen);
#ifdef _MSC_VER
            if (SERROR(newsockfd)) {
                win_set_wsa_msg();
                if (add_nonblocking && (last_wsa_error == WSAEWOULDBLOCK)) {
                    // as expected - just sleep and cycle
                    sleep(DEF_SLEEP);
                    continue;
                }
                cerr << "ERROR: accept returned [" <<
                    last_wsa_emsg << "]" << last_wsa_error << endl;
                iret = 1;
                goto End_App;
            }
#else
            if (newsockfd < 0)
            {
                cerr << "ERROR: accept returned [" << newsockfd << endl;
                sleep(DEF_SLEEP);
                continue;
            }
#endif
		    // After accepting the connection, all transaction with this client would happen with the new socket descriptor - newsockfd.
            cout << "accept connection to : " << newsockfd << endl;

            if ((newsockfd < 0) &&  (errno != EINTR)) {
			    cerr << " server : accept error.\n";
            } else if (newsockfd > 0) {
			    handleRequest(newsockfd,(struct sockaddr*)&cli_addr, clilen);
                cout << "Sleep 1 sec before next cycle..." << endl;
                if (check_key())
                    break;
                sleep(DEF_SLEEP);
                if (check_key())
                    break;
                cout << "continue wait for next..." << endl;
		    }
        } else {
            // UDP - use select
            struct timeval tv ;
            for (int i = 0; i < MY_MX_SETS; i++)
                FD_ZERO(&ListenSockets[i]);
            FD_SET(sockfd,&ListenSockets[0]);
            tv.tv_sec = 0;
            tv.tv_usec = 100;
            //status = select( 0, &ListenSockets[0], NULL, NULL, &tv );
            status = select( 0, &ListenSockets[0], NULL, NULL, &tv );
            if (SERROR(status)) {
                PERROR("ERROR: select()");
                iret = 1;
                goto End_App;
            }
            if (FD_ISSET(sockfd,&ListenSockets[0])) {
                cout << "Got a readable socket..." << endl;
    		    clilen = sizeof(cli_addr);
                bzero((char *)&cli_addr,clilen);
		        // Accept a client's request, and get the client's address info into the local variable cli_addr.
		        //newsockfd = (int)accept(sockfd,(struct sockaddr *)&cli_addr,&clilen);
		        newsockfd = (int)accept(sockfd, NULL, NULL);
                if (SERROR(newsockfd)) {
#ifdef _MSC_VER
                    win_set_wsa_msg();
                    if (add_nonblocking && (last_wsa_error == WSAEWOULDBLOCK)) {
                        // as expected - just sleep and cycle
                        sleep(DEF_SLEEP);
                        continue;
                    }
                    cerr << "ERROR: accept returned [" <<
                        last_wsa_emsg << "]" << last_wsa_error << endl;
                    iret = 1;
                    goto End_App;
#else
                    cerr << "ERROR: accept returned [" << newsockfd << endl;
                    sleep(DEF_SLEEP);
                    continue;
#endif
                }
    		    // After accepting the connection, all transaction with this client would happen with the new socket descriptor - newsockfd.
                cout << "accept connection to : " << newsockfd << endl;

                if ((newsockfd < 0) &&  (errno != EINTR)) {
			        cerr << " server : accept error.\n";
                } else if (newsockfd > 0) {
			        handleRequest(newsockfd,(struct sockaddr*)&cli_addr, clilen);
                    cout << "Sleep 1 sec before next cycle..." << endl;
                    if (check_key())
                        break;
                    sleep(DEF_SLEEP);
                    if (check_key())
                        break;
                    cout << "continue wait for next..." << endl;
		        }
            }
            if (check_key())
               break;
            sleep(DEF_SLEEP);
        }
        if (check_key())
            break;
	}

    // out of the LOOP
    clear_client_list();
    cout << "SERVER: Close socket... ";

End_App:

    SCLOSE(sockfd);
#ifdef _MSC_VER
    cout << "WSACleanup()... ";
#endif
    sock_end();
    cout << "End app " << get_datetime_str() << " exit " << iret << endl;
    return iret;
}

char rd_buf[MAXSTR+1];
char rd_ack[MAXSTR+1];

int handle_receive(int newsockfd, PINCLIENT pic)
{
	// Read from the socket, for the password and the requested command.
    rd_buf[0] = 0;
    cout << "Read from socket : " << newsockfd << " ";
#ifdef _MSC_VER
	int res = recv(newsockfd,rd_buf,MAXSTR,0);
    if (SERROR(res)) {
        win_set_wsa_msg();
        if (add_nonblocking && (last_wsa_error == WSAEWOULDBLOCK)) {
            cout << "Nothing to receive." << endl;
        } else {
            cerr << "Recv error [" << last_wsa_emsg << "]" << endl;
            if (last_wsa_error == WSAECONNRESET)
                return 1;
        }
        return 0;
    }
#else
	int res = read(newsockfd,(void *)&rd_buf,MAXSTR);
    if ( res < 0 ) {
        cerr << "Read failed with [" << res << "]" << endl;
        return 1;
    }
#endif
    cout << "Read returned [" << res << "] ";
    if (res > 0) {
        pic->last_read = time(0);
    	cout << "\nData from client: [" << rd_buf << "]" << endl;
        if (do_echo) {
            rd_buf[res] = 0;
            strcpy(rd_ack, get_datetime_str());
            strcat(rd_ack," echo : Reply from server...");
            //strcat(rd_ack,rd_buf);
    	    // Write back the response to the socket
            int elen = (int)strlen(rd_ack);
            cout << "Write/Send to : " << newsockfd << ", len " << elen << " ";
            res = send(newsockfd,rd_ack,elen,0);
            if (SERROR(res)) {
                PERROR("ERROR: Send!");
                return 1;
            }
            cout << "Write/Send returned " << res << endl;
        }
    } else {
        cout << "Received NULL" << endl;
    }
    return 0;
}

void process_clients(void)
{
    int newsockfd;
    PINCLIENT pic;
    int had_errors = 0;
    vINi it = vInClients.begin();
    for ( ; it != vInClients.end(); it++ )
    {
        pic = *it;
        newsockfd = pic->sock;
        if ( handle_receive(newsockfd,pic) ) {
            pic->had_rw_error++;
            if ( pic->had_rw_error > max_rw_errors )
                had_errors++;
        }
    }
    int offset = 0;
    while (had_errors--) {
        offset = 0;
        int cnt = 0;
        for ( it = vInClients.begin() ; it != vInClients.end(); it++ )
        {
            cnt++;
            pic = *it;
            if ( pic->had_rw_error > max_rw_errors ) {
                char * IP = pic->IP;
                cout << "CLIENT:" << cnt << ": ";
                cout << "close " << pic->sock << ", IP " << IP << 
                    " due to " << pic->had_rw_error << " rw errors" << endl;
                SCLOSE(pic->sock);
                delete pic;
                break;
            }
            offset++;
        }
        if (it != vInClients.end()) {
            vInClients.erase( vInClients.begin() + offset );
        }
    }
}

void clear_client_list(void)
{
    PINCLIENT pic;
    char * IP;
    vINi it;
    int cnt = 0;
    for ( it = vInClients.begin(); it != vInClients.end(); it++ )
    {
        cnt++;
        pic = *it;
        IP = pic->IP;
        cout << "C:" << cnt << ": ";
        cout << "close " << pic->sock << ", IP " << IP << endl;
        SCLOSE(pic->sock);
        delete pic;
    }
    vInClients.clear();
}

void handleRequest(int newsockfd, struct sockaddr* addr, int addrlen)
{
    PINCLIENT pic;
    char * IP;
    vINi it;
    for ( it = vInClients.begin(); it != vInClients.end(); it++ )
    {
        if ( (*it)->sock == newsockfd ) {
            cout << "New socket : " << newsockfd << " already in vector!" << endl;
            return;
        }
    }
    pic = new INCLIENT;
    bzero((char *)pic, sizeof(INCLIENT));
    pic->sock = newsockfd;
    pic->addr = *addr;
    pic->addrlen = addrlen;
    pic->created = time(0);
    struct in_addr * pin = (struct in_addr *)addr;
    IP = inet_ntoa ( *pin );
    if (IP) {
        strcpy( pic->IP, IP );
        unsigned int ipval = inet_addr(pic->IP);
        struct hostent * rH = gethostbyaddr((char *)&ipval, sizeof(ipval), AF_INET);
        if (rH)
            strcpy( pic->h_name, rH->h_name );
        else
            strcpy( pic->h_name, "not found");

    } else {
        strcpy( pic->IP, "inet_ntoa failed");
    }
    
    cout << "New socket : " << newsockfd << " from IP : " <<
        pic->IP << ",\n name [" << pic->h_name << "]" << endl;

#ifdef _MSC_VER
    if (add_nonblocking) {
        cout << "Adding non-blocking mode for " << newsockfd << endl;
        int status = ioctlsocket(newsockfd, FIONBIO, (u_long *) &add_nonblocking);
        cout << "ioctlsocket(sockfd, FIONBIO,...) returned " << status << endl;
    }
#endif // _MSC_VER
    vInClients.push_back(pic); // store new CLIENT
    process_clients();
}

void create_a_listen_socket(void)
{
    // Declare variables
    SOCKET ListenSocket;
    sockaddr_in saServer;
    hostent* localHost;
    char* localIP;

    // Create a listening socket
    ListenSocket = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);

    // Get the local host information
    localHost = gethostbyname("");
    localIP = inet_ntoa (*(struct in_addr *)*localHost->h_addr_list);

    // Set up the sockaddr structure
    saServer.sin_family = AF_INET;
    saServer.sin_addr.s_addr = inet_addr(localIP);
    saServer.sin_port = htons(5150);

    // Bind the listening socket using the
    // information in the sockaddr structure
    bind( ListenSocket,(SOCKADDR*) &saServer, sizeof(saServer) );

}

int get_host_information(char * host_name)
{
    // Declare and initialize variables
    hostent* remoteHost;
    unsigned int addr;

    if (( host_name == NULL ) || ( host_name[0] == 0 )) {
        remoteHost = gethostbyname("");
    } else {
        // If an alpha name for the host, use gethostbyname()
        // If not, get host by addr (assume IPv4)
        if (isalpha(host_name[0])) {   /* host address is a name */
            // if hostname terminated with newline '\n', remove and zero-terminate 
            if (host_name[strlen(host_name)-1] == '\n')
                host_name[strlen(host_name)-1] = '\0'; 
            remoteHost = gethostbyname(host_name);
        } else  {
            addr = inet_addr(host_name);
            remoteHost = gethostbyaddr((char *)&addr, 4, AF_INET);
        }
    }
#ifdef _MSC_VER
    if (WSAGetLastError() != 0) {
        if (WSAGetLastError() == 11001) {
            printf("Host not found...\n");
        } else {
            printf("error#:%ld\n", WSAGetLastError());
        }
        return 1;
    }
#else // !_MSC_VER
    if ( remoteHost == NULL ) {
        printf("Host not found, or gethostbyname() FAILED!\n");
        return 1;
    }
#endif // _MSC_VER y/n
    // The remoteHost structure can now be used to
    // access information about the host
    char* localIP;
    // Get the local host information
    localIP = inet_ntoa (*(struct in_addr *)*remoteHost->h_addr_list);

    return 0; // success
}

// eof simp_server.cxx

