// WSAenum.cxx : Defines the entry point for the console application.
//
#pragma warning( disable : 4996 )
#include "WSAenum.hxx"
#include "winsockerr.cxx"

typedef struct tagWSAFLAG {
    int flag;
    char * name;
    char * info;
}WSAFLAG, * PWSAFLAG;

WSAFLAG WSAflag1[] = {
    { XP1_CONNECTIONLESS, "CONNECTIONLESS",
    "Provides connectionless (datagram) service. If not set, the protocol supports connection-oriented data transfer." },
    { XP1_GUARANTEED_DELIVERY, "GUARANTEED_DELIVERY",
    "Guarantees that all data sent will reach the intended destination." },
    { XP1_GUARANTEED_ORDER, "GUARANTEED_ORDER",
    "Guarantees that data only arrives in the order in which it was sent and that it is not duplicated. This characteristic does not necessarily mean that the data is always delivered, but that any data that is delivered is delivered in the order in which it was sent." },
    { XP1_MESSAGE_ORIENTED, "MESSAGE_ORIENTED",
    "Honors message boundariesas opposed to a stream-oriented protocol where there is no concept of message boundaries." },
    { XP1_PSEUDO_STREAM, "PSEUDO_STREAM",
    "A message-oriented protocol, but message boundaries are ignored for all receipts. This is convenient when an application does not desire message framing to be done by the protocol." },
    { XP1_GRACEFUL_CLOSE, "GRACEFUL_CLOSE",
    "Supports two-phase (graceful) close. If not set, only abortive closes are performed." },
    { XP1_EXPEDITED_DATA, "EXPEDITED_DATA",
    "Supports expedited (urgent) data." },
    { XP1_CONNECT_DATA, "CONNECT_DATA",
    "Supports connect data." },
    { XP1_DISCONNECT_DATA, "DISCONNECT_DATA",
    "Supports disconnect data." },
    { XP1_INTERRUPT, "INTERRUPT",
    "Bit is reserved." },
    { XP1_SUPPORT_BROADCAST, "SUPPORT_BROADCAST",
    "Supports a broadcast mechanism." },
    { XP1_SUPPORT_MULTIPOINT, "SUPPORT_MULTIPOINT",
    "Supports a multipoint or multicast mechanism. Control and data plane attributes are indicated below." },
    { XP1_MULTIPOINT_CONTROL_PLANE, "MULTIPOINT_CONTROL_PLANE",
    "Indicates whether the control plane is rooted (value = 1) or nonrooted (value = 0)." },
    { XP1_MULTIPOINT_DATA_PLANE, "MULTIPOINT_DATA_PLANE",
    "Indicates whether the data plane is rooted (value = 1) or nonrooted (value = 0)." },
    { XP1_QOS_SUPPORTED, "QOS_SUPPORTED",
    "Supports quality of service requests." },
    { XP1_UNI_SEND, "UNI_SEND",
    "Protocol is unidirectional in the send direction." },
    { XP1_UNI_RECV, "UNI_RECV",
    "Protocol is unidirectional in the recv direction." },
    { XP1_IFS_HANDLES, "IFS_HANDLES",
    "Socket descriptors returned by the provider are operating system Installable File System (IFS) handles." },
    { XP1_PARTIAL_MESSAGE, "PARTIAL_MESSAGE",
    "The MSG_PARTIAL flag is supported in WSASend and WSASendTo." },
    // Note that only one of XP1_UNI_SEND or XP1_UNI_RECV may be set.
    // If a protocol can be unidirectional in either direction, 
    // two WSAPROTOCOL_INFO structures should be used. When neither 
    // bit is set, the protocol is considered to be bidirectional.
    // teminator 
    { 0, 0, 0 }
};

WSAFLAG WSAProv[] = {
    { PFL_MULTIPLE_PROTO_ENTRIES, "PFL_MULTIPLE_PROTO_ENTRIES",
    "Indicates that this is one of two or more entries for a single protocol (from a given provider) which is capable of implementing multiple behaviors. An example of this is SPX which, on the receiving side, can behave either as a message-oriented or a stream-oriented protocol." },
    { PFL_RECOMMENDED_PROTO_ENTRY, "PFL_RECOMMENDED_PROTO_ENTRY",
    "Indicates that this is the recommended or most frequently used entry for a protocol that is capable of implementing multiple behaviors." },
    { PFL_HIDDEN, "PFL_HIDDEN",
    "Set by a provider to indicate to the Ws2_32.dll that this protocol should not be returned in the result buffer generated by WSAEnumProtocols. Obviously, a Windows Sockets 2 application should never see an entry with this bit set." },
    { PFL_MATCHES_PROTOCOL_ZERO, "PFL_MATCHES_PROTOCOL_ZERO",
    "Indicates that a value of zero in the protocol parameter of socket or WSASocket matches this protocol entry." },

    { 0, 0, 0 }
};


/* ==================================
   The WSAEnumProtocols function retrieves information about 
   available transport protocols.

    int WSAEnumProtocols(
      LPINT lpiProtocols,
      LPWSAPROTOCOL_INFO lpProtocolBuffer,
      LPDWORD lpdwBufferLength
    );

    Parameters
    
    lpiProtocols - [in] Null-terminated array of iProtocol values. This 
        parameter is optional; if lpiProtocols is NULL, information on 
        all available protocols is returned. Otherwise, information 
        is retrieved only for those protocols listed in the array. 
    lpProtocolBuffer - [out] Buffer that is filled with WSAPROTOCOL_INFO structures. 
    lpdwBufferLength - [in, out] On input, number of bytes in the lpProtocolBuffer
        buffer passed to WSAEnumProtocols. On output, the minimum buffer size 
        that can be passed to WSAEnumProtocols to retrieve all the requested 
        information. This routine has no ability to enumerate over multiple 
        calls; the passed-in buffer must be large enough to hold all entries 
        in order for the routine to succeed. This reduces the complexity 
        of the API and should not pose a problem because the number of 
        protocols loaded on a computer is typically small. 

    The WSAPROTOCOL_INFO structure is used to store or retrieve 
    complete information for a given protocol.

    typedef struct _WSAPROTOCOL_INFO {
        DWORD dwServiceFlags1;
        DWORD dwServiceFlags2;
        DWORD dwServiceFlags3;
        DWORD dwServiceFlags4;
        DWORD dwProviderFlags;
        GUID ProviderId;
        DWORD dwCatalogEntryId;
        WSAPROTOCOLCHAIN ProtocolChain;
        int iVersion;
        int iAddressFamily;
        int iMaxSockAddr;
        int iMinSockAddr;
        int iSocketType;
        int iProtocol;
        int iProtocolMaxOffset;
        int iNetworkByteOrder;
        int iSecurityScheme;
        DWORD dwMessageSize;
        DWORD dwProviderReserved;
        TCHAR szProtocol[WSAPROTOCOL_LEN+1];
    } WSAPROTOCOL_INFO, *LPWSAPROTOCOL_INFO;

    Members

    dwServiceFlags1 
        Bitmask describing the services provided by the protocol. 
        The above table contains values possible.
    dwServiceFlags2 
        Reserved for additional protocol-attribute definitions. 
    dwServiceFlags3 
        Reserved for additional protocol-attribute definitions. 
    dwServiceFlags4 
        Reserved for additional protocol-attribute definitions. 
    dwProviderFlags 
        Provides information about how this protocol is represented 
        in the protocol catalog. The above table gives flag values possible:
    ProviderId 
        Globally unique identifier assigned to the provider by the service
        provider vendor. This value is useful for instances where more than 
        one service provider is able to implement a particular protocol. 
        An application may use the dwProviderId value to distinguish 
        between providers that might otherwise be indistinguishable. 
    dwCatalogEntryId 
        Unique identifier assigned by the WS2_32.DLL for each WSAPROTOCOL_INFO 
        structure. 
    ProtocolChain 
        WSAPROTOCOLCHAIN structure associated with the protocol. If the 
        length of the chain is 0, this WSAPROTOCOL_INFO entry represents 
        a layered protocol which has Windows Sockets 2 SPI as both its top 
        and bottom edges. If the length of the chain equals 1, this entry 
        represents a base protocol whose Catalog Entry identifier is in 
        the dwCatalogEntryId member of the WSAPROTOCOL_INFO structure. 
        If the length of the chain is larger than 1, this entry represents 
        a protocol chain which consists of one or more layered protocols on 
        top of a base protocol. The corresponding Catalog Entry identifiers 
        are in the ProtocolChain.ChainEntries array starting with the 
        layered protocol at the top (the zero element in the ProtocolChain.
        ChainEntries array) and ending with the base protocol. Refer to 
        the Windows Sockets 2 Service Provider Interface specification 
        for more information on protocol chains. 
    iVersion 
        Protocol version identifier. 
    iAddressFamily 
        Value to pass as the address family parameter to the 
        socket/WSASocket function in order to open a socket for this 
        protocol. This value also uniquely defines the structure of 
        protocol addresses sockaddrs used by the protocol. 
    iMaxSockAddr 
        Maximum address length, in bytes. 
    iMinSockAddr 
        Minimum address length, in bytes. 
    iSocketType 
        Value to pass as the socket type parameter to the socket 
        function in order to open a socket for this protocol. 
    iProtocol 
        Value to pass as the protocol parameter to the socket function 
        in order to open a socket for this protocol. 
    iProtocolMaxOffset 
        Maximum value that may be added to iProtocol when supplying a 
        value for the protocol parameter to socket and WSASocket. Not 
        all protocols allow a range of values. When this is the case 
        iProtocolMaxOffset is zero. 
    iNetworkByteOrder 
        Currently these values are manifest constants 
        (BIGENDIAN and LITTLEENDIAN) that indicate either big-endian or
        little-endian with the values 0 and 1 respectively. 
    iSecurityScheme 
        Indicates the type of security scheme employed (if any). 
        A value of SECURITY_PROTOCOL_NONE is used for protocols that 
        do not incorporate security provisions. 
    dwMessageSize 
        Maximum message size supported by the protocol. This is the 
        maximum size, in bytes, that can be sent from any of the host's 
        local interfaces. For protocols that do not support message 
        framing, the actual maximum that can be sent to a given 
        address may be less. There is no standard provision to 
        determine the maximum inbound message size. The following 
        special values are defined: 

        0 - The protocol is stream-oriented and hence the concept of 
            message size is not relevant. 
        0x1 - The maximum outbound (send) message size is dependent 
            on the underlying network MTU (maximum sized transmission unit) 
            and hence cannot be known until after a socket is bound. 
            Applications should use getsockopt to retrieve the value 
            of SO_MAX_MSG_SIZE after the socket has been bound to 
            a local address. 
        0xFFFFFFFF - The protocol is message-oriented, but there is no 
            maximum limit to the size of messages that may be transmitted. 
    dwProviderReserved 
        Reserved for use by service providers. 
    szProtocol 
        Array of characters that contains a human-readable name 
        identifying the protocol, for example "SPX2". The maximum 
        number of characters allowed is WSAPROTOCOL_LEN, which is 
        defined to be 255. 

   ================================== */
#define MY_MX_PI 100

size_t get_max_flag_buf_size(void)
{
    PWSAFLAG pwsa = &WSAflag1[0];
    size_t sz = 0;
    while ( pwsa->name ) {
        sz += strlen(pwsa->name) + 1;
        pwsa++;
    }
    return sz;
}

size_t get_wsa_flag1(char * dst, int flag)
{
    PWSAFLAG pwsa = &WSAflag1[0];
    size_t sz = 0;
    *dst = 0;
    while ( pwsa->name && flag ) {
        if (flag & pwsa->flag) {
            if (*dst)
                strcat(dst," ");
            strcat(dst,pwsa->name);
            flag &= ~pwsa->flag;
        }
        pwsa++;
    }
    return sz;
}

// WSAFLAG WSAProv[] = {
size_t get_max_prov_buf_size(void)
{
    PWSAFLAG pwsa = &WSAProv[0];
    size_t sz = 0;
    while ( pwsa->name ) {
        sz += strlen(pwsa->name) + 1;
        pwsa++;
    }
    return sz;
}

size_t get_wsa_prov(char * dst, int flag)
{
    PWSAFLAG pwsa = &WSAProv[0];
    size_t sz = 0;
    *dst = 0;
    while ( pwsa->name && flag ) {
        if (flag & pwsa->flag) {
            if (*dst)
                strcat(dst," ");
            strcat(dst,pwsa->name);
            flag &= ~pwsa->flag;
        }
        pwsa++;
    }
    return sz;
}

typedef struct tagVALNAM {
    int value;
    char * name;
}VALNAM, * PVALNAM;

VALNAM ip_family[] = {
    { AF_UNSPEC, "AF_UNSPEC" }, // 0  The address family is unspecified.
    { AF_INET, "AF_INET" }, // 2  The Internet Protocol version 4 (IPv4) address family.
    { AF_IPX, "AF_IPX" }, // 6  The IPX/SPX address family. This address family is only supported if the NWLink IPX/SPX NetBIOS Compatible Transport protocol is installed. 
    // This address family is not supported on Windows Vista and later.
    { AF_APPLETALK, "AF_APPLETALK" }, // 16  The AppleTalk address family. This address family is only supported if the AppleTalk protocol is installed. 
    // This address family is not supported on Windows Vista and later.
    { AF_NETBIOS, "AF_NETBIOS" }, // 17  The NetBIOS address family. This address family is only supported if the Windows Sockets provider for NetBIOS is installed. 
    // The Windows Sockets provider for NetBIOS is supported on 32-bit versions of Windows. This provider is installed by default on 32-bit versions of Windows. 
    // The Windows Sockets provider for NetBIOS is not supported on 64-bit versions of windows including Windows 7, Windows Server 2008, Windows Vista, Windows Server 2003, or Windows XP. 
    // The Windows Sockets provider for NetBIOS only supports sockets where the type parameter is set to SOCK_DGRAM.
    // The Windows Sockets provider for NetBIOS is not directly related to the NetBIOS programming interface. The NetBIOS programming interface is not supported on Windows Vista, Windows Server 2008, and later.
    { AF_INET6, "AF_INET6" }, // 23  The Internet Protocol version 6 (IPv6) address family.
    { AF_IRDA, "AF_IRDA" }, // 26  The Infrared Data Association (IrDA) address family. 
    // This address family is only supported if the computer has an infrared port and driver installed.
#ifdef AF_BTH
    { AF_BTH, "AF_BTH" }, // 32  The Bluetooth address family. 
    // This address family is supported on Windows XP with SP2 or later if the computer has a Bluetooth adapter and driver installed.
#endif // AF_BTH
    { 0 , 0 }
};

VALNAM ip_type[] = {
    { SOCK_STREAM, "SOCK_STREAM" },
    { SOCK_DGRAM,  "SOCK_DGRAM" },
    { SOCK_RAW,    "SOCK_RAW"   },
    { 0 , 0 }
};

char * get_ip_family(int val)
{
    static char _s_ipf[64];
    PVALNAM pvn = &ip_family[0];
    while (pvn->name) {
        if (val == pvn->value)
            return pvn->name;
        pvn++;
    }
    char * cp = _s_ipf;
    sprintf(cp,"Val %d (0x%X) unknown", val,val);
    return cp;
}

char * get_ip_type(int val)
{
    static char _s_ipf[64];
    PVALNAM pvn = &ip_type[0];
    while (pvn->name) {
        if (val == pvn->value)
            return pvn->name;
        pvn++;
    }
    char * cp = _s_ipf;
    sprintf(cp,"Val %d (0x%X) unknown", val,val);
    return cp;
}

//#define  DEF_CP   CP_ACP
#define  DEF_CP   CP_UTF8
// int Wide2UTF8( LPCWSTR pFile, char * ps, int len )
int Wide2UTF8( wchar_t * pFile, char * ps, int len )
{
   int wlen = lstrlenW(pFile);
   // The number includes the byte for the null terminator
   int ret = WideCharToMultiByte( DEF_CP, // UINT CodePage,            // code page
      0, // DWORD dwFlags,            // performance and mapping flags
      pFile,   // LPCWSTR lpWideCharStr,    // wide-character string
      wlen,     // int cchWideChar,          // number of chars in string.
      ps,      // LPSTR lpMultiByteStr,     // buffer for new string
      len,    // int cbMultiByte,          // size of buffer
      NULL,    // LPCSTR lpDefaultChar,     // default for unmappable chars
      NULL );  // LPBOOL lpUsedDefaultChar  // set when default char used
   ps[ret] = 0;
   //if(ret)
   //   ps[ret-1] = 0;
   return ret;
}


void show_pi(LPWSAPROTOCOL_INFO pi)
{
    size_t max = get_max_flag_buf_size();
    char * fb = new char[max];
#ifdef _MBCS
    char * pb =  pi->szProtocol;
#else
    size_t plen = lstrlen(pi->szProtocol);
    char * pb = new char[plen+1];
    Wide2UTF8( pi->szProtocol, pb, (int)plen );
#endif
    size_t prs = get_max_prov_buf_size();
    char * prb = new char[prs+1];
    get_wsa_flag1(fb, pi->dwServiceFlags1);
    get_wsa_prov(prb, pi->dwProviderFlags);
    printf("Protocol       = [%s] %s, vers %d\n", pb,
        ((pi->dwServiceFlags1 & XP1_UNI_SEND) ? "SEND" :
        (pi->dwServiceFlags1 & XP1_UNI_RECV) ? "RECV" : "BI"),
        pi->iVersion );
    printf("IP family/type = [%s]/[%s]\n", get_ip_family(pi->iAddressFamily),
        get_ip_type(pi->iSocketType));
    printf("ServiceFlags1  = [%s]\n", fb);
    if (strlen(prb))
        printf("ProviderFlags  = [%s]\n", prb);

    delete fb;
#ifndef _MBCS
    delete pb;
#endif
    delete prb;
    printf("\n");
}

int main(int argc, char * argv[])
{
    int i;
    DWORD buflen = sizeof(WSAPROTOCOL_INFO) * MY_MX_PI;
    LPWSAPROTOCOL_INFO ppi = new WSAPROTOCOL_INFO[MY_MX_PI];
    sock_init();
    int res = WSAEnumProtocols(
        NULL, // LPINT lpiProtocols,
        ppi, // LPWSAPROTOCOL_INFO lpProtocolBuffer,
        &buflen );
    printf("WSAEnumProcols returned %d\n", res);
    if (res == -1) {
        PERROR("WSAEnumProtocols() FAILED");
    } else {
        for (i = 0; i < res; i++) {
            LPWSAPROTOCOL_INFO pi = &ppi[i];
            show_pi(pi);
        }
    }
    sock_end();
    delete ppi;
	return res;
}

// eof - WSAenum.cxx
