// fgw_paint.cxx

#include "fg_win.hxx"
#include <string>
#include <Windowsx.h>

using namespace std;

char * g_text = "No file loaded";

HFONT hfCN8 = NULL;
HFONT Get_CN8_Font( HDC hdc )
{
   LOGFONT lf;
   LOGFONT * plf = &lf;
   HFONT hf = hfCN8;
   if(hf)
      return hf;
   ZeroMemory( plf, sizeof(LOGFONT) );
   plf->lfHeight = -MulDiv( 8, GetDeviceCaps(hdc, LOGPIXELSY), 72 );
   strcpy( &plf->lfFaceName[0], "Courier New" );
   //plf->lfWeight = FW_BOLD;   // set BOLD font
   hf = CreateFontIndirect( plf );
   hfCN8 = hf;
   return hf;
}


void fgw_paint( HWND hWnd, HDC hdc )
{
    RECT rc;
    POINT pt;
    SIZE sz;
    char * ps = g_text;
    int len = (int)strlen(ps);
    GetClientRect(hWnd, &rc);
    pt.x = rc.right / 2;
    pt.y = rc.bottom / 2;
    GetTextExtentPoint32( hdc, ps, len, &sz );
    pt.x = (rc.right / 2) - (sz.cx / 2);
    TextOut(
        hdc,   // HDC hdc,           // handle to DC
        pt.x,  // int nXStart,       // x-coordinate of starting position
        pt.y,  // int nYStart,       // y-coordinate of starting position
        ps,// LPCTSTR lpString,  // character string
        len );
}


string get_mouse_buttons( WPARAM wParam )
{
    string s = "";
    if (wParam & MK_CONTROL)
        s += "C"; // 0x0008  The CTRL key is down.
    if (wParam & MK_LBUTTON)
        s += "L"; // 0x0001  The left mouse button is down.
    if (wParam & MK_MBUTTON)
        s += "M"; //0x0010  The middle mouse button is down.
    if (wParam & MK_RBUTTON)
        s += "R"; //0x0002  The right mouse button is down.
    if (wParam & MK_SHIFT)
        s += "S"; //0x0004  The SHIFT key is down.
    if (wParam & MK_XBUTTON1)
        s += "X"; //0x0020  The first X button is down.
    if (wParam & MK_XBUTTON2)
        s += "2"; //0x0040  The second X button is down.
    return s;
}



void Paint_Mouse_Pos( HWND hWnd, WPARAM wParam, LPARAM lParam )
{
    static int prev_len = 0;
    static POINT prev_pt;
    static char _s_mp_buff[256];
    char * ps = _s_mp_buff;
    int xPos = GET_X_LPARAM(lParam);
    int yPos = GET_Y_LPARAM(lParam);
    HDC hdc = GetDC(hWnd);
    string s = get_mouse_buttons(wParam);
    int len;
    RECT rc;
    POINT pt;
    SIZE sz;
    GetClientRect(hWnd, &rc);
    if (hdc) {
        HFONT hf = Get_CN8_Font(hdc);
        HFONT hfold = NULL;
        if (hf)
            hfold = (HFONT)SelectObject(hdc,hf);

        if (prev_len) {
            *ps = 0;
            while ((int)strlen(ps) < prev_len)
                strcat(ps," ");
            len = (int)strlen(ps);
            TextOut(
                hdc,   // HDC hdc,           // handle to DC
                prev_pt.x,  // int nXStart,       // x-coordinate of starting position
                prev_pt.y,  // int nYStart,       // y-coordinate of starting position
                ps,// LPCTSTR lpString,  // character string
                len );
        }
        len = sprintf(ps,"x=%d y=%d %s", xPos, yPos, s.c_str());
        //len = sprintf(ps,"At x=%d y=%d on %d,%d", xPos, yPos, rc.right, rc.bottom);
        GetTextExtentPoint32( hdc, ps, len, &sz );
        pt.y = (rc.bottom - rc.top) - sz.cy;
        pt.x = (rc.right - rc.left) - sz.cx;
        TextOut(
            hdc,   // HDC hdc,           // handle to DC
            pt.x,  // int nXStart,       // x-coordinate of starting position
            pt.y,  // int nYStart,       // y-coordinate of starting position
            ps,// LPCTSTR lpString,  // character string
            len );
        if (len > prev_len) {
            prev_len = len;
            prev_pt.x = pt.x;
            prev_pt.y = pt.y;
        }
        if (hfold)
            SelectObject(hdc,hfold);
        ReleaseDC(hWnd,hdc);
    }
}

// eof - fgw_paint.cxx
