#!/bin/sh
# created geoff mclane Mon Apr  4 10:30:53 CEST 2011 report@geoffair.info
BN=`basename $0`
PREFIX="--prefix=/home/geoff"
OPTIONS=""
set -e
if [ -f "autogen.sh" ]; then
   if [ ! -x autogen.sh ]; then
      chmod +x autogen.sh
   fi
   if [ -f configure ]; then
      rm -v -f configure
   fi
   if [ -f Makefile ]; then
      rm -v -f Makefile
   fi
   echo "$BN: Running autogen.sh..."
   ./autogen.sh
   echo "$BN: Done autogen.sh..."
   if [ ! -f configure ]; then
      echo ""
      echo "$BN: ERROR: configure file not created..."
      echo ""
      exit 1
   fi
   echo "$BN: Doing: ./configure $PREFIX $OPTIONS"
   ./configure $PREFIX $OPTIONS
   echo "$BN: Done configure - check carefully..."
   if [ ! -f Makefile ]; then
      echo ""
      echo "$BN: ERROR: Makefile not created..."
      echo ""
      exit 1
   fi
   echo "$BN: Doing: 'make'"
   make
   echo "$BN: Done 'make'"
   echo "$BN: configure was [$PREFIX $OPTIONS]"
   echo "$BN: Ready for 'make install', if no errors..."
   if [ -z "$PREFIX" ]; then
      echo "$BN: Will install to /usr/bin"
   else
      echo "$BN: Will install to $PREFIX/bin"
   fi
   echo ""
else
   echo ""
   echo "$BN: can not locate 'autogen.sh'..."
   echo ""
   exit 1
fi
exit 0
