//
// "$Id: input_choice.cxx 5890 2007-06-07 17:38:49Z matt $"
//
// Test program for Fl_Input_Choice
//
// Copyright 1998-2006 by Bill Spitzak and others.
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA.
//

#include <stdio.h>
#include <FL/Fl_Button.H>
#include <FL/Fl_Window.H>
#include <FL/Fl_Input_Choice.H>
#include <string>

using namespace std;

void buttcb(Fl_Widget*,void*data) {
    Fl_Input_Choice *in=(Fl_Input_Choice *)data;
    static int flag = 1;
    flag ^= 1;
    if ( flag ) in->activate();
    else        in->deactivate();
    if (in->changed()) {
        printf("Callback: changed() is set\n");
        in->clear_changed();
    }
}

void input_choice_cb(Fl_Widget*,void*data) {
    Fl_Input_Choice *in=(Fl_Input_Choice *)data;
    fprintf(stderr, "Value='%s'\n", (const char*)in->value());
}

void input_cb(Fl_Widget* pw,void* data) {
    string s;
    Fl_Input_Choice *in=(Fl_Input_Choice *)data;
    Fl_Input * pn = (Fl_Input *)pw;
    const char * nval = pn->value();
    int slen = (int)strlen(nval);
    if (slen) {
        if (nval[0] != '/') {
            s = "/";
            s += nval;
            nval = s.c_str();
        }
        in->add(nval);
    } else
        return;

    const Fl_Menu_Item * pmi = in->menu();
    int size = pmi->size();
    int i;
    int cnt = 0;
    printf("Fl_Menu_Item size = %d\n", size );
    for (i = 0; i < size; i++) {
        const Fl_Menu_Item * pm1 = pmi->next(i);
        if (pm1) {
            const char * cp = pm1->text;
            if (cp) {
                cnt++;
                printf("%d [%s]\n", cnt, cp);
            } else
                break;
        } else
            break;
    }
#ifdef TRIED_THIS_AND_FAILED
    const Fl_Menu_Item * pm1 = pmi->first();
    cnt = 0;
    if (pm1) {
        do
        {
            cnt++;
            const char * cp = pm1->text;
            printf("%d [%s]\n", cnt, cp);
        } while ((pm1 = pmi->next()) != NULL);
    }
#endif // #ifdef TRIED_THIS_AND_FAILED

    fprintf(stderr, "Value='%s' (in=%s)\n", nval, (const char*)in->value());
}


int main(int argc, char **argv) {
    Fl_Window win(300, 200);

    Fl_Input_Choice in(40,40,100,28,"Test");
    in.callback(input_choice_cb, (void*)&in);
    in.add("one");
    in.add("two");
    in.add("three");
    in.value(1);

    Fl_Input inp(40,80,100,28,"New:");
    inp.callback(input_cb, (void*)&in);

    Fl_Button onoff(40,150,200,28,"Activate/Deactivate");
    onoff.callback(buttcb, (void*)&in);

    win.end();
    win.resizable(win);
    win.show(argc, argv);
    return Fl::run();
}


//
// End of "$Id: input_choice.cxx 5890 2007-06-07 17:38:49Z matt $".
//
