FIND_PACKAGE(PkgConfig)

MACRO(CHECK_BACKEND BACKEND_OPTION BACKEND_NAME BACKEND_LIB BACKEND_HEADER BACKEND_TEST_FUNC)
IF(${BACKEND_OPTION} AND NOT ${BACKEND_OPTION}_FOUND MATCHES "1${${BACKEND_OPTION}_DLOPEN}")
  SET(BACKEND_HAVE 0)
  IF(CMAKE_PKGCONFIG_EXECUTABLE AND NOT ${BACKEND_NAME} MATCHES "^$")
    PKGCONFIG(${BACKEND_NAME}
              BACKEND_HAVE
              BACKEND_INCLUDE_DIRS
              BACKEND_DEFINES
              BACKEND_LINK_DIRS
              BACKEND_LIBS)

    IF(BACKEND_HAVE)
      SET(${BACKEND_OPTION}_INCLUDE_DIRS
          "${BACKEND_INCLUDE_DIRS};${${BACKEND_OPTION}_INCLUDE_DIR}" CACHE INTERNAL "")
      SET(${BACKEND_OPTION}_DEFINES      "${BACKEND_DEFINES}"        CACHE INTERNAL "")
      SET(${BACKEND_OPTION}_LINK_DIRS    "${BACKEND_LINK_DIRS}"      CACHE INTERNAL "")
      SET(${BACKEND_OPTION}_LIBS         "${BACKEND_LIBS}"           CACHE INTERNAL "")
    ENDIF(BACKEND_HAVE)
  ENDIF(CMAKE_PKGCONFIG_EXECUTABLE AND NOT ${BACKEND_NAME} MATCHES "^$")

  IF(NOT BACKEND_HAVE)
    # don't want or have pkg-config, or  it failed
    SET(${BACKEND_OPTION}_INCLUDE_DIRS "${${BACKEND_OPTION}_INCLUDE_DIR}" CACHE INTERNAL "")
    SET(${BACKEND_OPTION}_LINK_DIRS    "${${BACKEND_OPTION}_LIB_DIR}"     CACHE INTERNAL "")
    SET(${BACKEND_OPTION}_LIBS         "${BACKEND_LIB}"                   CACHE INTERNAL "")
  ENDIF(NOT BACKEND_HAVE)

  #MESSAGE("have ${${BACKEND_OPTION}_HAVE} inc ${${BACKEND_OPTION}_INCLUDE_DIRS} def ${${BACKEND_OPTION}_DEFINES} linkdirs ${${BACKEND_OPTION}_LINK_DIRS} libs ${${BACKEND_OPTION}_LIBS}")

  SET(SOURCE
"#include <${BACKEND_HEADER}>
int main(){return 0;}
")
  # CHECK_INCLUDE_FILE() doesn't handle include dir, so check by hand
  FILE(WRITE "${CMAKE_BINARY_DIR}/CMakeTmp/src.c" "${SOURCE}")

  TRY_COMPILE(HAVE_BACKEND_HEADER
              ${CMAKE_BINARY_DIR}
              ${CMAKE_BINARY_DIR}/CMakeTmp/src.c
              CMAKE_FLAGS
              "-DINCLUDE_DIRECTORIES:STRING=${${BACKEND_OPTION}_INCLUDE_DIRS}"
              "-DCOMPILE_DEFINITIONS:STRING=${${BACKEND_OPTION}_DEFINES}"
              OUTPUT_VARIABLE OUTPUT)

   WRITE_FILE(${CMAKE_BINARY_DIR}/CMakeOutput.log
              "Performing manual C SOURCE FILE Test HAVE_BACKEND_HEADER for ${BACKEND_OPTION} with the following output:\n"
              "${OUTPUT}\n"
              "Source file was:\n${SOURCE}\n" APPEND)

  IF(HAVE_BACKEND_HEADER)
    IF(HAVE_DL AND ${BACKEND_OPTION}_DLOPEN)
      SET(${BACKEND_OPTION}_FOUND "1${${BACKEND_OPTION}_DLOPEN}" CACHE INTERNAL "")
    ELSE(HAVE_DL AND ${BACKEND_OPTION}_DLOPEN)

      IF(NOT ${BACKEND_LIB} MATCHES "^$")
      IF(${BACKEND_OPTION}_LIBS MATCHES "^$")
        FIND_LIBRARY(${BACKEND_OPTION}_LIBS ${BACKEND_LIB} PATHS /usr/lib /usr/local/lib)
      ENDIF(${BACKEND_OPTION}_LIBS MATCHES "^$")

      IF(${BACKEND_OPTION}_LIBS MATCHES "NOTFOUND")
        MESSAGE(STATUS "${BACKEND_OPTION} library ${BACKEND_LIB} not found.")
      ELSE(${BACKEND_OPTION}_LIBS MATCHES "NOTFOUND")

        # check whether back-end is link-able
        SET(SOURCE
"int main(){${BACKEND_TEST_FUNC}();return 0;}
")
        FILE(WRITE "${CMAKE_BINARY_DIR}/CMakeTmp/src.c" "${SOURCE}")

        TRY_COMPILE(BACKEND_LINKS
          ${CMAKE_BINARY_DIR}
          ${CMAKE_BINARY_DIR}/CMakeTmp/src.c
          CMAKE_FLAGS
          "-DINCLUDE_DIRECTORIES:STRING=${${BACKEND_OPTION}_INCLUDE_DIRS}"
          "-DLINK_DIRECTORIES:STRING=${${BACKEND_OPTION}_LINK_DIRS}"
          "-DLINK_LIBRARIES:STRING=${${BACKEND_OPTION}_LIBS}"
          "-DCOMPILE_DEFINITIONS:STRING=${${BACKEND_OPTION}_DEFINES}"
          OUTPUT_VARIABLE OUTPUT)

        WRITE_FILE(${CMAKE_BINARY_DIR}/CMakeOutput.log
                   "Performing manual C SOURCE FILE Test BACKEND_LINKS for ${BACKEND_OPTION} with the following output:\n"
                   "${OUTPUT}\n"
                   "Source file was:\n${SOURCE}\n" APPEND)

        IF(BACKEND_LINKS)
          SET(${BACKEND_OPTION}_FOUND "1${${BACKEND_OPTION}_DLOPEN}" CACHE INTERNAL "")
        ELSE(BACKEND_LINKS)

          MESSAGE(STATUS "${BACKEND_OPTION} doesn't link.")
        ENDIF(BACKEND_LINKS)
      ENDIF(${BACKEND_OPTION}_LIBS MATCHES "NOTFOUND")
      ELSE(NOT ${BACKEND_LIB} MATCHES "^$")
        SET(${BACKEND_OPTION}_FOUND "1${${BACKEND_OPTION}_DLOPEN}" CACHE INTERNAL "")
      ENDIF(NOT ${BACKEND_LIB} MATCHES "^$")
    ENDIF(HAVE_DL AND ${BACKEND_OPTION}_DLOPEN)
  ELSE(HAVE_BACKEND_HEADER)

    MESSAGE(STATUS "${BACKEND_OPTION} header ${BACKEND_HEADER} not found.")
  ENDIF(HAVE_BACKEND_HEADER)
ENDIF(${BACKEND_OPTION} AND NOT ${BACKEND_OPTION}_FOUND MATCHES "1${${BACKEND_OPTION}_DLOPEN}")

IF(${BACKEND_OPTION} AND ${BACKEND_OPTION}_FOUND MATCHES "1${${BACKEND_OPTION}_DLOPEN}")
  SET(OS_OBJS ${OS_OBJS} ${${BACKEND_OPTION}_OBJS})
  # kinda hack, but won't hurt
  ADD_DEFINE(USE_BACKEND_${BACKEND_OPTION})
  ADD_DEFINE(ENABLE_EXTENSION_AL_EXT_${BACKEND_OPTION})
  INCLUDE_DIRECTORIES(${${BACKEND_OPTION}_INCLUDE_DIRS})

  SET(ADD_CFLAGS "${${BACKEND_OPTION}_DEFINES} ${ADD_CFLAGS}")

  IF(HAVE_DL AND ${BACKEND_OPTION}_DLOPEN)
    ADD_DEFINE(OPENAL_DLOPEN_${BACKEND_OPTION})
    MESSAGE(STATUS "${BACKEND_OPTION} support - dynamic")
  ELSE(HAVE_DL AND ${BACKEND_OPTION}_DLOPEN)

    SET(ADD_LIBS ${ADD_LIBS} ${${BACKEND_OPTION}_LIBS})
    LINK_DIRECTORIES(${${BACKEND_OPTION}_LINK_DIRS})
    MESSAGE(STATUS "${BACKEND_OPTION} support - static")
  ENDIF(HAVE_DL AND ${BACKEND_OPTION}_DLOPEN)
ELSE(${BACKEND_OPTION} AND ${BACKEND_OPTION}_FOUND MATCHES "1${${BACKEND_OPTION}_DLOPEN}")

  MESSAGE(STATUS "${BACKEND_OPTION} support - disabled")
  SET(${BACKEND_OPTION} OFF CACHE BOOL "" FORCE)
ENDIF(${BACKEND_OPTION} AND ${BACKEND_OPTION}_FOUND MATCHES "1${${BACKEND_OPTION}_DLOPEN}")
ENDMACRO(CHECK_BACKEND)
