# needs to be called after ConfigHelper and SleepFunction
CHECK_INCLUDE_FILE_DEFINE(unistd.h HAVE_UNISTD_H)
CHECK_INCLUDE_FILE_DEFINE(sys/select.h HAVE_SYS_SELECT_H)
CHECK_INCLUDE_FILE_DEFINE(sys/socket.h HAVE_SYS_SOCKET_H)
CHECK_INCLUDE_FILE_DEFINE(sys/time.h HAVE_SYS_TIME_H)
CHECK_INCLUDE_FILE_DEFINE(sys/types.h HAVE_SYS_TYPES_H)

IF(NOT DEFINED SELECT_TYPE_ARG1)
MESSAGE(STATUS "Determining select arguments")
SET(ARG234 "fd_set *;int *;void *")
SET(ARG1 "int;size_t;unsigned long;unsigned")
SET(ARG5 "struct timeval *;const struct timeval *")

SET(SOURCE_DEFINITIONS "-DHAVE_SYS_TYPES_H=${HAVE_SYS_TYPES_H}")
SET(SOURCE_DEFINITIONS "${SOURCE_DEFINITIONS} -DHAVE_SYS_TIME_H=${HAVE_SYS_TIME_H}")
SET(SOURCE_DEFINITIONS "${SOURCE_DEFINITIONS} -DHAVE_UNISTD_H=${HAVE_UNISTD_H}")
SET(SOURCE_DEFINITIONS "${SOURCE_DEFINITIONS} -DHAVE_SYS_SELECT_H=${HAVE_SYS_SELECT_H}")
SET(SOURCE_DEFINITIONS "${SOURCE_DEFINITIONS} -DHAVE_SYS_SOCKET_H=${HAVE_SYS_SOCKET_H}")

FOREACH(CUR_ARG234 ${ARG234})
IF(NOT SELECT_ARGTYPES_FOUND)
FOREACH(CUR_ARG1 ${ARG1})
IF(NOT SELECT_ARGTYPES_FOUND)
FOREACH(CUR_ARG5 ${ARG5})
IF(NOT SELECT_ARGTYPES_FOUND)

CONFIGURE_FILE(${CMAKE_SOURCE_DIR}/admin/CMakeModules/SelectArgtypes.c.in
  ${CMAKE_BINARY_DIR}/CMakeFiles/CMakeTmp/SelectArgtypes.c IMMEDIATE)

TRY_COMPILE(SELECT_ARGTYPES_FOUND
  ${CMAKE_BINARY_DIR}
  ${CMAKE_BINARY_DIR}/CMakeFiles/CMakeTmp/SelectArgtypes.c
  CMAKE_FLAGS
  "-DCOMPILE_DEFINITIONS:STRING=${SOURCE_DEFINITIONS}"
  OUTPUT_VARIABLE OUTPUT)

WRITE_FILE(${CMAKE_BINARY_DIR}/CMakeFiles/CMakeOutput.log
  "Performing C SOURCE FILE Test SELECT_ARGTYPES with the following output:\n"
  "${OUTPUT}\n" APPEND)

IF(SELECT_ARGTYPES_FOUND)
  MESSAGE(STATUS "Determining select arguments - found")
  SET(SELECT_TYPE_ARG1 ${CUR_ARG1} CACHE INTERNAL "")
  SET(SELECT_TYPE_ARG234 ${CUR_ARG234} CACHE INTERNAL "")
  SET(SELECT_TYPE_ARG5 ${CUR_ARG5} CACHE INTERNAL "")
ENDIF(SELECT_ARGTYPES_FOUND)

ENDIF(NOT SELECT_ARGTYPES_FOUND)
ENDFOREACH(CUR_ARG5)
ENDIF(NOT SELECT_ARGTYPES_FOUND)
ENDFOREACH(CUR_ARG1)
ENDIF(NOT SELECT_ARGTYPES_FOUND)
ENDFOREACH(CUR_ARG234)

IF(NOT SELECT_ARGTYPES_FOUND)
  MESSAGE(STATUS "Determining select arguments - using fallback")
  SET(SELECT_TYPE_ARG1 "int" CACHE INTERNAL "")
  SET(SELECT_TYPE_ARG234 "int *" CACHE INTERNAL "")
  SET(SELECT_TYPE_ARG5 "struct timeval *" CACHE INTERNAL "")
ENDIF(NOT SELECT_ARGTYPES_FOUND)
ENDIF(NOT DEFINED SELECT_TYPE_ARG1)

ADD_DEFINE("SELECT_TYPE_ARG1 ${SELECT_TYPE_ARG1}")
ADD_DEFINE("SELECT_TYPE_ARG234 (${SELECT_TYPE_ARG234})")
ADD_DEFINE("SELECT_TYPE_ARG5 (${SELECT_TYPE_ARG5})")
