#!Perl -w
# see if we can FIND the Version strings, like

use strict;
use warnings;


my $in_file1 = 'OpenSceneGraph\CMakeLists.txt';
# SET(OPENSCENEGRAPH_MAJOR_VERSION 2)
# SET(OPENSCENEGRAPH_MINOR_VERSION 7)
# SET(OPENSCENEGRAPH_PATCH_VERSION 3)
# SET(OPENSCENEGRAPH_SOVERSION 47)

my $in_file2 = 'OpenSceneGraph\src\OpenThreads\CMakeLists.txt';
# SET(OPENTHREADS_SOVERSION 11)

my $maj_ver = -1;
my $min_ver = -1;
my $pat_ver = -1;
my $sov_ver = -1;
my $oth_ver = -1;
my (@lines, $line);

if (open INF, "<$in_file1") {
	@lines = <INF>;
	close INF;
	foreach $line (@lines) {
		chomp $line;
		if ($line =~ /\s*SET\s*\(\s*OPENSCENEGRAPH_MAJOR_VERSION\s+(\d)+\s*\)/ ) {
			$maj_ver = $1;
		} elsif ($line =~ /\s*SET\s*\(\s*OPENSCENEGRAPH_MINOR_VERSION\s+(\d)+\s*\)/ ) {
			$min_ver = $1;
		} elsif ($line =~ /\s*SET\s*\(\s*OPENSCENEGRAPH_PATCH_VERSION\s+(\d)+\s*\)/ ) {
			$pat_ver = $1;
		} elsif ($line =~ /\s*SET\s*\(\s*OPENSCENEGRAPH_SOVERSION\s+(\d\d)+\s*\)/ ) {
			$sov_ver = $1;
		}
		if (($maj_ver != -1)&&($min_ver != -1)&&($pat_ver != -1)&&($sov_ver != -1)) {
			last;	# we found em ALL ;=))
		}
	}
}
if (open INF, "<$in_file2") {
	@lines = <INF>;
	close INF;
	foreach $line (@lines) {
		if ($line =~ /\s*SET\s*\(\s*OPENTHREADS_SOVERSION\s+(\d\d)+\s*\)/) {
			$oth_ver = $1;
			last;
		}
	}
}

my $dnout = 0;
# @set TEMPOSGV=47
# @set TEMPPIV=2.7.3
# @set TEMPOTV=11
my $msg = "SUGGEST ";
$msg .= "\nset TEMPOSGV=";
if ($sov_ver != -1) {
	$msg .= "$sov_ver ";
	$dnout++;
} else {
	$msg .= "not found! ";
}

$msg .= "\nset TEMPPIV=";
if ($maj_ver != -1) {
	$msg .= "$maj_ver.$min_ver.$pat_ver ";
	$dnout++;
} else {
	$msg .= "not found! ";
}

$msg .= "\nset TEMPOTV=";
if ($oth_ver != -1) {
	$msg .= "$oth_ver ";
	$dnout++;
} else {
	$msg .= "not found! ";
}
print $msg."\n";

# eof - chkosgver.pl


