@echo Update the RUNTIME, to a 'bin' folder ...
@echo This requires nmake.exe to be in the path ...
@REM User Variables - These MUST be adjusted to suit the OpenSceneGraph version used
@REM ===============================================================================
@set TEMPOSGV=61
@set TEMPPIV=2.9.6
@set TEMPOTV=11
@REM end user variables ============================================================
@REM ===============================================================================
@echo Using OSG V=%TEMPOSGV%, Plug-in=%TEMPPIV%, OpenThreads=%TEMPOTV% ...
@REM Test for certain items which MUST be built, and available ...
@set TEMPTEST=OpenSceneGraph\bin\osg%TEMPOSGV%-osg.dll
@if NOT EXIST %TEMPTEST% goto NODLL1 
@set TEMPTEST=OpenSceneGraph\bin\osgPlugins-%TEMPPIV%\osgdb_ac.dll
@if NOT EXIST %TEMPTEST% goto NODLL1 
@set TEMPTEST=OpenSceneGraph\bin\osgPlugins-%TEMPPIV%\osgdb_rgb.dll
@if NOT EXIST %TEMPTEST% goto NODLL1 
@set TEMPTEST=OpenSceneGraph\bin\osgPlugins-%TEMPPIV%\osgdb_png.dll
@if NOT EXIST %TEMPTEST% goto NODLL2 
@set TEMPTEST=OpenSceneGraph\bin\osgPlugins-%TEMPPIV%\osgdb_zip.dll
@if NOT EXIST %TEMPTEST% goto NODLL2 
@set TEMPTEST=OpenSceneGraph\bin\ot%TEMPOTV%-openthreads.dll
@if NOT EXIST %TEMPTEST% goto NODLL1 
@set TEMP1=update.mak
@if NOT EXIST %TEMP1% goto ERR1

@REM Set TEMPDBG
@set TEMPDBG=RELEASE
@if "%1x" == "x" goto DNTDBG
@if /i "%1x" EQU "dx" (
@set TEMPDBG=DEBUG
) ELSE IF /i "%1x" EQU "debugx" (
@set TEMPDBG=DEBUG
) ELSE IF /i "%1x" EQU "rx" (
@set TEMPDBG=RELEASE
) ELSE IF /i "%1x" EQU "releasex" (
@set TEMPDBG=RELEASE
) ELSE (
@echo ERROR: Only first command is D or R, for debug, or release ..
@goto END
)
:DNTDBG
@echo Set TEMPDBG=%TEMPDBG% ...

@REM Set runtime folder
@set TEMP2=bin
@if "%2." == "." goto GOTRT
@set TEMP2=%2
:GOTRT
@if NOT EXIST %TEMP2%\. goto CHECK
@goto DNBIN
:CHECK
@echo Folder [%TEMP2%] does NOT EXIST! ... Create a NEW folder? ... Ctrl+C to ABORT ...
@echo NOTE: THIS SHOULD NOT BE REQUIRED IF SETUPFG.BAT WAS RUN FIRST!!!
@pause
md %TEMP2%
@if ERRORLEVEL 1 goto RTERR
@if NOT EXIST %TEMP2%\nul goto RTERR
@REM md %TEMP2%\OpenAL
@goto DNBIN
:RTERR
@echo ERROR: Can NOT create RUNTIME folder %TEMP2% ... check name, location, ...
@goto END
:DNBIN

@echo Testing NMAKE ...
@echo all: tempm2 >tempmake
@echo.>>tempmake
@echo tempm2: tempmake>>tempmake
@echo  @copy tempmake tempm2 \>nul >>tempmake
@nmake /nologo /f tempmake all >nul
@set TEMPERR=%ERRORLEVEL%
@if ERRORLEVEL 1 goto NONMAKE
@echo Appears NMAKE is ok ...
@if EXIST tempmake del tempmake >nul
@if EXIST tempm2 del tempm2 >nul
@goto DNNMAKE

:NONMAKE
@if EXIST tempmake del tempmake >nul
@if EXIST tempm2 del tempm2 >nul
@echo Appeare NMAKE.EXE is NOT in your PATH ... or it did NOT perform correctly
@echo Are you running in the MSVC command prompt?
@REM @pause
@goto NOMAKE

:DNNMAKE
@REM Check on destination of ALUT.DLL
@REM But this FAILS in Vista, without admin priv, so removed
@REM if "%SYSTEMROOT%x" == "x" goto NOSYSRT

@set TEMP1OR=updosgr.mak
@set TEMP1OD=updosgd.mak
@set TEMP1PR=updpinr.mak
@set TEMP1PD=updpind.mak
@if NOT EXIST %TEMP1OR% goto NORMAK
@if NOT EXIST %TEMP1PR% goto NORMAK
@if "%TEMPDBG%x" == "RELEASEx" goto FNDMKS
@if NOT EXIST %TEMP1OD% goto NODMAK
@if NOT EXIST %TEMP1PD% goto NODMAK
:FNDMKS

@echo Doing a TEST run of each of the make files ... TEMPDBG=%TEMPDBG%
@set TEMPCMD=nmake /nologo /N /f %TEMP1% RT=%TEMP2%
@if /i "%TEMPDBG%x" EQU "RELEASEx" goto DOMTEST
@set TEMPCMD=nmake /nologo /N /f %TEMP1% DBG=YES RT=%TEMP2%
:DOMTEST
%TEMPCMD%
@if ERRORLEVEL 1 goto NOMAKE

@REM Check EACH of the release update makefiles ...
nmake /NOLOGO /N /F %TEMP1OR% RT=bin all
@if ERRORLEVEL 1 goto NOMAKEOSG
nmake /NOLOGO /N /F %TEMP1PR% RT=bin all
@if ERRORLEVEL 1 goto NOMAKEPR
@if "%TEMPDBG%x" == "RELEASEx" goto DNMKTST
nmake /NOLOGO /N /F %TEMP1OD% RT=bin all
@if ERRORLEVEL 1 goto NOMAKEOSG
nmake /NOLOGO /N /F %TEMP1PD% RT=bin all
@if ERRORLEVEL 1 goto NOMAKEPD
:DNMKTST
@goto DNNMAKETEST

:NOMAKEOSG
@echo Got an ERROR from %TEMP1OR% ... something is missing?
@goto NOMAKE

:NOMAKEOSG
@echo Got an ERROR from %TEMP1OD% ... something is missing?
@goto NOMAKE

:NOMAKEPR
@echo Got an ERROR from %TEMP1PR% ... something is missing?
@goto NOMAKE

:NOMAKEPD
@echo Got an ERROR from %TEMP1PD% ... something is missing?
@goto NOMAKE


:DNNMAKETEST

@echo.
@echo Check the above output appears to be doing what you want, and that
@echo is to COPY lots of OSG DLL to the 'bin' folder ...
@REM echo alut.dll to %SYSTEMROOT%\System32 to join OpenAL32.dll and wrap_oal.dll ...
@echo.
@echo It seems possible to continue ... Do you want to continue and COPY things?
@pause
@echo.
@echo *************************************************
@echo ARE YOU SURE? Last chance ... Ctrl+C to ABORT ...
@echo *************************************************
@pause
@echo.
@echo Copy the RUNTIME components to folder %TEMP2%
@if "%TEMPDBG%x" == "RELEASEx" goto DORELONLY

:DODEBUG
@set TEMPCMD=nmake /nologo /f %TEMP1% DBG=YES RT=%TEMP2%
@goto DOIT

:DORELONLY
@set TEMPCMD=nmake /nologo /f %TEMP1% RT=%TEMP2%
@goto DOIT

:DOIT
@echo Configuration selected: TEMPDBG=%TEMPDBG%
@echo Will run command [%TEMPCMD%] ... Ctrl+C to ABORT ...
@echo Any other key to continue ...
@pause
@if "%TEMPDBG%x" == "RELEASEx" goto COPYREL
nmake /nologo /f %TEMP1OD% all
nmake /nologo /f %TEMP1PD% all
:COPYREL
nmake /nologo /f %TEMP1OR% all
nmake /nologo /f %TEMP1PR% all
%TEMPCMD%
@goto DONE

:Err1
@echo CRITICAL ERROR: Can not locate [%TEMP1%] file ... check name, location ...
@goto END

:NORMAK
@echo CRITICAL ERROR: Can NOT locate %TEMPOR% or %TEMPPR% makefiles - check names, location ...
@goto END

:NODMAK
@echo CRITICAL ERROR: Can NOT locate %TEMPOD% or %TEMPPD% makefiles - check names, location ...
@goto END

:NODLL2
@echo --------------------------------------------------------------------------------
@echo NOTE: This component requires SPECIAL setup in CMake to ensure it is built!
@echo Carefully check, and re-configure CMake on the OpenSceneGraph folder, and
@echo run MSVC again when done. Hint: [x] Show Advanced Options MUST be checked!!!
@goto NODLL1

:NODLL1
@echo --------------------------------------------------------------------------------
@echo ERROR: Unable to locate [%TEMPTEST%] ...
@echo Check name, location, version ...
@echo --------------------------------------------------------------------------------
@goto FAILED

:FAILED
@echo ERROR: Failed to find an item, so can only abort ...
@echo --------------------------------------------------------------------------------
@echo This could a problem with the current settings of TEMPOSGV, TEMPPIV, or TEMPOTV ...
@echo Presently using OSG V=%TEMPOSGV%, Plug-in=%TEMPPIV%, OpenThreads=%TEMPOTV% ...
@echo Check and adjust in this UPD.BAT batch file ...
@echo ========================== directory listings ================================
@dir OpenSceneGraph\bin\osg??-osg.dll
@dir OpenSceneGraph\bin\osgPlugins-*
@dir OpenSceneGraph\bin\ot??-OpenThreads.dll
@echo ========================== end directory listings ================================
@echo Do the above directory listings match OSG V=%TEMPOSGV%, Plug-in=%TEMPPIV%, OpenThreads=%TEMPOTV% ???
@perl -version >nul
@if ERRORLEVEL 1 goto DNPERL
@if NOT EXIST chkosgver.pl goto DNPERL
@perl chkosgver.pl
:DNPERL
@echo CHECK AND ADJUST TEMPOSGV, TEMPPIV, and/or TEMPOTV in the UPD.BAT batch file ...
@echo If no directory listing shown, then more extensive changes are required to upd.bat!

@goto END

:NOMAKE
@echo --------------------------------------------------------------------------------
@echo ERROR: Encountered an error running 'nmake' ... where is nmake.exe ???
@echo Perhaps this is not the special MSVC command prompt, which first
@echo runs vcvars32.bat to establish some variables, and paths ...
@echo In MSVC, try Tools - Visual Studio 200? Command Prompt ?
@if "%DevEnvDir%." == "." goto NODEV1
@if "%VCINSTALLDIR%." == "." goto NODEV2
@goto DNDEV
:NODEV1
@echo --------------------------------------------------------------------------------
@echo This seems confirmed by the fact that DevEnvDir is missing ...
@goto DODEV
:NODEV2
@echo --------------------------------------------------------------------------------
@echo This seems confirmed by the fact that VCINSTALLDIR is missing ...
@goto DODEV
:DODEV
@echo Open the special MSVC command prompt, and try again ...
:DNDEV
@echo --------------------------------------------------------------------------------
@echo CRITICAL ERROR: Must have 'nmake' available to continue ...
@goto END

:NOSYSRT
@echo ERROR: For some reason SYSTEMROOT is NOT in the environment ...
@echo This will be a problem updating alut.dll, if required ...
@goto END

:DONE
@echo.
@echo Update appears all OK ... Congratualtions! You appear READY TO FLY ;=))
@if NOT EXIST bin\bats\. goto DOBATS
@echo Changing into bin\bats, ready for flying ...
@cd bin\bats
@goto CHKOAL

:DOBATS
@echo Time up unzip rfgbats??.zip,
@echo then change into bin\bats, and go flying ;=))

:CHKOAL
@if NOT EXIST %SYSTEMROOT%\System32\OpenAL32.dll goto WARNNOAL1
@if NOT EXIST %SYSTEMROOT%\System32\wrap_oal.dll goto WARNNOAL2

:DNOALCHK
@if EXIST %SYSTEMROOT%\System32\alut.dll goto DNALUTCHK
@echo Also copy alut.dll to %SYSTEMROOT%\System32 to join OpenAL32.dll and wrap_oal.dll, if not already done ...

:DNALUTCHK
@REM Anything else???
@goto END

:WARNNOAL1
@echo NOTE: Did NOT find %SYSTEMROOT%\System32\OpenAL32.dll ...
@if NOT EXIST %SYSTEMROOT%\System32\wrap_oal.dll goto WARNNOAL2
@echo HAS THE OPENAL SDK BEEN INSTALLED? And has oalinst.exe been run?
@goto DNOALCHK

:WARNNOAL2
@echo NOTE: Did NOT find %SYSTEMROOT%\System32\wrap_oal.dll ...
@echo HAS THE OPENAL SDK BEEN INSTALLED? And has oalinst.exe been run?
@goto DNOALCHK

:END
