#!/usr/bin/perl -w
# NAME: amscan.pl
# AIM: Given a single Makefile.am, try to SCAN all in the set
# 31/08/2010 - Review (with new/better understanding of the Makefile.am ;=))
# 11/11/2008 - geoff mclane - http://geoffair.net/mperl
# ####################################################
use strict;
use warnings;
use File::Basename;    # to split path into ($name, $dir) = fileparse($ff); or ($nm,$dir,$ext) = fileparse( $fil, qr/\.[^.]*/ );
use File::Spec; # File::Spec->rel2abs($rel); # we are IN the SLN directory, get ABSOLUTE from RELATIVE
my $perl_dir = 'C:\GTools\perl';
unshift(@INC, $perl_dir);
#require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
#require 'fgutils.pl' or die "Unable to load fgutils.pl ...\n";
require 'fgutils02.pl' or die "Unable to load 'fgutils02.pl' ...\n";
#require 'debug.pl' or die "Unable to load 'debug.pl'...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /(\\|\/)/) {
    my @tmpsp = split(/(\\|\/)/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = $perl_dir."\\temp.$pgmname.txt";
open_log($outfile);

my $in_file = '';

my $debug_on = 1;   # run with DEFAULT, if no other input...
my $def_file = 'C:\FGCVS\Jack\Makefile.am';
##my $def_file = 'C:\FG\PREOSG\FlightGear\source\Makefile.am';
##my $def_file = 'C:\FG\FGRUN\gettext\Makefile.am';

# features
my $ignore_EXTRA_DIST = 1;  # no SHOW of 'EXTRA_DIST' key
my $load_log = 0;
my $add_rel_sources = 1;

# CONSTANTS
my $IF_PATTERN = "^if[ \t]+\([A-Za-z][A-Za-z0-9_]*\)[ \t]*\(#.*\)?\$";
my $NIF_PATTERN = "^if[ \t]+!(.+)\$";
my $ELSE_PATTERN = "^else[ \t]*\(#.*\)?\$";
my $ENDIF_PATTERN = "^endif[ \t]*\(#.*\)?\$";
my $PATH_PATTERN='(\\w|/|\\.)+';
# This will pass through anything not of the prescribed form.
my $INCLUDE_PATTERN = "^include[ \t]+((\\\$\\\(top_srcdir\\\)/${PATH_PATTERN})|(\\\$\\\(srcdir\\\)/${PATH_PATTERN})|([^/\\\$]${PATH_PATTERN}))[ \t]*(#.*)?\$";

my %global_hash = (
    'top_srcdir' => "",
    'base_LIBS'  => "",
    'opengl_LIBS' => "",
    'network_LIBS' => "",
    'joystick_LIBS' => "",
    'top_builddir' => "",
    'thread_LIBS' => "",
    'pkgdatadir' => "",
    'openal_LIBS' => "",
    'datadir' => "",
    'srcdir' => "",
    'docdir' => "",
    'localedir' => "",
    'RELOCATABLE_LDFLAGS' => "",
    'LIBTOOL' => "lib",
    'libdir' => "",
    'SHELL' => "",
    'BISON_LOCALEDIR' => "",
    'AM_LIBTOOLFLAGS' => "",
    'bindir' => "",
    'AM_CFLAGS' => "",
    'OPENMP_CFLAGS' => "",
    'DESTDIR' => "",
    'gl_LIBOBJS' => "glu32.lib"
);

my %def_condits = (
    "USE_GLUT" => "TRUE",
    "ENABLE_JPEG_SERVER" => "FALSE",
    "ENABLE_SP_FDM" => "TRUE"
);

my $added_in_init = '';
my %common_subs = (
    'LIBTOOL' => 'link',
    'CC' => 'cl'
);    

my ($root_file, $root_folder);

# DEBUG
my $dbg_s01 = 0; # show prt( "[dbg_s01] $i2: $fline
my $dbg_s02 = 0; # show prt( "Listing $acnt keys in hash ...
my $dbg_s03 = 0; # show prt( "No LIBRARY keys ...
my $dbg_s04 = 0; # show prt( "LIBRARY [$ky] has SOURCES [$val]
my $dbg_s05 = 0; # show prt( "$am ". ((-f $am) ? "ok" : "no find!")
my $dbg_s06 = 0; # show prt( "Opened cond_stack with [".$cond_stack[$#cond_stack]."] $fil
my $dbg_s07 = 0; # add new line before 'Processing $cnt lines..., as does 08 also...
my $dbg_s08 = 0; # show prt( "Processing $cnt lines from $fil ...
my $dbg_s09 = 0; # show prt( "Got $cnt subdirectories [$slist] ...
my $dbg_s10 = 0; # show prtw("WARNING:1: No substitution for [$ms] found in hash ...
my $dbg_s11 = 0; # show target: gathering...
my $dbg_s12 = 0; # show setting key=value in hash, duing am file scan
my $dbg_s13 = 0; # show initial substitution, during am file scan
my $dbg_s14 = 0; # similar to about, but only show NO sub FOUND
my $dbg_s15 = 0; # List each source, for each project...

my @warnings = ();
my @subsnotfound = ();

my %programs = ();
my %libraries = ();
my %ams_done = ();
my %subs_not_found = ();    # list created if $dbg_s13 or $dbg_s14

# forward
sub process_one_am_file($);

#####################################################
######## SUBS ONLY ###########
#####################################################
# FOR DEBUG
my $dbg_base = 'dbg';

sub set_dbg_base($) { $dbg_base = shift; }

sub get_dbg_var($) {
    my $val = shift;
    my $var = $dbg_base;
    my $res = -1;
    if ($val < 10) {
        $var .= "0$val";
    } else {
        $var .= "$val";
    }
    # from : http://perldoc.perl.org/functions/eval.html
    if (eval "defined \$$var") {
        $res = eval "\$$var";
    }
    return $res;
}

sub get_dbg_stg() {
    my $s = '';
    my ($i,$res,$i2);
    for ($i = 1; ;$i++) {
        $res = get_dbg_var($i);
        last if ($res == -1);
        if ($i < 10) {
            $i2 = "0$i";
        } else {
            $i2 = "$i";
        }
        if ($res) {
            $s .= "$i2 ";
        }
    }
    return $s;
}

sub get_dbg_range() {
    my ($i,$res);
    for ($i = 1; ;$i++) {
        $res = get_dbg_var($i);
        last if ($res == -1);
    }
    return $i - 1;
}

sub set_dbg_var($) {
    my $val = shift;
    my $var = $dbg_base;
    if ($val < 10) {
        $var .= "0$val";
    } else {
        $var .= "$val";
    }
    # from : http://perldoc.perl.org/functions/eval.html
    # NOT $$var++; # does not work!
    if (eval "defined \$$var") {
        eval "\$$var++";
    } else {
        #print "ERROR: \$$var does NOT exist\n";
        return 0;
    }
    return 1;
}

sub clear_dbg_var($) {
    my $val = shift;
    my $var = $dbg_base;
    if ($val < 10) {
        $var .= "0$val";
    } else {
        $var .= "$val";
    }
    # from : http://perldoc.perl.org/functions/eval.html
    # NOT $$var++; # does not work!
    if (eval "defined \$$var") {
        eval "\$$var = 0";
    } else {
        #print "ERROR: \$$var does NOT exist\n";
        return 0;
    }
    return 1;
}

sub set_all_dbg_on() {
    my ($i,$res);
    for ($i = 1; ;$i++) {
        $res = set_dbg_var($i);
        last if (!$res);
    }
}

sub set_all_dbg_off() {
    my ($i,$res);
    for ($i = 1; ;$i++) {
        $res = clear_dbg_var($i);
        last if (!$res);
    }
}

######################################################
sub set_debug_all() {
    my $cnt = get_dbg_range();
    prt("Setting DEBUG 01 to $cnt ON\n");
    set_all_dbg_on();
}
sub set_debug_none() {
    my $cnt = get_dbg_range();
    prt("Setting DEBUG 01 to $cnt OFF\n");
    set_all_dbg_off();
}
######################################################
### INIT ###

sub get_root_dir() { return $root_folder; }

sub add_key_2_added($) {
    my $key = shift;
    $added_in_init .= " " if (length($added_in_init));
    $added_in_init .= $key;
}

sub init_common_subs($) {
    my ($inf) = shift;
    ($root_file, $root_folder) = fileparse($inf);
    $root_folder = path_u2d($root_folder);
    my ($key,$rd);
    $rd = get_root_dir();
    $key = 'top_builddir';
    if (!defined $common_subs{$key}) {
        $common_subs{$key} = $rd;
    }
    $key = 'top_srcdir';
    if (!defined $common_subs{$key}) {
        $common_subs{$key} = $rd;
    }
    # these are perhaps NOT required, BUT let's try...
    $key = 'bindir';
    if (!defined $common_subs{$key}) {
        $common_subs{$key} = $rd;
        add_key_2_added($key);
    }
    $key = 'distdir';
    if (!defined $common_subs{$key}) {
        $common_subs{$key} = $rd;
        add_key_2_added($key);
    }
    $key = 'includedir';
    if (!defined $common_subs{$key}) {
        $common_subs{$key} = $rd;
        add_key_2_added($key);
    }
    $key = 'libdir';
    if (!defined $common_subs{$key}) {
        $common_subs{$key} = $rd;
        add_key_2_added($key);
    }
    $key = 'mkinstalldirs';
    if (!defined $common_subs{$key}) {
        $common_subs{$key} = $rd;
        add_key_2_added($key);
    }
    $key = 'srcdir';
    if (!defined $common_subs{$key}) {
        $common_subs{$key} = $rd;
        add_key_2_added($key);
    }
}


sub prtw($) {
    my ($tx) = shift;
    $tx =~ s/\n$// if ($tx =~ /\n$/);
    prt("$tx\n");
    push(@warnings,$tx);
}

sub show_warnings($) {
    my $val = shift;
    if (@warnings) {
        prt( "\nGot ".scalar @warnings." WARNINGS ...\n" );
        foreach my $line (@warnings) {
            prt("$line\n" );
        }
        prt("\n");
    } elsif ($val) {
        prt("\nNo warnings issued.\n\n");
    }
}

sub show_missing_subs() {
    if ($dbg_s13 || $dbg_s14) {
        my @arr = keys %subs_not_found;
        my ($cnt);
        if (@arr) {
            $cnt = scalar @arr;
            prt("[dbg_s13|14] There are at least $cnt missing substitutions.\n");
            my ($key,$fil);
            foreach $key (sort @arr) {
                $fil = $subs_not_found{$key};
                prt("Missing [$key], in [$fil]\n");
            }
        } else {
            prt("[dbg_s13|14] There are NO missing substitutions.\n");
        }
        @arr = split $added_in_init;
        $cnt = scalar @arr;
        prt("But note added $cnt, [$added_in_init] in init...\n") if (length($added_in_init));
    }
}

sub pgm_exit($$) {
    my ($val,$msg) = @_;

    show_warnings($val);

    show_missing_subs() if ($val == 0);

    if (length($msg)) {
        $msg .= "\n" if (!($msg =~ /\n$/));
        prt($msg);
    }
    
    close_log($outfile,$load_log);
    exit($val);
}



sub sub_common_folder {
    my ($fil,$root) = @_;
    my $lfil = lc(path_u2d($fil));
    my $lrot = lc(path_u2d($root));
    my $len1 = length($lfil);
    my $len2 = length($lrot);
    my ($i);
    for ($i = 0; (($i < $len1)&&($i < $len2)); $i++) {
        if (substr($lfil,$i,1) ne substr($lrot,$i,1)) {
            last;
        }
    }
    return substr($fil,$i);
}

sub sub_root_folder {
    my ($fil) = shift;
    my $rd = get_root_dir();
    return sub_common_folder($fil,$rd);
}

sub get_value_from_hash {
    my ( $rval2, $ms, $rhash ) = @_;
    my ($ky2, @vals, $fnd, $val, @keys, $i);
    my ($itm, $cond);
    $fnd = 0;
    foreach $ky2 (keys %{$rhash}) {
        if ($ky2 =~ /^$ms\s+/) {
            $val = $$rhash{$ky2};
            if (!is_in_array($val, @vals)) {
                push(@vals,$val);
                push(@keys,$ky2);
                $fnd++;
            }
        }
    }
    if ($fnd == 1) {
        $$rval2 = $vals[0]; # just ONE to RETURN
    } elsif ($fnd > 1) {
        my $msg = "WARNING: For sub of [$ms], have [$fnd] to CHOOSE FROM!\n";
        for ($i = 0; $i < $fnd; $i++) {
            $val = $vals[$i];
            $ky2 = $keys[$i];
            $msg .= " or \n" if ($i > 0);
            $msg .= "[$ky2={".$val.'}]';
            if ($ky2 =~ /^$ms\s+if\s+(\w+)\@_(TRUE|FALSE)\@/) {
                $itm = $1;
                $cond = $2;
                $msg .= " [$itm]=[$cond]";
                if (defined $def_condits{$itm}) {
                    if ($def_condits{$itm} eq $cond) {
                        $$rval2 = $val; # RETURN selected
                        ### prtw("CHECK: Returning [$val] for [$ms], due [$itm]=[$cond] in def_condits!\n" );
                        return $fnd;
                    }
                }
            }
        }
        $msg .= " Defaulting to FIRST! CHECK ME!!";
        prtw("$msg\n");
        $$rval2 = $vals[0]; # just RETURN first
    }
    return $fnd;
}

sub begins_with {
    my ($rt, $pt) = @_;
    my $ln = length($rt);
    if (length($pt) >= $ln) {
        for (my $i = 0; $i < $ln; $i++) {
            if (substr($rt,$i,1) ne substr($pt,$i,1)) {
                return 0;
            }
        }
        return 1;
    }
    return 0;
}


# VARIOUS FIXES FOR THE FILE NAME
# 1. ensure ALL DOS format
# 2. remove any simple dot relative, like '.\' from beginning
# 3. if given a FULL PATH name, remove C:\FG\20\FlightGear
# 4. if a relative name, remove FligthGear
# 5. if any removal, ensure any beginning '\' is removed
sub sub_root_dir($) {
    my ($ff) = shift;   # = $a_dir.$src
    $ff = path_u2d($ff);
    my $rd = get_root_dir();
    if (begins_with($rd, $ff)) {
        $ff = substr($ff, length($rd));
    }
    return $ff;
}

# extract info from one am file scan,
# and try to do any substitutions, twice, but these should have been done already,

sub extract_from_hash {
    my ($fil, $rhash) = @_;
    my ($a_nm, $a_dir) = fileparse($fil);
    my ($key, $val, @av);
    my (@skeys, @progs, @progkeys, @libs, @libkeys, @srcs, @srckeys);
    my ($ky, $vky, $ms, $val2, $ky2, $orgval, $fnd, $acnt);
    my ($src, $ff, $scnt, $i, $min, $len);
    my %extract = ();
    # really interested in 
    # noinst_LIBRARIES = libAirports.a
    # noinst_PROGRAMS = calc_loc
    # bin_PROGRAMS = fgfs something
    # libAirports_a_SOURCES = apt_loader.cxx apt_loader.hxx ...
    @skeys = sort keys(%{$rhash});
    $acnt = scalar @skeys;
    prt( "extract_from_hash: Listing $acnt keys in hash passed...\n" ) if ($dbg_s02);
    # collect PROGRAM keys
    @progs = ();
    @progkeys = ();
    @libs = ();
    @libkeys = ();
    @srcs = ();
    @srckeys = ();

    # try to do substitutions
    $min = 0;
    foreach $key (@skeys) {
        $val = $$rhash{$key};
        $orgval = $val;
        if ($val =~ /\$\((\w+)\)/) {
            $ms = $1;
            $val2 = ''; # no sub yet
            $fnd = 0;   # none found
            if (defined $global_hash{$ms}) {
                $val2 = $global_hash{$ms};  # found in global
                $fnd = 1;
            } elsif (defined $$rhash{$ms}) {
                $val2 = $$rhash{$ms}; # found in local
                $fnd = 2;
            } else {
                # hmmm, maybe like 'GFX_CODE if @USE_GLUT_FALSE@ = fg_os_osgviewer.cxx $(GFX_COMMON)'
                $fnd = get_value_from_hash(\$val2, $ms, $rhash ); 
            }
            if ($fnd > 0) {
                $val =~ s/\$\($ms\)/$val2/g;
            } else {
                if ( ! is_in_array($ms,@subsnotfound) ) {
                    prtw("WARNING:1: No substitution for [$ms] found in hash ...\n" ) if ($dbg_s10);
                    push(@subsnotfound,$ms);
                }
            }
        }

        if ($val ne $orgval) {
            $$rhash{$key} = $val;
        }
        $len = length($key);
        $min = $len if ($len > $min);
    }

    # try to do substitutions, twice
    foreach $key (@skeys) {
        $val = $$rhash{$key};
        $orgval = $val;
        if ($val =~ /\$\((\w+)\)/) {
            $ms = $1;
            $val2 = '';
            $fnd = 0;
            if (defined $global_hash{$ms}) {
                $val2 = $global_hash{$ms};
                $fnd = 1;
            } elsif (defined $$rhash{$ms}) {
                $val2 = $$rhash{$ms};
                $fnd = 2;
            } else {
                # hmmm, maybe like 'GFX_CODE if @USE_GLUT_FALSE@ = fg_os_osgviewer.cxx $(GFX_COMMON)'
                foreach $ky2 (keys %{$rhash}) {
                    if ($ky2 =~ /^$ms/) {
                        $val2 = $$rhash{$ky2};
                        $fnd = 3;
                        last;
                    }
                }
            }
            if ($fnd > 0) {
                $val =~ s/\$\($ms\)/$val2/g;
            } else {
                if ( ! is_in_array($ms,@subsnotfound) ) {
                    prtw("WARNING:2: No substitution for [$ms] found in hash ...\n" ) if ($dbg_s10);
                    push(@subsnotfound,$ms);
                }
            }
        }
        if ($val ne $orgval) {
            $$rhash{$key} = $val;
        }
    }

    foreach $key (@skeys) {
        $val = $$rhash{$key};
        if ($key =~ /_PROGRAMS/) {
            push(@progkeys,$key);
            push(@progs,$val);
        } elsif ($key =~ /_LIBRARIES/) {
            push(@libkeys,$key);
            push(@libs,$val);
        } elsif ($key =~ /_SOURCES/) {
            push(@srckeys,$key);
            ###push(@srcs,$val);
        }
    }

    prt("\nList of items in the HASH from [$fil]...\n") if ($dbg_s02);
    foreach $key (@skeys) {
        $val = $$rhash{$key};
        next if (($key eq 'EXTRA_DIST')&&($ignore_EXTRA_DIST));
        $key .= ' ' while (length($key) < $min);
        prt( "$key = $val\n" ) if ($dbg_s02);
    }

    if (@libkeys) {
        foreach $key (@libkeys) {
            $val = $$rhash{$key};
            @av = split(/\s/,$val);
            foreach $ky (@av) {
                $ky =~ s/-/_/g;
                $ky =~ s/\./_/g;
                $vky = $ky.'_SOURCES';
                if (defined $$rhash{$vky}) {
                    $val = $$rhash{$vky};
                    @srcs = split(/\s/, $val);
                    $scnt = scalar @srcs;
                    for ($i = 0; $i < $scnt; $i++) {
                        $src = $srcs[$i];
                        if ($add_rel_sources) {
                            $ff = sub_root_dir($a_dir.$src);
                            $srcs[$i] = $ff;
                        }
                    }
                    $val = join(' ',@srcs);
                    if (defined $libraries{$ky}) {
                        prtw( "WARNING: libraries[$ky] has value [".$libraries{$ky}."] ADDING $val!\n" );
                        $libraries{$ky} .= ' @AND@ '.$val;
                    } else {
                        $libraries{$ky} = $val;
                    }
                    prt( "LIBRARY [$ky] has SOURCES [$val]\n" ) if ($dbg_s04);
                } else {
                    prtw( "WARNING: No sources for LIBRARY [$ky]\n" );
                }
            }
        }
    } else {
        prt( "No LIBRARY keys ...\n" ) if ($dbg_s03);
    }

    if (@progkeys) {
        foreach $key (@progkeys) {
            $val = $$rhash{$key};
            @av = split(/\s/,$val);
            foreach $ky (@av) {
                $ky =~ s/-/_/g;
                $ky =~ s/\./_/g;
                $vky = $ky.'_SOURCES';
                if (defined $$rhash{$vky}) {
                    $val = $$rhash{$vky};
                    @srcs = split(/\s/, $val);
                    $scnt = scalar @srcs;
                    for ($i = 0; $i < $scnt; $i++) {
                        $src = $srcs[$i];
                        if ($add_rel_sources) {
                            $ff = sub_root_dir($a_dir.$src);
                            $srcs[$i] = $ff;
                        }
                    }
                    $val = join(' ',@srcs);
                    if (defined $programs{$ky}) {
                        prtw( "WARNING: programs[$ky] has value [".$programs{$ky}."] ADDING $val!\n" );
                        $programs{$ky} .= ' @AND@ '.$val;
                    } else {
                        $programs{$ky} = $val;
                    }
                    prt( "PROGRAM [$ky] has SOURCES [$val]\n" ) if ($dbg_s04);
                } else {
                    prtw( "WARNING: No sources for PROGRAM [$ky]\n" );
                }
            }
        }
    } else {
        prt( "No PROGRAM keys ...\n" ) if ($dbg_s03);
    }
    $extract{'PROGRAMS'}  = { %programs };
    $extract{'LIBRARIES'} = { %libraries };
    prt( "extract_from_hash: Done $acnt from [".sub_root_folder($fil)."]...\n" ) if ($dbg_s02);

    return %extract;
}

sub am_macro_split($) {
    my ($txt) = @_;
    my @arr = ();
    my $len = length($txt);
    my ($i,$tag,$ch,,$nc,$mac,$k);
    $tag = '';
    for ($i = 0; $i < $len; $i++) {
        $ch = substr($txt,$i,1);
        if ($ch eq '$') {
            $k = $i + 1;
            if ((($k+3) < $len)&&(substr($txt,$k,1) eq '(')) {
                $k++;
                $mac = '$(';
                for (; $k < $len; $k++) {
                    $nc = substr($txt,$k,1);
                    $mac .= $nc;
                    last if ($nc eq ')');
                    last if !($nc =~ /\w/);
                }
                if ($nc eq ')') {
                    push(@arr,$tag) if (length($tag));
                    $tag = '';
                    push(@arr,$mac);
                    $ch = '';
                    $i = $k;
                }
            }
        }
        if (($ch eq "'") || ($ch eq '"')) {
            push(@arr,$tag) if (length($tag));
            $tag = '';
            push(@arr,$ch);
        } else {
            $tag .= $ch;
        }
    }
    return @arr;
}

sub test_for_substitution($$$$) {
    my ($line,$rhash,$i2,$sfil) = @_;
    if ($line =~ /\$/) {
        my $oline = $line; # keep copy of original
        my @arr = am_macro_split($line);
        my ($itm,$key,$nval,$tmp,$done,$cnt);
        $cnt = 0;
        foreach $itm (@arr) {
            if ($itm =~ /^\$\((\w+)\)$/) {
                $key = $1;
                $done = 0;
                if (defined ${$rhash}{$key}) {
                    $nval = ${$rhash}{$key};
                    $line =~ s/\$\($key\)/$nval/;
                    prt("[dbg_s13] $i2:1:$key: Did sub of [$key] to [$nval]\n") if ($dbg_s13);
                    $done = 1;
                    $cnt++;
                } else {
                    foreach $tmp (keys %{$rhash}) {
                        if ($tmp =~ /^$key\s+.+\@_TRUE\@/) {
                            $nval = ${$rhash}{$tmp};
                            $line =~ s/\$\($key\)/$nval/;
                            prt("[dbg_s13] $i2:2: Did sub to [$nval] key [$key] tmp = [$tmp]\n") if ($dbg_s13);
                            $done = 1;
                            $cnt++;
                            last;
                        }
                    }
                }
                if (!$done) {
                    # try in the common, which can be user expanded
                    if (defined $common_subs{$key}) {
                        $nval = $common_subs{$key};
                        $line =~ s/\$\($key\)/$nval/;
                        prt("[dbg_s13] $i2:3: Did sub to [$nval] key [$key] common subs\n") if ($dbg_s13);
                        $done = 1;
                        $cnt++;
                    }
                }

                if (!$done && ($dbg_s13 || $dbg_s14)) {
                    $subs_not_found{$key} = $sfil;
                    prt("[dbg_s13|14] $i2:2: NO sub FOUND for [$itm] key [$key]  file [$sfil]\n")
                }
            }
        }
        if ($line ne $oline) {
            prt("[dbg_s13] $i2: Line SUB [$oline] TO [$line]\n") if ($dbg_s13);
        } elsif ($cnt) {
            pgm_exit(1,"$i2:$cnt: SUBSTITUTIONS FAILED! line [$line] file [$sfil]\n");
        }
    }
    return $line;
}

sub add_key_value_2_hash($$$$$$) {
    my ($key,$val,$rhash,$i2,$sfil,$lev) = @_;
    my ($tmp);
    if (defined ${$rhash}{$key}) {
        my $cval = ${$rhash}{$key};
        prtw( "WARNING: $i2: hash [$key] exists with [$cval]! Adding [$val]! $lev! file=$sfil\n" ) if ($lev == 1);
        ${$rhash}{$key} .= '|'.$val;
        $tmp = 'Added to';
    } else {
        prtw( "WARNING: $i2: hash [$key] DOES NOT EXIST! $lev! file=$sfil\n" ) if ($lev == 2);
        ${$rhash}{$key} = $val;
        $tmp = 'Setting '
    }
    prt("[dbg_s12] $i2: $tmp key [$key], with value [$val] lev $lev\n") if ($dbg_s12);
}

#sub show_line_split($$$$$) {
#    my ($line,$key,$val,$rav,$i2) = @_;
#    prt("$i2: l = [$line] k [$key] v [$val] split [");
#    foreach my $itm (@{$rav}) {
#        prt("$itm ");
#    }
#    prt("]\n");
#}

sub process_AM_file {
    my ($fil) = shift;
    my ($a_nm, $a_dir) = fileparse($fil);
    my $sfil = sub_root_folder($fil);
    my %hash = ();
    my %targets = ();
    my ($ff);
    my $dooldext = 0;
    if (!open INF, "<$fil") {
        prtw( "WARNING: Unable to open $fil ... $! ...\n" );
        return %hash;
    }
    my @lns = <INF>;
    close INF;
    my $cnt = scalar @lns;
    prt("\n") if ($dbg_s07 && $dbg_s08);
    prt( "Processing $cnt lines from $fil ...\n" ) if ($dbg_s08);
    my ($i,$line,$fline,$i2,@av,$key,$val,$j,$acnt,$ifcond);
    my ($ind,$len,$tmp);
    my @cond_stack = ();
    my $in_target = 0;
    my $target = '';
    $fline = '';
    for ($i = 0; $i < $cnt; $i++) {
        $line = $lns[$i];
        $i2 = $i + 1;
        chomp $line;
        $line = trim_all($line);
        next if ($line =~ /^#/);
        $fline .= $line;
        #$len = length($fline);
        #if ($len == 0) {
        #    $in_target = 0;
        #    next;
        #}
        # join continuation lines into one
        if ($fline =~ /\\$/) {
            $fline =~ s/\\$/ /;
            next;
        }
        # deal with the FULL line
        $fline = trim_all($fline);
        $len = length($fline);
        if ($len == 0) {
            $in_target = 0;
            next;
        }
        $fline = test_for_substitution($fline,\%hash,$i2,$sfil);
        if ($fline =~ /$IF_PATTERN/o) {
            # open an IF
            $ifcond = $1;
            push(@cond_stack, $ifcond . "\@_TRUE\@");
            prt( "Opened cond_stack with [".$cond_stack[$#cond_stack]."] $sfil\n" ) if ($dbg_s06);
            #$in_target = 0;
        } elsif ($fline =~ /$NIF_PATTERN/o) {
            # open an IF !(SOMETHING)
            $ifcond = $1;
            push(@cond_stack, $ifcond . "\@_FALSE\@");
            prt( "Opened cond_stack with [".$cond_stack[$#cond_stack]."] $sfil\n" ) if ($dbg_s06);
            #$in_target = 0;
        } elsif ($fline =~ /$ELSE_PATTERN/o) {
            # switch to else
            if (! @cond_stack) {
                prtw( "ERROR: else without if! ($sfil:$i2)\n" );
            } elsif ($cond_stack[$#cond_stack] =~ /\@_FALSE\@$/) {
                prtw( "ERROR: else after an else! ($sfil:$i2)\n" );
            } else {
                if ($cond_stack[$#cond_stack] =~ /\@_TRUE\@$/) {
                    $cond_stack[$#cond_stack] =~ s/\@_TRUE\@$/\@_FALSE\@/;
                } else {
                    $cond_stack[$#cond_stack] =~ s/\@_FALSE\@$/\@_TRUE\@/;
                }
                prt( "Else switched cond_stack to [".$cond_stack[$#cond_stack]."] $sfil\n" ) if ($dbg_s06);
            }
            $in_target = 0;
        } elsif ($fline =~ /$ENDIF_PATTERN/o) {
            # reached endif
            if (! @cond_stack) {
                prtw( "ERROR: endif without if! ($sfil:$i2)\n" );
            } else {
                $ifcond = pop (@cond_stack);
                prt( "Closed cond_stack with [$ifcond] $sfil\n" ) if ($dbg_s06);
            }
            #$in_target = 0;
        } elsif ($fline =~ /$INCLUDE_PATTERN/o) {
            $key = $1;
            $ff = $a_dir.$key;
            my $sff = sub_root_folder($ff);
            if (-f $ff) {
                my %h = process_AM_file($ff);
                prt( "ADVICE: Merging include [$sfil] HASH from [$sff]...\n" );
                foreach my $k (keys %h) {
                    my $v = $h{$k};
                    if (defined $hash{$k}) {
                        $hash{$k} .= ' '.$v;
                    } else {
                        $hash{$k} = $val;
                    }
                }
            } else {
                prtw( "ERROR: Unhandled INCLUDE [$key], ($sfil:$i2) [$sff] NOT FOUND\n" );
            }

        } elsif ($fline =~ /^(\w+)\s*=\s*(.*)$/) {
            #$key = $1;
            @av = split('=',$fline);
            $key = trim_all($av[0]);
            $acnt = scalar @av;
            $val = '';  # start with NO VALUE
            # if can be just 'JPEG_SERVER ='
            for ($j = 1; $j < $acnt; $j++) {
                if ($j == 1) {
                    $val = trim_all($av[$j]);
                } else {
                    $val .= '='.trim_all($av[$j]);
                }
            }
            #show_line_split($fline,$key,$val,\@av,$i2);
            if (@cond_stack) {
                $ifcond = $cond_stack[$#cond_stack];
                $key .= ' if '.$ifcond;
            }
            if (length($key) == 0) {
                pgm_exit(1,"ERROR: Split of line [$fline] DID NOT YIELD key! Losing value [$val]\n");
            } else {
                add_key_value_2_hash($key,$val,\%hash,$i2,$sfil,1); # should NOT exist
            }
        } elsif ($fline =~ /^(\w+)\s*\+=\s*(.+)$/) {
            $key = $1;
            $val = $2;
            if (@cond_stack) {
                $ifcond = $cond_stack[$#cond_stack];
                $key .= ' if '.$ifcond;
            }
            add_key_value_2_hash($key,$val,\%hash,$i2,$sfil,2); # plus, so key SHOULD exist
        } elsif ($fline =~ /^([\.\w-]+)\s*:/) {
            $target = $1;
            $in_target = 1;
            $val = '';
            $ind = index($fline,':');
            if (($ind > 0) && (($ind+1) < $len)) {
                $val = trim_all(substr($fline,($ind+1)));
            }
            if (@cond_stack) {
                $ifcond = $cond_stack[$#cond_stack];
                $target .= ' if '.$ifcond;
            }
            if (defined $targets{$target}) {
                ##prtw( "WARNING: targets[$target] exists with [".$targets{$target}."]! Adding [$val]!! file=$sfil\n" );
                $targets{$target} .= ' '.$val;
                $tmp = 'Added to';
            } else {
                $targets{$target} = $val;
                ##prtw( "WARNING: targets[$target] DOES NOT exist! Adding [$val]!! file=$sfil\n" );
                $tmp = 'Started';
            }
            prt("[dbg_s11] $i2: $tmp target [$target], with value [$val]\n") if ($dbg_s11);
        } else {
            if ($in_target && length($target)) {
                if (defined $targets{$target}) {
                    $targets{$target} .= "\n".$fline;
                } else {
                    $targets{$target} = $fline;
                    ##prtw( "WARNING: targets[$target] DOES NOT exist! Adding [$val]!! file=$sfil\n" );
                }
                prt("[dbg_s11] $i2: Added to target [$target] value [$fline]\n") if ($dbg_s11);
            } else {
                prt( "[dbg_s01] $i2: [$fline] SKIPPED file=[$fil]\n" ) if ($dbg_s01);
            }
        }
        $fline = '';    # kill this processed line
        $key = '';
        $val = '';
    }

    # done all the LINES, now play with the HASH collected
    $acnt = scalar keys(%hash);
    if ($acnt) {
        extract_from_hash( $fil, \%hash );
    } else {
        prtw( "WARNING: NO KEYS IN HASH! [$sfil]\n" );
    }

    # WARN if conditional stack NOT closed
    prtw( "WARNING: Items still in cond_stack! [".join(' ',@cond_stack)."]\n" ) if (@cond_stack);
    return %hash;
}

sub process_one_am_file($) {
    my ($fil) = shift;
    my $sfil = sub_root_folder($fil);
    return if (defined $ams_done{$fil});
    $ams_done{$fil} = 1;
    my %h = process_AM_file($fil);
    if (defined $h{'SUBDIRS'}) {
        my $slist = $h{'SUBDIRS'};
        my @ar = split(/\s/,$slist);
        my $cnt = scalar @ar;
        my ($p_tit,$p_dir,$p_ext) = fileparse( $fil, qr/\.[^.]*/ );
        prt( "Got $cnt subdirectories [$slist] ...from [$sfil]\n" ) if ($dbg_s09);
        foreach my $dir (@ar) {
            my $am = $p_dir.$dir.'\Makefile.am';
            $am = path_u2d($am);
            $am =~ s/\\\\/\\/g while ($am =~ /\\\\/);
            my $sam = sub_root_folder($am);
            if (-f $am) {
                prt( "Processing AM file [$sam], from [$sfil] ...\n" ) if ($dbg_s05);
            } else {
                prtw( "WARNING: AM [$sam] NOT FOUND in [$dir], from [$sfil]!\n" ) if ($dbg_s05);
            }
            process_one_am_file($am);
        }
    }
}


sub list_to_arrays {
    my %srchash = ();
    my @msvc_c_files = ();
    my @msvc_h_files = ();
    prt("\n");
    prt( "AM files yielded programs ... " );
    prt("\n");

    my ($key, $val, @av, $fil);
    my ($src, $tit, $dir, $ext, $cnt);
    my @done = ();
    my $sgrp = get_def_src_grp();    # "Source Files";
    my $sflt = get_def_src_filt();
    my $hgrp = get_def_hdr_grp();    # "Header Files";
    my $hflt = get_def_hdr_filt();
    foreach $key (sort keys %programs) {
        # next if ($show_fg_only && !($key eq $pgm_fg));
        $val = $programs{$key};
        @av = split(/\s/,$val);
        $cnt = scalar @av;
        prt( "PROGRAM [$key] $cnt SOURCES\n" );
        foreach $fil (@av) {
            prt( "$fil\n" ) if ($dbg_s15);
            ###($tit,$dir,$ext) = 	fileparse( $fil, qr/\.[^.]*/ );
            ($tit,$dir) = 	fileparse($fil);
            ###$src = ($grp.'|'.$fil.'|'.$tit);
            if ( is_c_source_extended($fil) ) {
                if ( is_in_array($tit,@done) ) {
                    prtw("Duplicate of FILE NAME $tit ($fil)!!!\n" );
                } else {
                    push(@done,$tit);
                }
                #push(@msvc_c_files, $src);
                push(@msvc_c_files, [$fil, $sgrp, $sflt]);
            } else {
                #push(@msvc_h_files, $src);
                push(@msvc_h_files, [$fil, $hgrp, $hflt]);
            }
        }
    }
    prt("\n") if ($dbg_s15);
    prt( "And following library SOURCES ...\n" );
    foreach $key (sort keys %libraries) {
        $val = $libraries{$key};
        @av = split(/\s/,$val);
        $cnt = scalar @av;
        prt( "LIBRARY [$key] $cnt SOURCES\n" ); # if (!$show_fg_only);
        foreach $fil (@av) {
            prt( "$fil\n" ) if ($dbg_s15);
            ($tit,$dir,$ext) = 	fileparse( $fil, qr/\.[^.]*/ );
            ###$src = ($grp.'|'.$fil.'|'.$tit);
            if (is_c_source($fil)) {
                if (is_in_array($tit,@done)) {
                    prtw("Duplicate of FILE TITLE $tit ($fil)!!!\n" );
                } else {
                    push(@done,$tit);
                }
                ###push(@msvc_c_files, $src);
                push(@msvc_c_files, [$fil, $sgrp, $sflt]);
            } else {
                ###push(@msvc_h_files, $src);
                push(@msvc_h_files, [$fil, $hgrp, $hflt]);
            }
        }
    }

    $key = scalar @msvc_c_files;
    $val = scalar @msvc_h_files;
    prt( "Set of $key C SOURCE files, and $val headers (and others) ...\n" );
    $srchash{'C_SOURCES'} = [ @msvc_c_files ];
    $srchash{'H_SOURCES'} = [ @msvc_h_files ];
    return %srchash;
}

sub process_primary($) {
    my ($fil) = shift;
    my ($key);
    my %eh = process_one_am_file($fil);  # iteratively process the Makefile.am files
    list_to_arrays();
    ##write_temp_dsp($dsp_outfile);
}


#############################################################
##### MAIN #####
set_dbg_base("dbg_s");

set_debug_none();
#set_debug_all();

parse_args(@ARGV);

init_common_subs( $in_file );

process_primary( $in_file );

pgm_exit(0,"");

##############################################################

sub give_help {
    my ($tmp);
    prt("$pgmname: version 0.0.1 2010-08-31\n");
    prt("Usage: $pgmname [options] in-file\n");
    prt("Options:\n");
    prt(" --help   (-h or -?) = This help, and exit 0.\n");
    $tmp = get_dbg_range();
    prt(" --dbg <num>    (-d) = Set DEBUG flag of this value. Number in range 1 to $tmp\n");
    prt(" --load-log     (-l) = Load LOG file at end.\n");
    prt(" --mac item val (-m) = Store a MACRO, item=value, for substitution. (use '-d 14' to list missing).\n");
    prt(" --resp <file>  (-r) = Commands from a reponse/input file.\n");
    prt("Purpose:\n");
    prt("Read the file given as a Makefile.am autotools project description file, and\n");
    prt("show its contents. If it contains any SUBDIRS = macro, then check each sub-directory\n");
    prt("for a Makefile.am file, and if found, process it also.\n");
    prt("NOTES:\n");
    prt(" The debug switch is strictly for that. It adds no functionality, just a noisier output,\n");
    prt("  and has the text settings of 'all', 'none', or 'help', to show the list in more detail.\n");
    $tmp = get_dbg_stg();
    prt(" For debug, presently values [$tmp] are ON\n") if (length($tmp));
}

sub need_arg {
    my ($arg,@av) = @_;
    pgm_exit(1,"ERROR: [$arg] must have following argument!\n") if (!@av);
}

sub show_dbg_help() {
    my $file = $0;
    my ($line,$max,$tmp,$cnt);
    $max = get_dbg_range();
    $tmp = get_dbg_stg();
    prt(" --dbg <num>  (-d)  = Set DEBUG flag of this value. Number in range 1 to $tmp\n");
    prt(" Presently %tmp are ON.\n") if (length($tmp));
    prt(" Additional text setting are 'all', 'none', and this 'help'.\n");
    if (open INF, "<$file") {
        my @lines = <INF>;
        close INF;
        prt(" Detailed list, with some 'notes' indicating what each does.\n");
        $cnt = 0;
        foreach $line (@lines) {
            $line = trim_all($line);
            if ($line =~ /^my\s+\$dbg_s(\d+)\s*=\s*\d+\s*;\s*(.+)$/) {
                $tmp = $1;
                prt("$tmp: $line\n");
                $cnt++;
            }
        }
        prt("ERROR: Found no \$dbg?? vars in file [$file], so NO DEBUG ADDITIONAL HELP!\n") if (!$cnt);
    } else {
        prt("ERROR: Unable to open file [$file], so NO DEBUG ADDITIONAL HELP!\n");
    }
}

sub load_input_file($$) {
    my ($arg,$file) = @_;
    if (open INF, "<$file") {
        my @lines = <INF>;
        close INF;
        my @carr = ();
        my ($line,@arr);
        foreach $line (@lines) {
            $line = trim_all($line);
            next if (length($line) == 0);
            next if ($line =~ /^#/);
            @arr = split(/\s/,$line);
            push(@carr,@arr);
        }
        parse_args(@carr);
    } else {
        pgm_exit(1,"ERROR: Unable to 'open' file [$file]!\n")
    }
}

sub parse_args {
    my (@av) = @_;
    my ($arg,$sarg,$tmp);
    while (@av) {
        $arg = $av[0];
        if ($arg =~ /^-/) {
            $sarg = substr($arg,1);
            $sarg = substr($sarg,1) while ($sarg =~ /^-/);
            if (($sarg =~ /^h/i)||($sarg eq '?')) {
                give_help();
                pgm_exit(0,"Help exit(0)");
            } elsif ($sarg =~ /^l/i) {
                $load_log = 1;
                prt("Set to load log at end.\n");
            } elsif ($sarg =~ /^d/i) {
                need_arg(@av);
                shift @av;
                $sarg = $av[0];
                $tmp = get_dbg_range();
                if (($sarg =~ /^\d+$/)&&($sarg >= 1)&&($sarg <= $tmp)) {
                    $tmp = 'dbg';
                    if ($sarg < 10) {
                        $tmp .= "0$sarg";
                    } else {
                        $tmp .= "$sarg";
                    }
                    set_dbg_var($sarg);
                    prt("Set Debug $tmp ON!\n");
                } else {
                    if ($sarg =~ /^\d+$/) {
                        pgm_exit(1,"ERROR: Invalid argument [$arg $sarg]! Out of range 1 - $tmp\n");
                    } else {
                        if ($sarg =~ /^help$/i) {
                            show_dbg_help();
                            pgm_exit(0,"DEBUG Help exit(0)\n");
                        } elsif ($sarg =~ /^all$/i) {
                            prt("Setting ALL debug ON!\n");
                            set_all_dbg_on();
                        } elsif ($sarg =~ /^none$/i) {
                            prt("Setting ALL debug OFF!\n");
                            set_all_dbg_off();
#                        } elsif ($sarg =~ /^dry-run$/i) {
#                            prt("Setting DRY RUN ONLY!\n");
#                            $only_dry_run = 1;
#                            $out_dsp = 0;
#                            $out_dsp2 = 0;
                        } else {
                            pgm_exit(1,"ERROR: Invalid argument [$arg $sarg]! Not numerical in range 1 - $tmp, nor 'all', 'none', or 'help' !\n");
                        }
                    }
                }
            } elsif ($sarg =~ /^m/i) {
                # store a macro
                need_arg(@av);
                shift @av;
                $sarg = $av[0];
                need_arg(@av);
                shift @av;
                $tmp = $av[0];
                $common_subs{$sarg} = $tmp;
                prt("Set MACRO $sarg=$tmp in common subs...\n");
            } elsif ($sarg =~ /^r/i) {  # response file
                need_arg(@av);
                shift @av;
                $sarg = $av[0];
                load_input_file($arg,$sarg);
            } else {
                pgm_exit(1,"ERROR: Invalid argument [$arg]! Try -?\n");
            }
        } else {
            $in_file = File::Spec->rel2abs($arg);
            prt("Set input to [$in_file]\n");
        }
        shift @av;
    }
    if ((length($in_file) ==  0) && $debug_on) {
        $in_file = $def_file;
        $load_log = 1;
    }

    if (length($in_file) ==  0) {
        pgm_exit(1,"ERROR: No input files found in command!\n");
    }
    if (! -f $in_file) {
        pgm_exit(1,"ERROR: Input file [$in_file] NOT FOUND!\n");
    }
}

# eof - amscan.pl

