#!/usr/bin/perl -w
# NAME: amscan02.pl
# AIM: Given a single Makefile.am, try to SCAN all in the set
# 07/09/2010 - Moving towards a lib_amscan.pl
# 05/09/2010 - Some further tidying...
# 31/08/2010 - Review (with new/better understanding of the Makefile.am ;=))
# 11/11/2008 - geoff mclane - http://geoffair.net/mperl
# ####################################################
use strict;
use warnings;
use File::Basename;    # to split path into ($name, $dir) = fileparse($ff); or ($nm,$dir,$ext) = fileparse( $fil, qr/\.[^.]*/ );
use File::Spec; # File::Spec->rel2abs($rel); # we are IN the SLN directory, get ABSOLUTE from RELATIVE
use Cwd;
my $perl_sdir = 'C:\GTools\perl';
unshift(@INC, $perl_sdir);
require 'fgutils02.pl' or die "Unable to load 'fgutils02.pl' ...\n";
require 'lib_amscan.pl' or die "Unable to load 'lib_amscan.pl'\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /(\\|\/)/) {
    my @tmpsp = split(/(\\|\/)/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $perl_temp_dir = $perl_sdir."\\temp";
my $outfile = $perl_sdir."\\temp.$pgmname.txt";
open_log($outfile);
my $miss_mac_file = $perl_temp_dir."\\temp.missed.txt";
my $in_file = '';

my $debug_on = 0;   # run with DEFAULT, if no other input...
my $def_file = 'C:\Projects\libsigc\libsigc++-2.2.8\sigc++\Makefile.am';
#my $def_file = 'C:\Projects\libsigc\libsigc++-2.2.8\Makefile.am';
#my $def_file = 'C:\FG\FGCOMXML\libwww\Makefile.am';
my $def_targ = '';
##my $def_file = 'C:\FGCVS\gettext-0.17\Makefile.am';
##my $def_targ = "C:\\FGCVS\\gettext-0.17\\msvc\\";
##my $def_file = 'C:\Projects\zziplib-0.13.50\Makefile.am';
##my $def_file = 'C:\FGCVS\Jack\Makefile.am';
##my $def_file = 'C:\FG\PREOSG\FlightGear\source\Makefile.am';
##my $def_file = 'C:\FG\FGRUN\gettext\Makefile.am';

# features
my $ignore_EXTRA_DIST = 0;  # no SHOW of 'EXTRA_DIST' key
my $load_log = 0;
my $add_rel_sources = 1; # seems source are not stored relative already!!!
### my $add_rel_sources = 0; # seems source are stored relative already!!!
my $try_harder = 1; # search HARD for program source
my $try_much_harder = 1;    # and do a directory scan, and find a C/C++ source of same name
my $show_per_file = 1;  # show missing on a per file basis
my $fix_relative_sources = 1;   # change source to relative to target_directory, ready for DSP
my $warn_on_plus = 0; # lev = 2 = Had a plus sign, is += so variable SHOULD exist
#           and warn if it does NOT, if $warn_on_plus
my $process_subdir = 0;

my %g_global_hash = (
    'base_LIBS'  => "",
    'opengl_LIBS' => "",
    'network_LIBS' => "",
    'joystick_LIBS' => "",
    'thread_LIBS' => "",
    'openal_LIBS' => "",
    'pkgdatadir' => "",
    'datadir' => "",
    'srcdir' => "",
    'docdir' => "",
    'localedir' => "",
    'RELOCATABLE_LDFLAGS' => "",
    'LIBTOOL' => "lib",
    'libdir' => "",
    'BISON_LOCALEDIR' => "",
    'AM_LIBTOOLFLAGS' => "",
    'AM_CFLAGS' => "",
    'OPENMP_CFLAGS' => "",
    'gl_LIBOBJS' => "glu32.lib"
);

my %g_def_condits = (
    "USE_GLUT" => "TRUE",
    "ENABLE_JPEG_SERVER" => "FALSE",
    "ENABLE_SP_FDM" => "TRUE"
);

my $added_in_init = '';
my %g_common_subs = (
    'LIBTOOL' => 'link',
    'CC' => 'cl'
);    

# some exception warnings suppressed
my %g_sources_exceptions = (
  'DOXSOURCES' => 1
  );

my ($root_file, $root_folder);
my $target_dir = '';

my %g_programs = ();
my %g_libraries = ();
my %g_ams_done = ();
my %g_subs_not_found = ();    # list shown if $dbg_s13 or $dbg_s14
my %g_defs_not_found = ();    # list shown if $dbg_s13 or $dbg_s14

my @warnings = ();
my $command_line = '';

# DEBUG
our $dbg_s01 = 0; # show each file line, in form "[01] $i2: [$line]"
our $dbg_s02 = 0; # show extraction from hash, like "Listing $acnt keys in hash ..."
our $dbg_s03 = 0; # show "Find sources for $val LIBRARY keys ...\n" and MORE
our $dbg_s04 = 0; # show prt( "LIBRARY [$ky] has SOURCES [$val]
our $dbg_s05 = 0; # show prt( "$am ". ((-f $am) ? "ok" : "no find!")
our $dbg_s06 = 0; # show prt( "Opened cond_stack with [".$cond_stack[$#cond_stack]."] $fil
our $dbg_s07 = 0; # add new line before 'Processing $cnt lines..., as does 08 also...
our $dbg_s08 = 0; # show prt( "Processing $cnt lines from $fil ...
our $dbg_s09 = 0; # show prt( "Got $cnt subdirectories [$slist] ...
our $dbg_s10 = 0; # show prtw("WARNING:1: No substitution for [$ms] found in hash ...
our $dbg_s11 = 0; # show target: gathering of lines...
our $dbg_s12 = 0; # show setting key=value in hash, during am file scan
our $dbg_s13 = 0; # show initial substitution, during am file scan
our $dbg_s14 = 0; # similar to about, but only show NO sub FOUND
our $dbg_s15 = 0; # List each source, for each project...
our $dbg_s16 = 0; # Like [02] list ALL keys showing dispostion
our $dbg_s17 = 0; # Out CHECK ME - SHOULD THIS ITEMS BE INCLUDED for a prog,lib,src key, now skipped!
our $dbg_s18 = 0; # show change due to adding relative directory
my $check_sum = 18;

my $cwd = cwd();
my $os = $^O;
my $exit_value = 0;

#####################################################
######## SUBS ONLY ###########
#####################################################
# FOR DEBUG
my $dbg_base = 'dbg_s';

sub set_dbg_base($) { $dbg_base = shift; }

sub get_dbg_var($) {
    my $val = shift;
    my $var = $dbg_base;
    my $res = -1;
    if ($val < 10) {
        $var .= "0$val";
    } else {
        $var .= "$val";
    }
    # from : http://perldoc.perl.org/functions/eval.html
    if (eval "defined \$$var") {
        $res = eval "\$$var";
    }
    return $res;
}

sub get_dbg_stg() {
    my $s = '';
    my ($i,$res,$i2);
    for ($i = 1; ;$i++) {
        $res = get_dbg_var($i);
        last if ($res == -1);
        if ($i < 10) {
            $i2 = "0$i";
        } else {
            $i2 = "$i";
        }
        if ($res) {
            $s .= "$i2 ";
        }
    }
    return $s;
}

sub get_dbg_range() {
    my ($i,$res);
    for ($i = 1; ;$i++) {
        $res = get_dbg_var($i);
        last if ($res == -1);
    }
    return $i - 1;
}

sub set_dbg_var($) {
    my $val = shift;
    my $var = $dbg_base;
    if ($val < 10) {
        $var .= "0$val";
    } else {
        $var .= "$val";
    }
    # from : http://perldoc.perl.org/functions/eval.html
    # NOT $$var++; # does not work!
    if (eval "defined \$$var") {
        eval "\$$var++";
    } else {
        #print "ERROR: \$$var does NOT exist\n";
        return 0;
    }
    return 1;
}

sub clear_dbg_var($) {
    my $val = shift;
    my $var = $dbg_base;
    if ($val < 10) {
        $var .= "0$val";
    } else {
        $var .= "$val";
    }
    # from : http://perldoc.perl.org/functions/eval.html
    # NOT $$var++; # does not work!
    if (eval "defined \$$var") {
        eval "\$$var = 0";
    } else {
        #print "ERROR: \$$var does NOT exist\n";
        return 0;
    }
    return 1;
}

sub set_all_dbg_on() {
    my ($i,$res);
    for ($i = 1; ;$i++) {
        $res = set_dbg_var($i);
        last if (!$res);
    }
}

sub set_all_dbg_off() {
    my ($i,$res);
    for ($i = 1; ;$i++) {
        $res = clear_dbg_var($i);
        last if (!$res);
    }
}

######################################################

######################################################
### INIT ###
my @common_set = qw( LIBS LDFLAGS CPPFLAGS CXXFLAGS CFLAGS X_CFLAGS );
my @common_dir_set = qw( ADDON_DIR BASE_DIR bindir BUILD_DIR DATA_DIR datadir datarootdir DESTDIR dir distdir
 DIRNAME docdir htmldir HTML_DIR INCLUDE_DIR infodir INSTALL_DATA
 includedir mkinstalldirs mandir libdir objdir sbindir srcdir tardir top_builddir top_srcdir X_EXTRA_LIBS 
 x_includes x_libraries X_LIBS X_PRE_LIBS X11_LIB );
my %known_set = (
 'CC' => 'cl',
 'CXX' => 'cl',
 'EXEEXT' => 'exe',
 'OBJEXT' => 'obj',
 'ac_default_prefix' => './',
 'exec_prefix' => './',
 'host' => 'WIN32',
 'host_cpu' => 'X86',
 'host_os' => 'Windows',
 'host_vendor' => 'MS',
 'LINK' => 'link',
 'LL' => 'link',
 'MAKE' => 'nmake',
 'manext' => 'doc',
 'POSIX_SHELL' => 'sh',
 'prefix' => './',
 'SHELL' => 'sh',
 'SED' => 'sed',
 'YASM' => 'yasm'
 );

my @others_maybe = qw( enableval );

sub get_root_dir() { return $root_folder; }

sub add_key_2_added($) {
    my $key = shift;
    $added_in_init .= " " if (length($added_in_init));
    $added_in_init .= $key;
}

sub init_commmon_subs2($$) {
    my ($rh,$add) = @_;  # = \%common_subs
    my ($key,$rd,$val);
    $rd = get_root_dir();
    # prt("Init using common directory [$rd]\n");
    # like 'srcdir'
    foreach $key (@common_dir_set) {
        if (!defined ${$rh}{$key}) {
            ${$rh}{$key} = $rd;
            add_key_2_added($key) if ($add);
        }
    }
    foreach $key (@common_set) {
        if (!defined ${$rh}{$key}) {
            ${$rh}{$key} = '';
            add_key_2_added($key) if ($add);
        }
    }
    # like 'CC', 'EXEEXT', ...
    foreach $key (keys %known_set) {
        if (!defined ${$rh}{$key}) {
            $val = $known_set{$key};
            ${$rh}{$key} = $val;
            add_key_2_added($key) if ($add);
        }
    }
}

sub init_common_subs($) {
    my ($inf) = shift;
    ($root_file, $root_folder) = fileparse($inf);
    $root_folder = path_u2d($root_folder);
    if (length($target_dir) == 0) {
        $target_dir = $root_folder;
        $fix_relative_sources = 0;  # no fix needed. since the SAME as 'root'
    }
    init_commmon_subs2(\%g_common_subs,1);
}

sub show_missing_subs($) {
    my ($rsnf) = @_;
    if ($dbg_s13 || $dbg_s14) {
        my @arr = keys %{$rsnf};
        my ($cnt,$txt,$key,$fil,$val,%hash);
        $txt = '';
        if (@arr) {
            $cnt = scalar @arr;
            prt("[13|14] There are at least $cnt missing substitutions.\n");
            $txt = "# [13|14] There are at least $cnt missing substitutions.\n";
            if ($show_per_file) {
                %hash = ();
                foreach $key (@arr) {
                    $fil = ${$rsnf}{$key};
                    push(@{$hash{$fil}},$key);
                }
                foreach $fil (keys %hash) {
                    $val = $hash{$fil};
                    $cnt = scalar @{$val};
                    $txt .= "# Missing $cnt from file [$fil]\n";
                    prt("Missing $cnt [");
                    foreach $key (sort @{$val}) {
                        $txt .= "-m $key \"\"\n";
                        prt("$key ");
                    }
                    prt("] from file [$fil]\n");
                }
            } else {
                foreach $key (sort @arr) {
                    $fil = ${$rsnf}{$key};
                    prt("Missing [$key], in [$fil]\n");
                    $txt .= "-m $key \"\"\n";
                }
            }
        } else {
            prt("[13|14] There are NO missing substitutions.\n");
        }
        @arr = split(/\s/,$added_in_init);
        $cnt = scalar @arr;
        if ($cnt) {
            prt("But note ADDED $cnt items, during init...");
            if (length($miss_mac_file) && (length($txt))) {
                $txt .= "# Note the following set of $cnt items were added during init...\n";
                %hash = ();
                init_commmon_subs2(\%hash,0);
                $cnt = 0;
                foreach $key (@arr) {
                    if (defined $hash{$key}) {
                        $val = $hash{$key};
                        if ( (length($val) == 0) || ($val =~ /^\s+$/) ) {
                            $val = '""';
                        }
                        $txt .= "-m $key $val\n";
                        $cnt++;
                    }
                }
                prt(" also now added to response file...");
            }
            prt("\n");
        }
        if (length($miss_mac_file) && (length($txt))) {
            write2file($txt,$miss_mac_file);
            prt("Written list for use as '-r $miss_mac_file' response file, after correction.\n");
        }
    }
}

my %warned_done = ();
my $warning_count = 0;
sub prtw($) {
    my ($tx) = shift;
    $tx =~ s/\n$// if ($tx =~ /\n$/);
    prt("$tx\n");
    if (!defined $warned_done{$tx}) {
        push(@warnings,$tx);
        $warned_done{$tx} = 1;
    }
    $warning_count++;
}

sub show_warnings($) {
    my $val = shift;
    if (@warnings) {
        my $wcnt = scalar @warnings;
        my $msg = '';
        my $diff = $warning_count - $wcnt;
        $msg = "Note $diff duplicates NOT repeated." if ($diff);
        prt( "\nRepeat of $wcnt WARNINGS... $msg\n" );
        foreach my $line (@warnings) {
            prt("$line\n" );
        }
        prt("\n");
    } elsif ($val) {
        prt("\nNo warnings issued.\n\n");
    }
}


sub pgm_exit($$) {
    my ($val,$msg) = @_;

    show_warnings($val);

    show_missing_subs(\%g_subs_not_found) if ($val == 0);

    if (length($msg)) {
        $msg =~ s/\n$//;
        $msg .= " time:".localtime(time())."\n";
        prt($msg);
    }
    
    close_log($outfile,$load_log);
    exit($val);
}



sub sub_common_folder {
    my ($fil,$root) = @_;
    my $lfil = lc(path_u2d($fil));
    my $lrot = lc(path_u2d($root));
    my $len1 = length($lfil);
    my $len2 = length($lrot);
    my ($i);
    for ($i = 0; (($i < $len1)&&($i < $len2)); $i++) {
        if (substr($lfil,$i,1) ne substr($lrot,$i,1)) {
            last;
        }
    }
    return substr($fil,$i);
}

sub sub_root_folder {
    my ($fil) = shift;
    my $rd = get_root_dir();
    return sub_common_folder($fil,$rd);
}

sub begins_with {
    my ($rt, $pt) = @_;
    my $ln = length($rt);
    if (length($pt) >= $ln) {
        for (my $i = 0; $i < $ln; $i++) {
            if (substr($rt,$i,1) ne substr($pt,$i,1)) {
                return 0;
            }
        }
        return 1;
    }
    return 0;
}

# VARIOUS FIXES FOR THE FILE NAME
# 1. ensure ALL DOS format
# 2. remove any simple dot relative, like '.\' from beginning
# 3. if given a FULL PATH name, remove C:\FG\20\FlightGear
# 4. if a relative name, remove FligthGear
# 5. if any removal, ensure any beginning '\' is removed
sub sub_root_dir($) {
    my ($ff) = shift;   # = $a_dir.$src
    $ff = path_u2d($ff);
    my $rd = get_root_dir();
    if (begins_with($rd, $ff)) {
        $ff = substr($ff, length($rd));
    }
    return $ff;
}


sub am_macro_split($) {
    my ($txt) = @_;
    my @arr = ();
    my $len = length($txt);
    my ($i,$tag,$ch,,$nc,$mac,$k);
    $tag = '';
    for ($i = 0; $i < $len; $i++) {
        $ch = substr($txt,$i,1);
        if ($ch eq '$') {
            $k = $i + 1;
            if ((($k+3) < $len)&&(substr($txt,$k,1) eq '(')) {
                $k++;
                $mac = '$(';
                for (; $k < $len; $k++) {
                    $nc = substr($txt,$k,1);
                    $mac .= $nc;
                    last if ($nc eq ')');
                    last if !($nc =~ /\w/);
                }
                if ($nc eq ')') {
                    push(@arr,$tag) if (length($tag));
                    $tag = '';
                    push(@arr,$mac);
                    $ch = '';
                    $i = $k;
                }
            }
        }
        if (($ch eq "'") || ($ch eq '"')) {
            push(@arr,$tag) if (length($tag));
            $tag = '';
            push(@arr,$ch);
        } else {
            $tag .= $ch;
        }
    }
    return @arr;
}


sub process_one_am_file($) {
    my ($rparams) = @_;
    my $ramsdone = ${$rparams}{'REF_AMS_DONE'};
    my $fil = ${$rparams}{'AM_FILE'};
    $fil = fix_rel_path3($fil,'process_one_am_file');
    my $sfil = sub_root_folder($fil);

    return if (defined ${$ramsdone}{$fil});

    ${$ramsdone}{$fil} = 1;

    my $ramh = am_process_AM_file($rparams);
    my ($p_tit,$p_dir,$p_ext) = fileparse( $fil, qr/\.[^.]*/ );
    my $do_subs = ${$rparams}{'PROCESS_SUBDIR'};
    if ($do_subs && (defined ${$ramh}{'SUBDIRS'})) {
        my $slist = ${$ramh}{'SUBDIRS'};
        my @ar = split(/\s/,$slist);
        my $cnt = scalar @ar;
        prt( "[09] Got $cnt subdirectories [$slist] ...from [$sfil]\n" ) if ($dbg_s09);
        foreach my $dir (@ar) {
            my $am = $p_dir.$dir.'\Makefile.am';
            $am = path_u2d($am);
            $am =~ s/\\\\/\\/g while ($am =~ /\\\\/);
            my $sam = sub_root_folder($am);
            if (-f $am) {
                prt( "[05] Processing AM file [$am], from [$fil] ...\n" ) if ($dbg_s05);
                ${$rparams}{'AM_FILE'} = $am;
                process_one_am_file($rparams);
                ${$rparams}{'AM_FILE'} = $fil;
            } else {
                prtw( "[05] WARNING: AM [$am] NOT FOUND! in [$dir], from [$fil]!\n" ) if ($dbg_s05);
            }
        }
    } 
    return $ramh;
}

sub process_primary($) {
    my ($fil) = shift;
    my %my_params = ();
    my $rparams = \%my_params;
    ${$rparams}{'AM_FILE'} = $fil;
    my $rprogs = \%g_programs;
    ${$rparams}{'REF_PROGRAMS'} = $rprogs;
    my $rlibs = \%g_libraries;
    ${$rparams}{'REF_LIBRARIES'} = $rlibs;
    my $ramsdone = \%g_ams_done;
    ${$rparams}{'REF_AMS_DONE'} = $ramsdone;
    my $rcomsubs = \%g_common_subs;
    ${$rparams}{'REF_COMMON_SUBS'} = $rcomsubs;
    my $rglobhash = \%g_global_hash;
    ${$rparams}{'REF_GLOBAL_HASH'} = $rglobhash;
    ${$rparams}{'REF_EXIT_VALUE'} = \$exit_value;
    ${$rparams}{'PROCESS_SUBDIR'} = $process_subdir;
    my $rsnf = \%g_subs_not_found;
    ${$rparams}{'REF_SUBS_NOT_FOUND'} = $rsnf;
    my $rdnf = \%g_defs_not_found;
    ${$rparams}{'REF_DEFS_NOT_FOUND'} = $rdnf;

    ${$rparams}{'VALUE_WARN_ON_PLUS'} = $warn_on_plus;
    my $rdef_conds = \%g_def_condits;
    ${$rparams}{'REF_DEF_CONDITIONS'} = $rdef_conds;
    my $rexcept = \%g_sources_exceptions;
    ${$rparams}{'REF_SRC_EXCEPT'} = $rexcept;
    ### ${$rparams}{'MAX_OF_TYPE'} = $max_of_type;
    ${$rparams}{'ADD_REL_SOURCE'} = $add_rel_sources;
    ${$rparams}{'ROOT_FOLDER'} = $root_folder;
    ${$rparams}{'TRY_HARDER'} = $try_harder;
    ${$rparams}{'TRY_MUCH_HARDER'} = $try_much_harder; 
    ${$rparams}{'IGNORE_EXTRA_DIST'} = $ignore_EXTRA_DIST;
    ${$rparams}{'FIX_REL_SOURCE'} = $fix_relative_sources;
    ${$rparams}{'TARGET_DIR'} = $target_dir;

    my $rh = process_one_am_file($rparams);  # iteratively process the Makefile.am files
    #list_to_arrays($fil,\%g_programs,\%g_libraries,\%g_ams_done);
    list_to_arrays($rparams);
    ##write_temp_dsp($dsp_outfile);
}

sub get_perl_temp_dir() {
    if (! -d $perl_temp_dir) {
        mkdir $perl_temp_dir;
        if (! -d $perl_temp_dir) {
            pgm_exit(1,"ERROR: Unable to create directory [$perl_temp_dir]\nMaybe there is already a file of that name, or...\n");
        }
    }
}

#############################################################
##### MAIN #####
set_dbg_base("dbg_s");

#set_debug_none();
#set_debug_all();
pgm_exit(1,"ERROR: Debugging is FAILING! check-sum=$check_sum, dbg = ".get_dbg_range()."!\n") if (get_dbg_range() != $check_sum);

get_perl_temp_dir();

parse_args(@ARGV);

init_common_subs( $in_file );

process_primary( $in_file );

pgm_exit($exit_value,"CMD: [".$command_line."] Normal Exit");

##############################################################

sub give_help {
    my ($tmp);
    prt("$pgmname: version 0.0.2 2010-09-05\n");
    prt("Usage: $pgmname [options] in-file\n");
    prt("Options:\n");
    prt(" --help   (-h or -?) = This help, and exit 0.\n");
    $tmp = get_dbg_range();
    prt(" --dbg <num>    (-d) = Set DEBUG flag of this value. Number in range 1 to $tmp\n");
    prt(" --load-log     (-l) = Load LOG file at end.\n");
    prt(" --mac item val (-m) = Store a MACRO, item=value, for substitution. (use '-d 14' to list missing).\n");
    prt(" --quick        (-q) = Be quick. This turn OFF any directory scanning for sources.\n");
    prt(" --subdir       (-s) = Process SUBDIR entries, and ALL Makefile.am files found.\n");
    prt(" --resp <file>  (-r) = Commands from a reponse/input file.\n");
    prt(" --targ <dir>   (-t) = Establish a target directory for the DSW/DSP files.\n");
    prt("Purpose:\n");
    prt("Read the file given as a GNU Makefile.am autotools project description file, and\n");
    prt("show its contents. If the --subdir (-s) command is given, and it contains any SUBDIRS = macro,\n");
    prt("then it check each sub-directory for a Makefile.am file, and if found, process it also.\n");
    prt("NOTES:\n");
    prt(" The debug switch is strictly for that. It adds no functionality, just a noisier output,\n");
    prt("  and has the text settings of 'all', 'none', or 'help', to show the list in more detail.\n");
    prt(" While this script does NOT output DSW/DSP files, if given a target directory, the source file\n");
    prt("  lists for each project source listed will be adjusted as if the DSP file was in this target\n");
    prt("  directory. The default will be the same directory as the primary Makefile.am file.\n");
    prt(" This script does NOT function with a Makefile.in, which is more like a 'standard' makefile that\n");
    prt("  would be used by the 'make', or 'nmake' tools in windows.\n");

    $tmp = get_dbg_stg();
    prt(" For debug, presently values [$tmp] are ON\n") if (length($tmp));
}

sub need_arg {
    my ($arg,@av) = @_;
    pgm_exit(1,"ERROR: [$arg] must have following argument!\n") if (!@av);
}

sub show_dbg_help() {
    my $file = $0;
    my ($line,$max,$tmp,$cnt,$tmp2);
    $max = get_dbg_range();
    $tmp = get_dbg_stg();
    prt(" --dbg <num>  (-d)  = Set DEBUG flag of this value. Number in range 1 to $tmp\n");
    prt(" Presently %tmp are ON.\n") if (length($tmp));
    prt(" Additional text setting are 'all', 'none', and this 'help'.\n");
    if (open INF, "<$file") {
        my @lines = <INF>;
        close INF;
        prt(" Detailed list, with some 'notes' indicating what each does.\n");
        $cnt = 0;
        foreach $line (@lines) {
            $line = trim_all($line);
            if ($line =~ /^our\s+\$dbg_s(\d+)\s*=\s*\d+\s*;\s*#(.+)$/) {
                $tmp = $1;
                $tmp2 = $2;
                prt("$tmp: $tmp2\n");
                $cnt++;
            }
        }
        prt("ERROR: Found no \$dbg?? vars in file [$file], so NO DEBUG ADDITIONAL HELP!\n") if (!$cnt);
    } else {
        prt("ERROR: Unable to open file [$file], so NO DEBUG ADDITIONAL HELP!\n");
    }
}

sub local_strip_both_quotes($) {
    my $txt = shift;
    if ($txt =~ /^'(.+)'$/) {
        return $1;
    }
    if ($txt =~ /^"(.+)"$/) {
        return $1;
    }
    return '' if ($txt eq '""');
    return '' if ($txt eq "''");
    #prt("Stripping [$txt] FAILED\n");
    return $txt;
}

my $in_input_file = 0;
sub load_input_file($$) {
    my ($arg,$file) = @_;
    if (open INF, "<$file") {
        my @lines = <INF>;
        close INF;
        my @carr = ();
        my ($line,@arr);
        foreach $line (@lines) {
            $line = trim_all($line);
            next if (length($line) == 0);
            next if ($line =~ /^#/);
            @arr = split(/\s/,$line);
            push(@carr,@arr);
        }
        $in_input_file++;
        parse_args(@carr);
        $in_input_file--;
    } else {
        pgm_exit(1,"ERROR: Unable to 'open' file [$file]!\n")
    }
}

sub wait_key() {
    prt("Any key to continue...\n");
    my $char = <>;
}

sub set_debug_all() {
    my $cnt = am_get_dbg_range();
    prt("Setting DEBUG 01 to $cnt ON\n");
    am_set_all_dbg_on();
}
sub set_debug_none() {
    my $cnt = am_get_dbg_range();
    prt("Setting DEBUG 01 to $cnt OFF\n");
    am_set_all_dbg_off();
}

sub add_to_commands($) {
    my ($rav) = @_;
    my ($tmp);
    foreach $tmp (@{$rav}) {
        $command_line .= ' ' if (length($command_line));
        $command_line .= $tmp;
    }
}

sub parse_args {
    my (@av) = @_;
    my ($arg,$sarg,$tmp,$rng);
    add_to_commands(\@av);
    while (@av) {
        $arg = $av[0];
        if ($arg =~ /^-/) {
            $sarg = substr($arg,1);
            $sarg = substr($sarg,1) while ($sarg =~ /^-/);
            if (($sarg =~ /^h/i)||($sarg eq '?')) {
                give_help();
                pgm_exit(0,"Help exit(0)");
            } elsif ($sarg =~ /^l/i) {
                $load_log = 1;
                prt("Set to load log at end.\n");
            } elsif ($sarg =~ /^d/i) {
                need_arg(@av);
                shift @av;
                $sarg = $av[0];
                $rng = get_dbg_range();
                if (($sarg =~ /^\d+$/) && ($sarg >= 1) && ($sarg <= $rng)) {
                    $tmp = 'dbg';
                    if ($sarg < 10) {
                        $tmp .= "0$sarg";
                    } else {
                        $tmp .= "$sarg";
                    }
                    set_dbg_var($sarg);
                    prt("Set Debug $tmp ON! (of $rng)\n");
                } else {
                    if ($sarg =~ /^\d+$/) {
                        pgm_exit(1,"ERROR: Invalid argument [$arg $sarg]! Out of range 1 - $rng\n");
                    } else {
                        if ($sarg =~ /^help$/i) {
                            show_dbg_help();
                            pgm_exit(0,"DEBUG Help exit(0)\n");
                        } elsif ($sarg =~ /^all$/i) {
                            set_all_dbg_on();
                            $tmp = get_dbg_stg();
                            prt("Set ALL debug ON! 1 to $rng [$tmp]\n");
                        } elsif ($sarg =~ /^none$/i) {
                            set_all_dbg_off();
                            $tmp = get_dbg_stg();
                            prt("Setting ALL debug OFF! 1 to $rng [$tmp]\n");
                        } else {
                            pgm_exit(1,"ERROR: Invalid argument [$arg $sarg]! Not numerical in range 1 - $tmp, nor 'all', 'none', or 'help' !\n");
                        }
                    }
                }
            } elsif ($sarg =~ /^m/i) {
                # store a macro
                need_arg(@av);
                shift @av;
                $sarg = $av[0];
                need_arg(@av);
                shift @av;
                $tmp = $av[0];
                $g_common_subs{$sarg} = local_strip_both_quotes($tmp);
                prt("Set MACRO $sarg = [$tmp] in common subs...\n");
            } elsif ($sarg =~ /^q/i) {  # quick = no directory scan
                $try_harder = 0;
                $try_much_harder = 0;
                prt("Turned OFF the try harder directory scans, if needed.\n");
            } elsif ($sarg =~ /^r/i) {  # response file
                need_arg(@av);
                shift @av;
                $sarg = $av[0];
                load_input_file($arg,$sarg);
            } elsif ($sarg =~ /^s/i) {  # process SUBDIR entries
                $process_subdir = 1;
                prt("Set to process SUBDIR entries, if found.\n");
            } elsif ($sarg =~ /^t/i) {  # target directory for DSP file(s)
                need_arg(@av);
                shift @av;
                $sarg = $av[0];
                $target_dir = File::Spec->rel2abs($sarg);
                $fix_relative_sources = 1;
                prt("Set to TARGET folder to [$target_dir].\n");
            } else {
                pgm_exit(1,"ERROR: Invalid argument [$arg]! Try -?\n");
            }
        } else {
            $in_file = File::Spec->rel2abs($arg);
            prt("Set input to [$in_file]\n");
        }
        shift @av;
    }

    if (!$in_input_file) {
        if ((length($in_file) ==  0) && $debug_on) {
            $in_file = $def_file;
            $target_dir = $def_targ if (length($target_dir) == 0);
            #$load_log = 1;
            #$process_subdir = 1;
            #prt("[debug_on] Set to process SUBDIR entries, if found.\n");
            $rng = get_dbg_range();
            set_all_dbg_on();
            $tmp = get_dbg_stg();
            prt("[debug_on] Set ALL debug ON! 1 to $rng [$tmp]\n");
        }

        if (length($in_file) ==  0) {
            pgm_exit(1,"ERROR: No input files found in command!\n");
        }

        $in_file = path_u2d($in_file);
        if (! -f $in_file) {
            pgm_exit(1,"ERROR: Input file [$in_file] NOT FOUND!\n");
        }
    }
    #wait_key();
}

# eof - amscan02.pl