#!/perl -w
# NAME: basename02.pl
# AIM: simple example of using fileparse, and basename ...
# see http://perldoc.perl.org/File/Basename.html
use strict;
use warnings;
use File::Basename;
use File::Spec::Functions qw[splitpath canonpath splitdir abs2rel];

my $fullname = 'C:\path1\path2\basename.txt';
show_split( $fullname );
$fullname = 'C:\path1/path2/somename.html'; # mixed unix windows spearator
show_split( $fullname );
$fullname = '..\..\relname.c'; # simple relative path
show_split( $fullname );
$fullname = 'C:\path1\path2\./relname2'; # without ext
show_split( $fullname );
exit(0);

# subs
sub show_split {
	my ($fil) = shift;
	my ($name,$path,$suffix) = fileparse( $fil, qr/\.[^.]*/ );
	print "name=[$name], path=[$path], suffix=[$suffix] ... \n";
	my ($volume, $dir_path, $file) = splitpath( $fil );
	print "volume=[$volume], path=[$dir_path], file=[$file] ... \n";
}

# eof - basename02.pl
