#!/perl -w
# NAME: chklink.pl
# AIM: Develop a method to CHECK a URL link ...
# 23/08/2007 geoff mclane geoffair.net/mperl
use strict;
use warnings;
use Socket;
use LWP::Simple;

unshift(@INC, 'C:/GTools/perl');
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
	my @tmpsp = split(/\\/,$pgmname);
	$pgmname = $tmpsp[-1];
}
my $outfile = "temp.$pgmname.txt";
open_log($outfile);
prt( "$0 ... Hello, World ...\n" );

### debug
my $dbg3 = 1;	# show resolved IP addresses

my @urls = qw( http://babelfish.altavista.com/ http://www.geoffmclane.com/fg/
http://www.colorcombo.com/array.html http://help.godaddy.com/index.php?
http://www.microsoft.com/isapi/redir.dll?prd=ie&pver=6ar=IStart );

###my $url = 'http://babelfish.altavista.com/';
###my $url = 'http://www.geoffmclane.com/fg/';
###my $url = 'http://www.colorcombo.com/array.html';
###my $url = 'http://help.godaddy.com/index.php?';
my $url = 'http://www.microsoft.com/isapi/redir.dll?prd=ie&pver=6ar=IStart';

foreach my $u (@urls) {
	showIPAddress( $u );
	my $tc = Get_URL_Text_Count($u);
	if ($tc) {
		prt( "Got $tc chars from [$u] ...\n" );
	} else {
		prt( "FAILED **** get on [$u] ...\n" );
	}
}

#showIPAddress( $url );
#my $tc = Get_URL_Text_Count($url);
#if ($tc) {
#	prt( "Got $tc chars from [$url] ...\n" );
#} else {
#	prt( "FAILED get on [$url] ...\n" );
#}

close_log($outfile,1);
exit(0);

#################################

sub Get_URL_Text_Count {
	my ($url) = shift;
	my $txt = get( $url );
	my $tcnt = 0;
	if ($txt) {
		$tcnt =	length($txt);
	}
	return $tcnt;
}


sub Get_Host_Name {
	my ($nm) = shift;
	if ($nm =~ /^http:\/\/(.*)/i) {
		$nm = $1;
	}
	if ($nm =~ /^https:\/\/(.*)/i) {
		$nm = $1;
	}
	if ($nm =~ /^ftp:\/\/(.*)/i) {
		$nm = $1;
	}
	my @arr = split('/', $nm);
	$nm = $arr[0];
	return $nm;
}

sub Get_Domain_Name {
	my ($nm) = shift;
	$nm = Get_Host_Name($nm);
	if ($nm =~ /^www\.(.*)/) {
		$nm = substr($nm,4);
	}
	return $nm;
}


############################################################
# Only used is $chkip = 1;
# Show IP Address
# uses sockets, gethostbyname
# Return 0, if can NOT be resolved.
# else the number of IP addresses resolved.
############################################################
sub showIPAddress {
	my ($nm) = shift;
	my $hnm = Get_Host_Name($nm);
	my @addr = gethostbyname($hnm);
	my $cnt = 0;
	if( !@addr ) {
		prt( "Can't resolve [$nm]($hnm): error: $!\n" );
		return 0;
	}
	@addr = map { inet_ntoa($_) } @addr[4 .. $#addr];
	foreach my $k (@addr) {
		$cnt++;
		prt( "$cnt: $nm ($hnm) resolves to IP [$k]\n" ) if ($dbg3);
	}
	return $cnt;
}

# eof - chklink.pl
