#!/Perl
# AIM: To build a CLEANUP batch file
# for a DIRECTORY ...
# Presently no input - you must adjust the my_folder variable
# Only searches for targets directories containing -
# *.obj or *.sbr or *.idb or *.pdb or *.ncb or *.opt
# and temp*.* - with one exception is the 'CVS' directory 'Template' file
# Uses a CLOBNOW.BAT file to do the cleanup in a folder
# Uncomment write_clobnow2 below to write this batch file,
# which obviously HAS to be renamed to 'clobnow.bat', and
# put in a VALID runtime PATH ...
my $verbose = 1;
my $verb2 = 0;
my $my_folder = 'C:\FG099';
###my $my_folder = 'C:\FGOK';
my @dirs = ($my_folder); # folders to process
my @dir_obj = (); # start with NONE
my $do_cnt = 0;
my $bat_fil = 'cleanup.bat';
my $BF;
my $d;
open $BF, ">$bat_fil" or die "Can NOT open BATCH file $bat_fil!\n";

while ( scalar @dirs ) {
	local @dirs2 = @dirs;
	@dirs = ();
	local $dir;
	foreach $dir (@dirs2) {
		print '.' if !$verb2;
		process_dir($dir);
	}
	print "\n" if !$verb2;
}
$do_cnt = scalar @dir_obj;
print "Found $do_cnt directories, with objects ...\n";
foreach $d (@dir_obj) {
	print $BF "cd $d\n";
	print $BF "call clobnow\n";
}
print $BF '@echo' . " Processed $do_cnt directories, with objects ...\n";
print $BF "call hperl";
close ($BF);
# uncomment this to write a clobnow2.bat file
# write_clobnow2();
##################################
# end of program

#################################
### only subs below
#################################

sub process_dir {
	local ($in_folder) = @_;
	print "Processing folder $in_folder ...\n" if $verb2;
	if( !( -d $in_folder ) ) {
		print "Folder $in_folder is NOT a directory! ... aborting ...\n" if $verbose;
		return 0;
	}

	if (! opendir(DIRH, $in_folder) ) {
		print "ERROR: Can NOT open directory $in_folder ... aborting ...\n" if $verbose;
		return 0;
	}

	local @files = readdir(DIRH);
	closedir(DIRH);
	local $fcnt = scalar @files;
	if ((! @files) || ($fcnt < 3)) {
		print "No files found in folder $in_folder ...\n" if $verb2;
		return 0;
	}

	local ($fn, $ffn);
	local $got_obj = 0;
	print "Found $fcnt items in folder ...\n" if $verb2;

	$got_obj = 0;
	foreach $fn (@files) {
		$ffn = $in_folder . '\\' . $fn;
		if ( -d $ffn ) {
			if (($fn eq '.') || ($fn eq '..')) {
				# do nothing
			} else {
				push(@dirs, $ffn);
				print "Sub-directory $ffn ...\n" if $verb2;
			}
		} else {
			if (($fn =~ /\.obj$/i) || ($fn =~ /\.sbr$/i)) {
				print "Object File $ffn ...\n" if $verb2;
				$got_obj++;
			} elsif (($fn =~ /^temp/i) && !($fn =~ /^Template$/) ) {
				print "Temp*.* File $ffn ...\n" if $verb2;
				$got_obj++;
			} elsif (($fn =~ /\.idb$/i) || ($fn =~ /\.pdb$/i)) {
				print "IDB or PDB File $ffn ...\n" if $verb2;
				$got_obj++;
			} elsif (($fn =~ /\.ncb$/i) || ($fn =~ /\.opt$/i)) {
				print "NCB or OPT File $ffn ...\n" if $verb2;
				$got_obj++;
			} else {
				print "File $ffn ...\n" if $verb2;
			}
		}
	}

	local $dcnt = scalar @dirs;
	if ($got_obj) {
		print "Found $got_obj obj in folder .../n" if $verb2;
		push(@dir_obj, $in_folder);
	} else {
		print "Found NO obj in folder ...\n" if $verb2;
	}
	if ($dcnt) {
		print "Found $dcnt directories to process ...\n" if $verb2;
	}
}

sub write_clobnow2 {
	open $CN, ">clobnow2.bat" or die "Can NOT open BATCH file clobnow2.bat!\n";
	print $CN <<EOF;
\@REM Updated 12 Nov, 2005 ... added .sbr
\@if EXIST *.old echo Deleting *.old ...
\@if EXIST *.old Del *.old > nul
\@if EXIST *.bak echo Deleting *.bak ...
\@if EXIST *.bak Del *.bak > nul
\@if NOT EXIST temp*.* goto dntmp
\@echo	Delete temp*.* ...
\@del temp*.* > nul
:dntmp
\@if NOT EXIST *.obj goto dnobj
\@echo	Delete *.obj ...
\@del *.obj > nul
:dnobj
\@if NOT EXIST *.err goto dnerr
\@echo	Delete *.err ...
\@del *.err > nul
:dnerr
\@if NOT EXIST *.pdb goto dnpdb
\@echo	Delete *.pdb ...
\@del *.pdb > nul
:dnpdb
\@if NOT EXIST *.lst goto dnlst
\@echo	Delete *.lst ...
\@del *.lst > nul
:dnlst
\@if EXIST *.pch echo Deleting *.pch ...
\@if EXIST *.pch Del *.pch > nul
\@if EXIST *.ilk echo Deleting *.ilk ...
\@if EXIST *.ilk Del *.ilk > nul
\@if EXIST *.NCB echo Deleting *.NCB ...
\@if EXIST *.NCB Del *.NCB > nul
\@if EXIST *.plg echo Deleting *.plg ...
\@if EXIST *.plg Del *.plg > nul
\@if EXIST *.OPT echo Deleting *.OPT ...
\@if EXIST *.OPT Del *.OPT > nul
\@if EXIST *.idb echo Deleting *.idb ...
\@if EXIST *.idb Del *.idb > nul
\@if EXIST *.aps echo Deleting *.aps ...
\@if EXIST *.aps Del *.aps > nul
\@if EXIST *.sbr echo Deleting *.sbr ...
\@if EXIST *.sbr Del *.sbr > nul
:Done

EOF

	close($CN);
}

# eof - cleanup.pl
