#!/perl -w
# NAME: cmpdefines.pl
# AIM: Compare TWO header files, and list and compare the #defines in each ..
# 01/06/2008 - Initial try - geoff mclane - http"//geoffair.net/mprerl ...
use strict;
use warnings;
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
	my @tmpsp = split(/\\/,$pgmname);
	$pgmname = $tmpsp[-1];
}
my $outfile = "temp.$pgmname.txt";
open_log($outfile);
prt( "$0 ... Hello, World ...\n" );

my $in_file1 = 'C:\Projects\grep\build\config.h';
my $in_file2 = 'C:\Projects\grep\build\config2.h';
my ($FH1, $FH2);
my (@lines1, @lines2);
my $lncnt1 = 0;
my $lncnt2 = 0;
my %defs1 = ();
my %defs2 = ();
my $line = '';
my $def = '';
my @arr = ();
my $acnt = 0;
my $key = '';
my $val = '';
my $i = 0;
my $part = '';
my ($cnt1, $cnt2);
my $fnd = 0;

# debug
my $dbg1 = 0;
my $dbg2 = 0;


my ($key1, $val1, $key2, $val2);

if ( open $FH1, "<$in_file1" ) {
	if ( open $FH2, "<$in_file2" ) {
		@lines1 = <$FH1>;
		@lines2 = <$FH2>;
		close $FH1;
		close $FH2;
		$lncnt1 = scalar @lines1;
		$lncnt2 = scalar @lines2;
	} else {
		close $FH1;
		prt( "ERROR: Failed to open $in_file2 ...\n" );
	}
} else {
	prt( "ERROR: Failed to open $in_file1 ...\n" );
}
if ($lncnt1 && $lncnt2) {
	prt( "Processing\n$lncnt1 from $in_file1 ... and \n");
	prt( "$lncnt2 from $in_file2 ...\n");
	prt( "\nDoing $in_file1 ... $lncnt1 ...\n" );
	foreach $line (@lines1) {
		chomp $line;
		if ($line =~ /^\s*#\s*define\s+(.*)/) {
			$def = $1;
			@arr = split(/\s/, $def);
			$acnt = scalar @arr;
			$key = $arr[0];
			if ($acnt > 1) {
				$val = '';
				for ($i = 1; $i < $acnt; $i++) {
					$part = trim_all($arr[$i]);
					if ($part =~ /^\//) {
						if ((substr($part,1,1) eq '/')||(substr($part,1,1) eq '*')) {
							last;
						}
					}
					$val .= " " if length($val);
					$val .= $part;
				}
			} else {
				$val = '<defined>';
			}
			prt( "$line ($def)\n" ) if ($dbg1);
			prt( "$key = $val\n" ) if ($dbg2);
			if (defined $defs1{$key}) {
				$defs1{$key} .= " && ". $val;
			} else {
				$defs1{$key} = $val;
			}
		}
	}
	prt( "\nDoing $in_file2 ... $lncnt2 ...\n" );
	foreach $line (@lines2) {
		chomp $line;
		if ($line =~ /^\s*#\s*define\s+(.*)/) {
			$def = $1;
			@arr = split(/\s/, $def);
			$acnt = scalar @arr;
			$key = $arr[0];
			if ($acnt > 1) {
				$val = '';
				for ($i = 1; $i < $acnt; $i++) {
					$part = trim_all($arr[$i]);
					if ($part =~ /^\//) {
						if ((substr($part,1,1) eq '/')||(substr($part,1,1) eq '*')) {
							last;
						}
					}
					$val .= " " if length($val);
					$val .= $part;
				}
			} else {
				$val = '<defined>';
			}
			prt( "$line ($def)\n" ) if ($dbg1);
			prt( "$key = $val\n" ) if ($dbg2);
			if (defined $defs2{$key}) {
				$defs2{$key} .= " && ". $val;
			} else {
				$defs2{$key} = $val;
			}
		}
	}
}
$cnt1 = scalar keys(%defs1);
$cnt2 = scalar keys(%defs2);
if ($cnt1 && $cnt2) {
	prt( "Comparing $cnt1 from 1, with $cnt2 from 2 ...\n" );
	prt( "\nFound in 1 ($cnt1), not in 2 ($cnt2) ...\n" );
	foreach $key1 (keys %defs1) {
		$val1 = $defs1{$key1};
		$fnd = 0;
		foreach $key2 (keys %defs2) {
			if ($key1 eq $key2) {
				$val2 = $defs2{$key2};
				if ($val1 eq $val2) {
					$fnd = 1;
					last;
				}
			}
		}
		if (!$fnd) {
			prt( "$key1 = $val1\n" );
		}
	}

	prt( "\nFound in 2 ($cnt2), not in 1 ($cnt1) ...\n" );
	foreach $key2 (keys %defs2) {
		$val2 = $defs2{$key2};
		$fnd = 0;
		foreach $key1 (keys %defs1) {
			$val1 = $defs1{$key1};
			if ($key1 eq $key2) {
				if ($val1 eq $val2) {
					$fnd = 1;
					last;
				}
			}
		}
		if (!$fnd) {
			prt( "$key2 = $val2\n" );
		}
	}
}
prt("\n");
close_log($outfile,1);
exit(0);

# eof
