#!/perl -w
# NAME: cmpini.pl
# AIM: Compare 2 INI files, showing same, different and missing items ...
use strict;
use warnings;
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
	my @tmpsp = split(/\\/,$pgmname);
	$pgmname = $tmpsp[-1];
}
my $outfile = "temp.$pgmname.txt";
open_log($outfile);
prt( "$0 ... Hello, World ...\n" );

# debug
my $dbg1 = 0;	# show 	prt( "$tag1=$item1 - DUE SECTION NOT IN 2\n" ) if ($dbg1);

my $in_file1 = "C:\\GTools\\tools\\BglView2\\Bv2-200.ini";
my $in_file2 = "C:\\GTools\\tools\\BglView2\\BglView2.ini";
my ($line1, $line2, $sec1, $sec2, $tag1, $item1, $i1, $i2, $fnd1, $fnd2, $tag2, $item2);
my ($lnnum1, $lnnum2);
my @lines11 = ();
my @lines22 = ();

if (open INF1, "<$in_file1") {
	my @lines1 = <INF1>;
	close INF1;
	if (open INF2, "<$in_file2") {
		my @lines2 = <INF2>;
		close INF2;
		my $fcnt1 = scalar @lines1;
		my $fcnt2 = scalar @lines2;
		prt( "$in_file1 had $fcnt1 lines ...\n" );
		prt( "$in_file2 had $fcnt2 lines ...\n" );
		$lnnum1 = 0;
		foreach $line1 (@lines1) {
			$lnnum1++;
			chomp $line1;
			$line1 = trim_all($line1);
			next if (length($line1) == 0);
			push(@lines11,[$line1, 0, $lnnum1]);
		}
		$lnnum2 = 0;
		foreach $line2 (@lines2) {
			$lnnum2++;
			chomp $line2;
			$line2 = trim_all($line2);
			next if (length($line2) == 0);
			push(@lines22,[$line2, 0, $lnnum2]);
		}
		$fcnt1 = scalar @lines11;
		$fcnt2 = scalar @lines22;
		prt( "Adjusted to $fcnt1, $fcnt2 resp...\n" );
		$fnd1 = -1;
		$lnnum1 = 0;
		for ($i1 = 0; $i1 < $fcnt1; $i1++) {
			$lnnum1 = $lines11[$i1][2];
			$line1 = $lines11[$i1][0];
			if ($line1 =~ /^\[(.+)\]$/) {
				$sec1 = $1;
				prt( "Section [$sec1] ... " );
				$fnd1 = sectionin2($sec1);
				if ($fnd1 == -1) {
					prt( "SECTION NOT FOUND in 2!" );
				} else {
					$lines22[$fnd1][1] = 1;	# show as FOUND
					$lnnum2 = $lines22[$fnd1][2];
				}
				prt("\n");
			} elsif ($line1 =~ /^(.+)=(.+)$/) {
				$tag1 = $1;
				$item1 = $2;
				$fnd2 = itemin2( $tag1, $sec1 );
				if ($fnd1 == -1) {
					if ($fnd2 == -1) {
						prt( "$tag1=$item1 - DUE SECTION NOT IN 2\n" ) if ($dbg1);
					} else {
						$line2 = $lines22[$fnd2][0];
						$lines22[$fnd2][1] = 2;	# mark item matched
						prt( "$tag1=$item1 - DUE SECTION NOT IN 2, but FOUND $line2\n" );
					}
				} else {
					if ($fnd2 == -1) {
						prt( "$tag1=$item1 - ITEM NOT FOUND IN 2\n" );
					} else {
						$line2 = $lines22[$fnd2][0];
						$lnnum2 = $lines22[$fnd2][2];
						$lines22[$fnd2][1] = 3;	# mark as matched
						if ($line2 =~ /^(.+)=(.+)$/) {
							$tag2 = $1;
							$item2 = $2;
							if ($tag1 ne $tag2) {
								prt( "ERROR: FAILED TO GET TAG $tag1 vs $tag2!!!\n" );
							} else {
								if ($item1 eq $item2) {

								} else {
									prt( "DIFF: $tag1 = $item1 vs $item2 ... ($lnnum1/$lnnum2)\n" );
									$lines22[$fnd2][1] = 4;	# mark DIFFERENT
								}
							}
						} else {
							prt( "ERROR: $line2 - WHAT IS THIS!\n" );
						}
					}
				}
			} else {
				prt( "$line1 - WHAT IS THIS?\n" );
			}
		}
		prt( "\nProcessing LIST 2 for non-matched items ...\n" );
		for ($i2 = 0; $i2 < $fcnt2; $i2++) {
			$line2 = $lines22[$i2][0];
			if ($lines22[$i2][1] == 0) {
				$lnnum2 = $lines22[$i2][2];
				prt( "$line2 - NOT FOUND IN 1! ($lnnum2)\n" );
			}
		}
	} else {
		prt( "ERROR: Unable to open $in_file2 ... $! ...\n" );
	}
} else {
	prt( "ERROR: Unable to open $in_file1 ... $! ...\n" );
}

close_log($outfile,1);
exit(0);

sub sectionin2 {
	my ($s) = shift;
	my $sz = scalar @lines22;
	for (my $i = 0; $i < $sz; $i++) {
		my $itm = $lines22[$i][0];
		if ($itm =~ /^\[(.+)\]$/) {
			my $sec = $1;
			if ($sec eq $s) {
				return $i;
			}
		}
	}
	return -1;
}

sub itemin2 {
	my ($t, $s) = @_;
	my $sz = scalar @lines22;
	my $insect = 0;
	for (my $i = 0; $i < $sz; $i++) {
		my $itm = $lines22[$i][0];
		if ($itm =~ /^\[(.+)\]$/) {
			my $sec2 = $1;
			if ($sec2 eq $s) {
				$insect = 1;
			} else {
				$insect = 0;
			}
		} elsif ($itm =~ /^(.+)=(.+)$/) {
			my $tag2 = $1;
			my $item2 = $2;
			if ($tag2 eq $t) {
				if ($insect) {
					return $i;
				}
			}
		}
	}
	return -1;
}

# eof - cmpini.pl
