#!/perl -w
# *NAME* color3.pl
# AIM: To build a COLOR WHEEL in HTML
use strict;
use warnings;
use Math::Trig;

require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $showref = 0; # output the color reference list, and exit
my $outfile = 'temp.'.$0.'.txt';
my $htmfile = 'temp.'.$0.'.htm';
# debug items
my $dbg1 = 0;	# show each is_in_used call
my $dbg2 = 0;	# show paragraph added to table
my $dbg3 = 0;	# list, as text, the standard generated colors
my $dbg4 = 0;	# out debug message, in get_slice()
open_log($outfile);
prt( "$0 ... Hello, World ...\n" );

my ($HF, $msg, $clr);
open $HF, ">$htmfile" or mydie( "ERROR: Unable to open $htmfile ...\n" );

my $t45 = tan(deg2rad(45));
my $at = rad2deg(atan(1));
prt( "tan(45) = $t45 ... atan(1) = $at \n");

# HTML OUTPUT
# ===========
html_begin($HF);
out_color_wheel( $HF, 32 );
#for (my $i = 9; $i < 33; $i++) {
#	out_color_wheel( $HF, $i );
#}
html_end($HF);
# END HTML OUTPUT

close $HF;
system($htmfile);
close_log($outfile,0);
exit(0);

sub html_begin {
	my ($f) = shift;
	print $f <<"EOF";
<html>
<head>
<title>$htmfile</title>
<style type="text/css">
<!-- /* Style Definitions */
body {
margin:1cm 1cm 1cm 1cm;
}
p {
margin:0cm;
padding:0cm
}

-->
</style>

</head>
<body>
<h1>$htmfile</h1>
EOF

}

sub html_end {
	my ($f) = shift;
	print $f <<"EOF";
</body>
</html>
EOF

}


sub floor { ($_[0]<0) ? -int -$_[0]+1 : int $_[0] } 
sub ceil { ($_[0]<0) ?  -int -$_[0] : int $_[0]+1 } 
sub round { ($_[0]>0) ?  int $_[0]+0.5 : int $_[0]-0.5 } 

sub out_of_circle {
	my ($x, $y, $rx, $ry, $rad) = @_;
	my $rval = 0;
	my $xmin = abs($rx);
	my $xmax = $rad + ($rad - abs($rx));
	my $ymin = $rad - abs($ry);
	my $ymax = $rad + abs($ry);
	if (($x < $xmin)||($x > $xmax)||($y < $ymin)||($y > $ymax)) {
		$rval = 1;
	}
	if ($x == 0) {
		prt("\n");
	}
	prt( sprintf("$x,$y %2.2f,%2.2f ", $rx, $ry) );
	prt( sprintf("(%2.2f %2.2f %2.2f %2.2f) ", $xmin, $xmax, $ymin, $ymax) );
	prt( "x < min " ) if ($x < $xmin);
	prt( "x > max " ) if ($x > $xmax);
	prt( "y < min " ) if ($y < $ymin);
	prt( "y > max " ) if ($y > $ymax);
	prt( ($rval ? "Out" : "IN") );
	prt( "\n" );
	return $rval;
}

sub get_bg_color {
	my ($x, $y, $grid, $part) = @_;
	my $max = $grid * $part;
	my $rad = $max / 2;
	my $fact = 256 / ($max - 1);
	my ($r, $g, $b);
	my ($xf, $yf);
	my $cx = $rad - $x;
	my $cy = $rad - $y;
	#my $dx = $cx - $x;
	#my $dy = $y - $cy;
	#my $q = 'quad ';
	my $qn = 0;
	if ($x < $rad) {
		if ($y < $rad) {
			$qn = 1;
		} else {
			$qn = 4;
		}
	} else {
		if ($y < $rad) {
			$qn = 2;
		} else {
			$qn = 3;
		}
	}
	if ($cy == 0) {
		$cy = 0.001;
	}
	my $rang = atan( $cx / $cy );
	my $rx = $rad * sin($rang);
	my $ry = $rad * cos($rang);
	my $out = out_of_circle( $x, $y, $rx, $ry, $rad );
	if ($x == 0) {
		prt("\n");
	}
	prt( "$x,$y cx=$cx,cx=$cx angle=".sprintf("%2.2f",rad2deg($rang))." out=$out\n" );
	
	$r = $g = $b = 0;
	$xf = int($x * $fact);
	$xf = 255 if ($xf >= 256);
	$yf = int($y * $fact);
	$yf = 255 if ($yf >= 256);
	$b = 255 - $xf;
	$g = $xf;
	my $c = '#FFFFFF';
	if ( ! $out ) {
		$c = uc(sprintf("#%2.2x%2.2x%2.2x", $r, $g, $b ));
	}
	return $c;
}



sub out_color_wheel_NO_GOOD {
	my ($f) = shift;
	my $grid = 13;
	my $part = 4;
	my $max = $grid * $part;
	my $msg = '';
	my $hdr = "Color Wheel - $max x $max grid";
	prt( "Out put of $hdr ...\n" );
	print $f "<hr>\n";
	print $f "<h1>$hdr</h1>\n";
	print $f "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" summary=\"$hdr\" width=\"100%\">\n";
	my $cols = 0;
	my $i = 0;
	my $j = 0;
	my ($r, $g, $b);
	my ($hr, $hg, $hb);
	my ($sty);
	for ($i = 0; $i < $max; $i++) {
		print $f "<tr>\n";
		for ($j = 0; $j < $max; $j++) {
			$msg = "<td bgcolor=\"".get_bg_color($j, $i, $grid, $part)."\">";
			if ($j == 0) {
				$msg .= "$i";
			} else {
				$msg .= ".";
			}
			$msg .= "</td>\n";
			print $f $msg;
		}
		print $f "</tr>\n";
	}
	print $f "</table>\n";
}

sub simple_circle {
	my ($i, $x, $y);
	my $rad = 70;
	my $max = pi * 6;
	my $step = 0.03;
	my $cnt = 0;
	my $mrad = sprintf("%2.4f", $max);
	prt( "Gen circle, radius $rad, for 0 to $mrad (6 * pi), step $step ...\n" );
	for ($i = 0; $i < $max; $i += $step)
	{
		$cnt++;
		$x = cos($i) * $rad;
		$y = sin($i) * $rad;
		prt( sprintf("%3d %2.3f x,y = %3.2f,%3.2f ...\n", $cnt, $i, $x, $y ));
	}
}

#-----------------------------
sub hypotenuse {
    my ($sd1, $sd2) = @_;
    return sqrt( ($sd1 ** 2) + ($sd2 ** 2) );
}

#-----------------------------
sub get_angle_radians {
	my ($x, $y, $rad) = @_;
	my ($cx, $cy, $ang);
	if ($x < $rad) {
		$cx = $rad - $x;
	} else {
		$cx = $x - $rad;
	}
	if ($y < $rad) {
		$cy = $rad - $y;
	} else {
		$cy = $y - $rad;
	}
	$cy = 0.001 if ($cy == 0);
	$ang = atan( $cx / $cy );
	return $ang;
}

sub get_angle_degrees {
	my ($x, $y, $rad) = @_;
	return rad2deg(get_angle_radians( $x, $y, $rad ));
}

sub get_hypotenuse {
	my ($x, $y, $rad) = @_;
	my ($cx, $cy, $hyp);
	if ($x < $rad) {
		$cx = $rad - $x;
	} else {
		$cx = $x - $rad;
	}
	if ($y < $rad) {
		$cy = $rad - $y;
	} else {
		$cy = $y - $rad;
	}
	# have a $cx, and $cy, find hypotenuse
	# $hyp = hypotenuse( $cx+1, $cy+1 );
	# $hyp = hypotenuse( $cx+0.1, $cy+0.1 );
	$hyp = hypotenuse( $cx, $cy );
	return $hyp;
}

sub within_circle {
	# x and y reference commence upper left
	my ($x, $y, $rad) = @_;
	my ($hyp, $io);
	$hyp = get_hypotenuse( $x, $y, $rad );
	if ($hyp > $rad) {
		$io = 0;
	} else {
		$io = 1;
	}
	return $io;
}

sub within_circle_rad {
	my ($x, $y, $rad, $rad2) = @_;
	if ( within_circle( $x, $y, $rad ) ) {
		my ($hyp, $io);
		$hyp = get_hypotenuse( $x, $y, $rad );
		if ($hyp > $rad2) {
			$io = 0;
		} else {
			$io = 1;
		}
		return $io;
	}
	return 0;
}

sub does_60_deg_rad_pass {
	my ($x, $y, $rad) = @_;
	my ($a1, $a2, $a3, $a4);
	my $rval = 0;
	$a1 = get_angle_degrees( $x, $y, $rad );
	$a2 = get_angle_degrees( $x+1, $y, $rad );
	$a3 = get_angle_degrees( $x+1, $y+1, $rad );
	$a4 = get_angle_degrees( $x, $y+1, $rad );
	if ($y < $rad) {
		if (($a1 >= 60)&&($a2 <= 60)) {
			$rval++;
		}
		if (($a2 <= 60)&&($a3 >= 60)) {
			$rval++;
		}
		if (($a1 <= 60)&&($a4 >= 60)) {
			$rval++;
		}
		if (($a3 <= 60)&&($a4 >= 60)) {
			$rval++;
		}
	} else {
		if (($a1 >= 60)&&($a2 <= 60)) {
			$rval++;
		}
		if (($a2 >= 60)&&($a3 <= 60)) {
			$rval++;;
		}
		if (($a1 >= 60)&&($a4 <= 60)) {
			$rval++;
		}
		if (($a3 <= 60)&&($a4 >= 60)) {
			$rval++;
		}
	}
#	if (($x == 5)&&($y == 50)) {
#		prt( sprintf( "%d,%d a1=%2.2f a2=%2.2f a3=%2.2f a4=%2.2f %s\n", $x, $y, $a1, $a2, $a3, $a4, ($rval ? "ok" : "NO") ) );
#	}
	return $rval;
}

sub out_color_wheel_OK {
	my ($f, $rad) = @_;
	my ($i, $x, $y, $bg, $ang, $fang, $in1, $in2, $r, $g, $b, $r60, $wh, $twid, $tdw);
	my $diam = $rad * 2;
	my $cnt = 0;
	my $out = 0;
	my $fill = '';
	my $hdr = "Generate grid - $rad x $rad";
	$tdw = 14;
	$twid = $rad * $tdw;
	prt( "$hdr ...\n" );
	print $f "<hr>\n";
	print $f "<h1>$hdr</h1>\n";
	print $f "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" summary=\"$hdr\">\n";
	$bg = '';
	$wh = ' align="center" valign="middle" width="14" height="10"';
	for( $y = 0; $y < $diam+1; $y++ ) {
		printf $f "<tr>\n";
		for ($x = 0; $x < $diam+1; $x++) {
			$r60 = does_60_deg_rad_pass( $x, $y, $rad );
			$ang = get_angle_degrees( $x, $y, $rad );
			$fang = int($ang);
			$in1 = within_circle( $x, $y, $rad );
			$in2 = within_circle_rad( $x, $y, $rad, ($rad / 2));
			if ($in1) {
				# set DEFAULT colors
				if( $in2 ) { 
					$r = 102;	# $bg = ' bgcolor="#666666"';
					$g = 102;
					$b = 102;
				} else {
					$r = 170;	# $bg = ' bgcolor="#AAAAAA"';
					$g = 170;
					$b = 170;
				}
				if ($y < $rad) {
					# upper half - left = BLUE - right = GREEN
					if ($ang == 45) {
						if ($x < $rad) {
							$fill = '4';
						} else {
							$fill = '5';
						}
					} else {
						if ($x < $rad) {
							$fill = 'b';
						} else {
							$fill = 'g';
						}
					}
					if ($r60) {
						if ($x < $rad) {
							$fill = '6';
							if ($in2) {
								$r = 0;
								$g = 0;
								$b = 128;	
							} else {
								$r = 0;
								$g = 0;
								$b = 255;
							}
						} else {
							$fill = '6';
							if ($in2) {
								$r = 0;
								$g = 128;
								$b = 0;
							} else {
								$r = 0;
								$g = 255;
								$b = 0;
							}
						}
					} elsif ( $ang == 0 ) {
						$fill = '0';
						if ($in2) {
							$r = 0;
							$g = 128;
							$b = 128;
						} else {
							$r = 0;
							$g = 255;
							$b = 255;
						}
					} else {
						if ($x < $rad) {
							$fill = 'b';
						} else {
							$fill = 'g';
						}
					}
				} else {
					# lower half = RED  (left = BLUE - right = GREEN)
					if ($ang == 0) {
						$fill = '9';
						if ($in2) {
							$r = 128;
							$g = 0;
							$b = 0;
						} else {
							$r = 255;
							$g = 0;
							$b = 0;
						}
					} elsif ($r60) {
						$fill = '6';
						if ($x < $rad) {
							# left BLUE
							if ($in2) {
								$r = 128;
								$g = 0;
								$b = 102;
							} else {
								$r = 255;
								$g = 0;
								$b = 255;
							}
						} else {
							# right GREEN
							if ($in2) {
								$r = 128;
								$g = 102;
								$b = 0;
							} else {
								$r = 255;
								$g = 255;
								$b = 0;
							}
						}
					} else {
						$fill = 'r';
					}
				}
				###$fill = '<img src="black.gif">';
			} else {
				# OUTSIDE CIRCLE - FILL WHITE ONLY
				$fill = '.';
				$r = 255;	# $bg = ' bgcolor="#FFFFFF"';
				$g = 255;
				$b = 255;
				###$fill = '<img src="white.gif">';
			}
			#$fill .= sprintf("=%2.3f", $ang);
			#$fill .= "<br>$x,$y";
			$bg = ' bgcolor="';
			$bg .= uc(sprintf("#%2.2x%2.2x%2.2x", $r, $g, $b ));
			$bg .= '"';
			printf $f "<td$bg$wh>$fill</td>\n";
		}
		printf $f "</tr>\n";
	}
	print $f "</table>\n";
}


sub get_fill {
	my ($x, $y, $rad, $in1, $in2, $ang, $r60) = @_;
	my $fill = '.';
	if ($in1) {
		if ($y < $rad) {
			# upper half - left = BLUE - right = GREEN
			if ($ang == 45) {
				if ($x < $rad) {
					$fill = '4';
				} else {
					$fill = '5';
				}
			} else {
				if ($x < $rad) {
					$fill = 'b';
				} else {
					$fill = 'g';
				}
			}
			if ($r60) {
				if ($x < $rad) {
					$fill = '6';
				} else {
					$fill = '6';
				}
			} elsif ( $ang == 0 ) {
				$fill = '0';
			} else {
				if ($x < $rad) {
					$fill = 'b';
				} else {
					$fill = 'g';
				}
			}
		} else {
			# lower half = RED  (left = BLUE - right = GREEN)
			if ($ang == 0) {
				$fill = '9';
			} elsif ($r60) {
				$fill = '6';
			} else {
				$fill = 'r';
			}
		}
		###$fill = '<img src="black.gif">';
	}
	##$fill .= sprintf("=%2.3f", $ang);
	##$fill .= "<br>$x,$y";
	return $fill;
}

my $lastmsg = '';
sub get_slice {
	my ($x, $y, $rad, $in1, $in2, $ang, $r60) = @_;
	my ($sli, $hyp, $rad2, $msg);
	$hyp = get_hypotenuse( $x, $y, $rad );
	# FOR OUTSIDE CIRCLE - FILL WHITE ONLY
	$rad2 = $rad / 2;
	$sli = 0;
	$msg = "slice: $x,$y ";
	if ($in1) {
		if ($y < $rad) {
			# upper half - left = BLUE - right = GREEN
			if ($ang < 60) {
				if ($x < $rad) {
					# favour BLUE of BG
					#$r = $g = $b = 0;	# slice 1
					$sli = 1;
					$msg .= "$sli y < rad, ang < 60, x < rad";
				} else {
					# favour GREEN of BG
					#$r = $g = $b = 0;	# slice 2
					$sli = 2;
					$msg .= "$sli y < rad, ang < 60, x >= rad";
				}
			} else {
				if ($x < $rad) {
					# favour BLUE of BR
					#$r = $g = $b = 0;	# slice 6u
					$sli = 6;
					$msg .= "$sli y < rad, ang >= 60, x < rad";
				} else {
					# favour RED of BR
					#$r = $g = $b = 0;	# slice 3u
					$sli = 3;
					$msg .= "$sli y < rad, ang >= 60, x >= rad";
				}
			}
		} else {
			# lower half = RED  (left = BLUE - right = GREEN)
			if ($ang < 60) {
				if ($x < $rad) {
					# favour BLUE of BG
					#$r = $g = $b = 0;	# slice 5
					$sli = 5;
					$msg .= "$sli y >= rad, ang < 60, x < rad";
				} else {
					# favour GREEN of BG
					#$r = $g = $b = 0;	# slice 4
					$sli = 4;
					$msg .= "$sli y >= rad, ang < 60, x >= rad";
				}
			} else {
				if ($x < $rad) {
					# favour BLUE of BR
					#$r = $g = $b = 0;	# slice 6-lower
					$sli = 6;
					$msg .= "$sli y >= rad, ang >= 60, x < rad";
				} else {
					# favour RED of BR
					#$r = $g = $b = 0;	# slice 3-lower
					$sli = 3;
					$msg .= "$sli y >= rad, ang >= 60, x >= rad";
				}
			}
		}
	}
	if ( $dbg4 && (length($msg) > 15) && ($lastmsg ne $msg)) {
		prt( "$msg " . sprintf("ang=%2.2f", $ang )."\n" );
		$lastmsg = $msg;
	}
	return $sli;
}

sub get_color {
	my ($x, $y, $rad, $in1, $in2, $ang, $r60) = @_;
	my ($r, $g, $b, $clr, $hyp, $rad2, $sli);
	my ($fac1, $f1, $fac2, $f2);
	$sli = get_slice( $x, $y, $rad, $in1, $in2, $ang, $r60 );
	$hyp = get_hypotenuse( $x, $y, $rad );
	# FOR OUTSIDE CIRCLE - FILL WHITE ONLY
	$rad2 = $rad / 2;

	$r = 255;	# $bg = ' bgcolor="#FFFFFF"';
	$g = 255;
	$b = 255;
	$clr = '#FFFFFF';
	my $msg = '';
	if ($in1) {
		# set DEFAULT colors
		if( $in2 ) { 
			$r = 102;	# $bg = ' bgcolor="#666666"';
			$g = 102;
			$b = 102;
		} else {
			$r = 170;	# $bg = ' bgcolor="#AAAAAA"';
			$g = 170;
			$b = 170;
		}
		if ($y < $rad) {
			# upper half - left = BLUE - right = GREEN
			if ($r60) {
				if ($x < $rad) {
					if ($in2) {
						# getting darker towards centre
						$r = 0;
						$g = 0;
						$b = 225;	
					} else {
						# gettting lighter toward outside
						$r = 0;
						$g = 0;
						$b = 255;
					}
				} else {
					if ($in2) {
						$r = 0;
						$g = 128;
						$b = 0;
					} else {
						$r = 0;
						$g = 255;
						$b = 0;
					}
				}
			} elsif ( $ang == 0 ) {
				if ($in2) {
					$r = 0;
					$g = 128;
					$b = 128;
				} else {
					$r = 0;
					$g = 255;
					$b = 255;
				}
			} else {
				# this is TOP, so sli 4, 5 do not exist
				if ($rad2 > 1) {
					$fac1 = 256 / ($rad2 - 1);
					$f1 = ($fac1 * $hyp) / 2;
					$f1 = 255 if ($f1 >= 255);
					if ($sli == 0) {
						# out of circle(s)
					} elsif ($sli == 1) {
						# slice 1 = BG favouring B
						# angle 60 - 0
						$fac2 = 256 / 59;
						$f2 = ($fac2 * $ang);
						$f2 = 255 if ($f2 >= 255);
						# want a sequence something like
						# 0000 004477 0055aa 0077ee 2299ff 55aaff 88bbff ccddff ffffff
						if ($hyp < $rad2) {
							# color decline to BLACK
							$r = 0;
							$g = 255 - $f2;
							$b = $f1; # 255 - $f1;
						} else {
							# color increase to WHITE
							$r = 0;
							$g = $f1;
							$b = $f2;
						}
					} elsif ($sli == 2 ) {
						# slice 2 = BG favouring G
						#$r = 0;
						#$g = 255;
						#$b = 102;
					} elsif ($sli == 3 ) {
						# slice 3 = RG favouring G
						#$r = 51;
						#$g = 255;
						#$b = 0;
					} elsif ($sli == 4 ) {
						# slice 4 = RG favouring R
					} elsif ($sli == 5 ) {
						# slice 5 = RB favouring R
					} elsif ($sli == 6 ) {
						# slice 6 = RB favouring B
						#$r = 51;
						#$g = 0;
						#$b = 255;
					}
				}
			}
		} else {
			# lower half = RED  (left = BLUE - right = GREEN)
			if ($ang == 0) {
				if ($in2) {
					$r = 128;
					$g = 0;
					$b = 0;
				} else {
					$r = 255;
					$g = 0;
					$b = 0;
				}
			} elsif ($r60) {
				if ($x < $rad) {
					# left BLUE
					if ($in2) {
						$r = 128;
						$g = 0;
						$b = 102;
					} else {
						$r = 255;
						$g = 0;
						$b = 255;
					}
				} else {
					# right GREEN
					if ($in2) {
						$r = 128;
						$g = 102;
						$b = 0;
					} else {
						$r = 255;
						$g = 255;
						$b = 0;
					}
				}
			} else {
				# this is BOTTOM, so sli 1, 2 do not exist
				if ($sli == 0) {
					# out of circle(s)
				} elsif ($sli == 1) {
					# slice 1 = BG favouring B
				} elsif ($sli == 2 ) {
					# slice 2 = BG favouring G
				} elsif ($sli == 3 ) {
					# slice 3 = RG favouring G
					$r = 102;
					$g = 255;
					$b = 0;
				} elsif ($sli == 4 ) {
					# slice 4 = RG favouring R
					$r = 255;
					$g = 102;
					$b = 0;
				} elsif ($sli == 5 ) {
					# slice 5 = RB favouring R
					$r = 255;
					$g = 0;
					$b = 102;
				} elsif ($sli == 6 ) {
					# slice 6 = RB favouring B
					$r = 102;
					$g = 0;
					$b = 255;
				}
			}
		}	# division TOP and BOTTOM
	} # if WITHIN circle

	$clr = uc(sprintf("#%2.2x%2.2x%2.2x", $r, $g, $b ));
	return $clr;
}


# ############################################################################
# sub out_color_wheel ( htmlfile, radius );
# Out put color wheel in HTML code, using TABLE, each cell another color
#
# see : javascipt/colorwheel.htm, using colorwheel.jpg
# Also sites like : http://www.ficml.org/jemimap/style/color/wheel.html
#
# [n] = slice
#          Turquoise
#         [1]    [2]
#     Blue          Green
#          \       /
#     [6]    Black    [3]
#      Mauve   |   Yellow
#        [5]   |   [4]
#             Red
#
# slice 1 = BG favouring B
# slice 2 = BG favouring G
# slice 3 = RG favouring G
# slice 4 = RG favouring R
# slice 5 = RB favouring R
# slice 6 = RB favouring B
# Each color starts 0, mounts to 255, then others mount until 255,255,255
# ############################################################################
sub out_color_wheel {
	my ($f, $rad) = @_;
	my ($i, $x, $y, $bg, $ang, $in1, $in2, $r60, $wh, $twid, $tdw, $clr, $sli, $hyp);
	my $diam = $rad * 2;
	my $cnt = 0;
	my $out = 0;
	my $fill = '';
	my $hdr = "Generate grid - $rad x $rad";
	$tdw = 14;
	$twid = $rad * $tdw;
	prt( "$hdr ...\n" );
	print $f "<hr>\n";
	print $f "<h1>$hdr</h1>\n";
	print $f "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" summary=\"$hdr\">\n";
	$bg = '';
	$wh = ' align="center" valign="middle" width="14" height="10"';
	for( $y = 0; $y < $diam+1; $y++ ) {
		printf $f "<tr>\n";
		for ($x = 0; $x < $diam+1; $x++) {
			$r60 = does_60_deg_rad_pass( $x, $y, $rad );
			$ang = get_angle_degrees( $x, $y, $rad );
			$in1 = within_circle( $x, $y, $rad );
			$in2 = within_circle_rad( $x, $y, $rad, ($rad / 2));
			$hyp = get_hypotenuse( $x, $y, $rad );
			$fill = get_fill( $x, $y, $rad, $in1, $in2, $ang, $r60);
			$sli = get_slice( $x, $y, $rad, $in1, $in2, $ang, $r60);
			$clr = get_color( $x, $y, $rad, $in1, $in2, $ang, $r60);
			$bg = ' bgcolor="';
			$bg .= $clr;
			$bg .= '"';
			###printf $f "<td$bg$wh>$fill</td>\n";
			#printf $f "<td$bg$wh>$sli</td>\n";
			printf $f "<td$bg$wh>$sli<br>$clr</td>\n";
		}
		printf $f "</tr>\n";
	}
	print $f "</table>\n";
}

# eof - colors3.pl
