#!/Perl
# dir2list.pl
# AIM: Given a 'directory' file input, output a list ...
require "logfile.pl" or die "Unable to load logfile.pl ...\n";
my ($LF);
my $outfile = 'temp.'.$0.'.txt';
if ($0 =~ /^\w{1}:\\.*/) {
	my @tmpsp = split(/\\/,$0);
	$outfile = 'temp.'.($tmpsp[-1]).'.txt';
}
open_log($outfile);
$in_file = shift || "tempdir";
prt( "Processing $in_file ... " );
open IF, "<$in_file" or mydie( "Can not OPEN [$in_file] ... $1 ...\n" );
@in_lines = <IF>;
close IF;
prt( " ".scalar @in_lines." lines ..." );
$gottot = 0;
$line = '02/09/2004  05:13 PM            10,104 Multipad.mak';
##if ($line =~ /^(\d{2}\/\d{2}\/\d{4})\s+(\d{2}:\d{2})\s+(\w{2})\s+([\d,]+)\s+(\w+.*)/) {
##	print "ok\n";
##} else {
##	print "FAILED\n";
##}
@list = ();
@lastlns = ();
foreach $line (@in_lines) {
	###prt( $line );
	chomp $line;
	$line =~ s/\r$//;
	# like 'Directory of F:\GTools\ASM\e'
	if ($gottot) {
		###prt( "$line\n" );
		push(@lastlns, $line) if (length($line));
		$gottot = 0;
	} else {
		if ($line =~ /\s+Directory of (.*)/) {
			$dir = $1;
			##prt( "$dir\n" );
		# like '02/09/2004  05:10 PM             4,301 FindI32.mak'
		##} elsif ($line =~ /^(\d{2}\/\d{2}\/\d{4}).*/) {
		##} elsif ($line =~ /^(\d{2}\/\d{2}\/\d{4})\s+(\d{2}:\d{2})\s+(\w{2})\s+(\d{1}(\d+|,+))\s+(\w+.*)/) {
		##} elsif ($line =~ /^(\d{2}\/\d{2}\/\d{4})\s+(\d{2}:\d{2})\s+(\w{2})\s+(\d+)\s+(\w+.*)/) {
		##} elsif ($line =~ /^(\d{2}\/\d{2}\/\d{4})\s+(\d{2}:\d{2})\s+(\w{2})\s+(\d{1,}(\d|,)+)\s+(\w+.*)/) {
		##} elsif ($line =~ /^(\d{2}\/\d{2}\/\d{4})\s+(\d{2}:\d{2})\s+(\w{2})\s+(\d{1,}\d+|,+)\s+(\w+.*)/) {
		} elsif ($line =~ /^(\d{2}\/\d{2}\/\d{4})\s+(\d{2}:\d{2})\s+(\w{2})\s+([\d,]+)\s+(\w+.*)/) {
			$date = $1;
			$time = $2;
			$ampm = $3;
			$size = $4;
			$name = $5;
			($dy,$mt,$yr) = split('/',$date);
			($hr,$mn) = split(':',$time);
			if ($ampm eq 'PM') {
				$hr += 12;
			}
			$tm = $yr * 365 * 24 * 60;
			$tm += $mt * 30 * 24 * 60;
			$tm += $dy * 24 * 60;
			$tm += $mn * 60;
			###prt( "[$date] [$time] [$ampm] [$size] [$name] [$dir]\n" );
			###prt( "[$dy/$mt/$yr] [$time] [$ampm] [$size] [$name] [$dir]\n" );
			###prt( "$tm [$dy/$mt/$yr] [$hr:$mn] [$ampm] [$size] [$name] [$dir]\n" );
			push(@list, [$tm, $date, $time, $ampm, $size, $name, $dir]);
		#      Total Files Listed:
		} elsif ($line =~ /^\s+Total Files Listed:/) {
			$gottot = 1;
		}
	}
}

$cnt = scalar @list;
prt( "got $cnt files ...\n" );
$minlen = 0;
@slist = sort mycmp_decend @list;
for ($i = 0; $i < $cnt; $i++ ) {
	$name = $slist[$i][5];
	$len = length($name);
	$minlen = $len if ($len > $minlen);
}
for ($i = 0; $i < $cnt; $i++ ) {
	$date = $slist[$i][1];
	$time = $slist[$i][2];
	$ampm = $slist[$i][3];
	$size = $slist[$i][4];
	$name = $slist[$i][5];
	$dir  = $slist[$i][6];
	while (length($size) < 12) {
		$size = ' '.$size;
	}
	while (length($name) < $minlen) {
		$name .= ' ';
	}
	prt( "$date $time $ampm $size $name $dir\n" );

}
$cnt = scalar @lastlns;
for ($i = 0; $i < $cnt; $i++) {
	prt( $lastlns[$i]."\n" );
}
close_log($outfile,1);
unlink $outfile;
exit(0);

sub mycmp_decend {
	$off = 0;
	if (${$a}[$off] < ${$b}[$off]) {
		return 1;
	}
	if (${$a}[$off] > ${$b}[$off]) {
		return -1;
	}
	return 0;
}
