#!/perl -w
# dirbysize.pl
# AIM: Read a file output from the DIR command, and order the files in SIZE
# order ... drop out the pure <DIR> entries ...
# 20061219 - Can NOT use just $0 to get script name, since when directly invoke from
# a command prompt, it becomes C:\GTools\Perl\dirbydate.pl, so added some regex to
# massage the name, and just get the perl script name ... if a DRIVE included /^\w{1}:\\.*/
# AND, to enable it to FIND the logfile.pl, add unshift(@INC, 'C:/GTools/perl');
# OR this can be use lib '/Users/User/perl-lib';, or perl -MC:/GTools/perl -e dirbydate.pl
# and added a $evenspace option ...
# geoff mclane - 28 March, 2007 - geoffmclane.com - based on dirbydate.pl
use strict;
use warnings;
unshift(@INC, 'C:/GTools/perl');
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# options
my $evenspace = 1;
my $maxname = 0;
my $maxsize = 0;
my $loadout = 0;
my $maxlines = 300;	# if greater than ??? lines, $loadout in notepad ...
my $fixtm = 0;
# log file stuff
my ($LF);
my $outfile = 'temp.'.$0.'.txt';
if ($0 =~ /^\w{1}:\\.*/) {
	my @tmpsp = split(/\\/,$0);
	$outfile = 'temp.'.($tmpsp[-1]).'.txt';
}
open_log($outfile);
prt( "$0 ... Hello, World ...\n" );
# debug output
my $dbg01 = 0;	# show each FOLDER as found ...
my $dbg02 = 0;	# show count and bytes as found ...
my $dbg03 = 0;	# show files, as found
my $verb3 = 0;	# show sort compare ...

my $in_file = 'C:\Documents and Settings\Geoff McLane\My Documents\Compaq\Mes Documents\tempall.txt';
#my $in_file = 'templist.txt';
if (@ARGV) {
	$in_file = pop @ARGV;
}
my @filelist = ();
my @sortlist = ();
my $basedir = '';

##################################################
# My particular 'nice number'
sub get_nn($) { # perl nice number nicenum add commas
	my ($n) = shift;
	if (length($n) > 3) {
		my $mod = length($n) % 3;
		my $ret = (($mod > 0) ? substr( $n, 0, $mod ) : '');
		my $mx = int( length($n) / 3 );
		for (my $i = 0; $i < $mx; $i++ ) {
			if (($mod == 0) && ($i == 0)) {
				$ret .= substr( $n, ($mod+(3*$i)), 3 );
			} else {
				$ret .= ',' . substr( $n, ($mod+(3*$i)), 3 );
			}
		}
		return $ret;
	}
	return $n;
}

sub trimall($) {	# version 20061127
	my ($ln) = shift;
	chomp $ln;			# remove CR (\n)
	$ln =~ s/\r$//;		# remove LF (\r)
	$ln =~ s/\t/ /g;	# TAB(s) to a SPACE
	while ($ln =~ /\s\s/) {
		$ln =~ s/\s\s/ /g;	# all double space to SINGLE
	}
	while ($ln =~ /^\s/) {
		$ln = substr($ln,1); # remove all LEADING space
	}
	while ($ln =~ /\s$/) {
		$ln = substr($ln,0, length($ln) - 1); # remove all TRAILING space
	}
	return $ln;
}

sub remdir {
	my ($f) = shift;
	my $b2 = quotemeta($basedir);
	$f =~ s/^$b2\\//; # remove beginning ...
	return $f;
}

# put least first
sub mycmp_ascend2 {	# special - ascend by 2nd component
   if (${$a}[2] < ${$b}[2]) {
      prt( "-[".${$a}[2]."] < [".${$b}[2]."]\n" ) if $verb3;
      return -1;
   }
   if (${$a}[2] > ${$b}[2]) {
      prt( "+[".${$a}[2]."] < [".${$b}[2]."]\n" ) if $verb3;
      return 1;
   }
   prt( "=[".${$a}[2]."] = [".${$b}[2]."]\n" ) if $verb3;
   return 0;
}

sub is_date_entry {
    my (@ar) = @_;
    if (scalar @ar == 3) {
        if (($ar[0] =~ /^\d+$/) && ($ar[1] =~ /^\d+$/) && ($ar[2] =~ /^\d+$/)) {
            return 1;
        }
    }
    return 0;
}
sub is_time_entry {
    my (@ar) = @_;
    if (scalar @ar == 2) {
        if (($ar[0] =~ /^\d+$/)&&($ar[1] =~ /^\d+$/)) {
            return 1;
        }
    }
    return 0;
}


open INF, "<$in_file" or mydie("ERROR: Can NOT open [$in_file] ... $! ...\n" );
my @lines = <INF>;	# slurp it all
close INF;
my $lc = scalar @lines;
prt( "Processing $lc lines from [$in_file] ...\n" );
my $line = '';
my $tln = '';
my $act_folder = '';
$basedir = file_dirname($in_file);
foreach $line (@lines) {
	$tln = trimall($line);
	if (length($tln)) {
		#  Volume in drive C has no label.
		#  Volume Serial Number is D833-AEFA
		if ($line =~ /Volume in drive (.*)/ ) {
			# ignore
		} elsif ($line =~ /Volume Serial Number is (.*)/ ) {
			# ignore
		} elsif ($line =~ /Total Files Listed/ ) {
			# ignore
		} elsif ($line =~ /Directory of (.*)/ ) {
			$act_folder = $1;
			prt( "Folder [$act_folder] ...\n" ) if ($dbg01);
		} elsif ($line =~ /\d+\s+File\(s\)\s+[\d,]+\s+bytes/ ) {
			prt( $line ) if ($dbg02);
		} elsif ($line =~ /\d+\s+Dir\(s\)\s+[\d,]+\s+bytes/ ) {
			prt( $line ) if ($dbg02);
		} else {
			my @arr = split(/\s/, $tln);
			my $ac = scalar @arr;
			my $pchk = 0;
			#prt( $line );
			if ($ac > 3) {
                # from Windows 98 machine
                # ..             <DIR>        01/02/04  16:32 ..
                # IMAGE001 PNG         5 031  01/02/04  16:32 image001.png
                # from XP machine
                # 09/07/2008  19:24    <DIR>          Sue
                # 09/07/2008  19:40            81,061 temp.DirBySize.pl.txt
				if ($arr[2] eq '<DIR>') {
					# ignore
				} else {
					# file names of interest
					my @ar2 = split('/', $arr[0]); # get day/month/year
					my @ar3 = split(':', $arr[1]); # get hour:minutes
                    if (is_date_entry(@ar2) && is_time_entry(@ar3)) {
                        my $sz = $arr[2];
                        my $nm = $arr[3];
                        #if ($fixtm && (($sz eq 'AM')||($sz eq 'PM'))) {
                        if (($sz eq 'AM')||($sz eq 'PM')) {
                            # 12 hour clock - have AM or PM
                            if ($sz eq 'PM') {
                                $ar3[0] += 12;	# bump hour by 12
                                $arr[1] = $ar3[0].':'.$ar3[1];
                            }
                            $sz = $arr[3];
                            $nm = $arr[4];
                            if ($ac > 5) {
                                my $i = 5;
                                while($i < $ac) {
                                    $nm .= ' '.$arr[$i];
                                    $i++;
                                }
                            }
                        } else {
                            # 24 hour clock (no AM/PM)
                            if ($ac > 4) {
                                my $i = 4;
                                while($i < $ac) {
                                    $nm .= ' '.$arr[$i];
                                    $i++;
                                }
                            }
                        }
                        if ((scalar @ar2 == 3)&&(scalar @ar3 == 2)) {
                            my $ft = int($ar2[2].$ar2[1].$ar2[0].$ar3[0].$ar3[1]);
                            if ($evenspace) {	# get maximum lengths
                                $maxname = length($nm) if (length($nm) > $maxname);
                                $maxsize = length($sz) if (length($sz) > $maxsize);
                            }
                            $sz =~ s/,//g; # remove the COMA
                            #                 0     1   2    3            4       5
                            push(@filelist, [$ft, $nm, $sz, $act_folder, $arr[0], $arr[1]]);
                            #prt( "$ft, $nm, $sz, $act_folder $arr[0], $arr[1]\n") if ($dbg03);
                            prt( "$ft, $nm, $sz, $arr[0], $arr[1]\n") if ($dbg03);
                        } else {
                            $pchk = 1;
                        }
                    } else {
                        # first and second NOT DATE and TIME
                        # maybe a Windows 98 listing
                        # IMAGE001 PNG         5 031  01/02/04  16:32 image001.png
                        # MAROC    EXE    72 869 062  09/07/08  18:54 maroc.exe
                        mydie( "EEK: Handling of this just not yet done ;=((\n" );
                    }
				}
			} else {
				$pchk = 1;
			}
			if ($pchk) {
				prt( "CHECK: " );
				for (my $i = 0; $i < $ac; $i++) {
					prt( $arr[$i].' ' );
				}
				prt("\n");
			}

		}
	}
}

my $fc = scalar @filelist;
prt( "Got $fc files ... mxsz=$maxsize mxnm=$maxname ...\n" );
###@sortlist = sort mycmp_decend @filelist;
@sortlist = sort mycmp_ascend2 @filelist;
my $fcs = scalar @sortlist;
$loadout = 1 if ($fcs > $maxlines);	# if greater than ??? lines, $loadout in notepad ...
prt( "Got $fcs sorted files ...\n" );
my $msg = '';
for (my $i = 0; $i < $fcs; $i++) {
	my $reldir = remdir( $sortlist[$i][3] );
	#                   0    1    2    3            4        5 
	# push(@filelist, [$ft, $nm, $sz, $act_folder, $arr[0], $arr[1]]);
	if ($evenspace) {
		my $sz = $sortlist[$i][2];
		$sz = get_nn($sz);
		while (length($sz) < $maxsize) {
			$sz = ' ' . $sz;
		}
		my $nm = $sortlist[$i][1];
		while (length($nm) < $maxname) {
			$nm = ' ' . $nm;
		}
		$msg = $sortlist[$i][4] . ' ' . $sortlist[$i][5] . ' ' . $sz . ' ' . $nm . ' ' . $reldir;
	} else {
		$msg = $sortlist[$i][4] . ' ' . $sortlist[$i][5] . ' ' . $sortlist[$i][1] . ' ' . $reldir;
	}
	prt( "$msg\n" );
}
close_log($outfile,$loadout);
exit(0);

# eof
