#!/Perl
# findap.pl
# AIM: Read FlightGear apt.dat, and list closest airports to a given
# lat and lon ... output $max_cnt in closest order ...
require 'logfile.pl' or die "Error: Unable to locate logfile.pl ...\n";
# log file stuff
my ($LF);
my $outfile = 'temp'.$0.'.txt';
open_log($outfile);
prt( "$0 ... Hello, World ...\n" );
my $lat = 48.89;
my $lon = 2.37;
my $aln = '1';
my $rln = '10';
my $aptdat = 'F:\FG0910-4\apt.txt';
###my $aptdat = 'tempapt.txt';
my $max_cnt = 50;
prt("Loading $aptdat file ...\n");
open IF, "<$aptdat" or mydie("OOPS, failed to open [$aptdat] ... check name and location ...\n");
my @lines = <IF>;
close IF;
my $cnt = scalar @lines;
prt( "Processing $cnt lines from $aptdat for $lat, $lon ...\n" );
my $line = '';
my $apt = '';
my $alat = 0;
my $alon = 0;
my $glat = 0;
my $glon = 0;
my $rlat = 0;
my $rlon = 0;
my $dlat = 0;
my $dlon = 0;
my $diff = 0;
my $rwycnt = 0;
my $icao = '';
my $name = '';
my @aptlist = ();
foreach $line (@lines) {
	chomp $line;
	$line =~ s/\r$//;
	while( $line =~ /\s\s/) {
		$line =~ s/\s\s/ /g;
	}
	###prt("$line\n");
	my @arr = split(/ /,$line);
	if ($line =~ /^$aln\s+/) {
		if (length($apt) && ($rwycnt > 0)) {
			$alat = $glat / $rwycnt;
			$alon = $glon / $rwycnt;
			$dlat = abs( $lat - $alat );
			$dlon = abs( $lon - $alon );
			$diff = int( ($dlat * 10) + ($dlon * 10) );
			my @arr2 = split(/ /,$apt);
			$icao = $arr2[4];
			$name = join(' ', splice(@arr2,5));
			##prt("$diff [$apt] (with $rwycnt runways at [$alat, $alon]) ...\n");
			##prt("$diff [$icao] [$name] ...\n");
			push(@aptlist, [$diff, $icao, $name, $alat, $alon]);
		}
		$apt = $line;
		$rwycnt = 0;
		$glat = 0;
		$glon = 0;
	} elsif ($line =~ /^$rln\s+/) {
		$rlat = $arr[1];
		$rlon = $arr[2];
		###prt( "$line [$rlat, $rlon]\n" );
		$glat += $rlat;
		$glon += $rlon;
		$rwycnt++;
	}
}
		if ($rwycnt > 0) {
			$alat = $glat / $rwycnt;
			$alon = $glon / $rwycnt;
			$dlat = abs( $lat - $alat );
			$dlon = abs( $lon - $alon );
			$diff = int( ($dlat * 10) + ($dlon * 10) );
			my @arr2 = split(/ /,$apt);
			$icao = $arr2[4];
			$name = join(' ', splice(@arr2,5));
			###prt("$diff [$apt] (with $rwycnt runways at [$alat, $alon]) ...\n");
			###prt("$diff [$icao] [$name] ...\n");
			push(@aptlist, [$diff, $icao, $name, $alat, $alon]);
		}

my $acnt = scalar @aptlist;
prt( "Sorting $acnt aiports for $lat, $lon ...\n" );
my @aptsort = sort mycmp_ascend @aptlist;
prt( "Listing $max_cnt aiports for $lat, $lon ...\n" );
if ($acnt > $max_cnt) {
	$acnt = $max_cnt;
}
for (my $i = 0; $i < $acnt; $i++) {
	$diff = $aptsort[$i][0];
	$icao = $aptsort[$i][1];
	$name = $aptsort[$i][2];
	$alat = $aptsort[$i][3];
	$alon = $aptsort[$i][4];
	while (length($icao) < 4) {
		$icao .= ' ';
	}
	$line = $diff;
	while (length($line) < 6) {
		$line = ' '.$line;
	}
	$line .= ' '.$icao.' '.$name.' ('.$alat.','.$alon.')';
	prt("$line\n");
}

close_log($outfile,1);
exit(0);

# put least first
sub mycmp_ascend {
   if (${$a}[0] < ${$b}[0]) {
      prt( "-[".${$a}[0]."] < [".${$b}[0]."]\n" ) if $verb3;
      return -1;
   }
   if (${$a}[0] > ${$b}[0]) {
      prt( "+[".${$a}[0]."] < [".${$b}[0]."]\n" ) if $verb3;
      return 1;
   }
   prt( "=[".${$a}[0]."] < [".${$b}[0]."]\n" ) if $verb3;
   return 0;
}

sub mycmp_decend {
   if (${$a}[0] < ${$b}[0]) {
      prt( "+[".${$a}[0]."] < [".${$b}[0]."]\n" ) if $verb3;
      return 1;
   }
   if (${$a}[0] > ${$b}[0]) {
      prt( "-[".${$a}[0]."] < [".${$b}[0]."]\n" ) if $verb3;
      return -1;
   }
   prt( "=[".${$a}[0]."] < [".${$b}[0]."]\n" ) if $verb3;
   return 0;
}

# eof - findap.pl

