#!/perl -w
# NAME: findinpath.pl
# AIM: Given an input file, find it in the PATH enviroment variable ...
# 05/05/2008 - geoff mclane - http://geoffair.net/mperl
use strict;
use warnings;
use File::stat; # to get the file date and size
use Env qw(PATH);	# for reading PATH environment variable
unshift(@INC, 'C:/GTools/perl');
#require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
#my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
	my @tmpsp = split(/\\/,$pgmname);
	$pgmname = $tmpsp[-1];
}
#my $outfile = "temp.$pgmname.txt";
#open_log($outfile);

my $in_file = 'Perl58.dll';
my $CHKPATH = $ENV{PATH};
#prt( "Check PATH=$CHKPATH ...\n" );
my @patharr = split(';', $CHKPATH);
my @pathfnd = ();
my $path = '';
my $tfind = '';
my $fndcnt = 0;
my $pcnt = scalar @patharr;
my $verbose = 0;
my $debug = 0;

parse_args(@ARGV);

prt( "Checking for [$in_file], in $pcnt PATHs ...\n" );
foreach $path (@patharr) {
	$path = strip_quotes($path);
	if ($path =~ /(\\|\/)$/) {
		$path = substr($path,0,length($path)-1);
	}
	if (length($path)) {
		prt( "$path\n" ) if ($verbose);
		$tfind = $path."\\".$in_file;
		my $sb = stat($tfind);
		if ( -f $tfind) {
			my $dtt = YYYYMMDD($sb->mtime);
			my $sz = get_nn( $sb->size );
			prt( "Found in [$path]\\$in_file, $dtt, $sz bytes\n" );
			push(@pathfnd,$path);
			$fndcnt++;
		}
	}
}
if ($fndcnt == 0) {
	prt( "$in_file NOT FOUND ...\n" );
}

#close_log($outfile,0);
exit(0);

###########################
sub prt {
	my ($txt) = shift;
	print $txt;
}

sub mydie {
	my ($txt) = shift;
	die $txt;
}

sub strip_quotes {
	my ($txt) = shift;
	if (substr($txt,0,1) eq '"') {
		$txt = substr($txt,1);
		if (substr($txt,-1,1) eq '"') {
			$txt = substr($txt,0,length($txt)-1);
		}
	}
	return $txt;
}

sub give_help {
	prt( "Usage: $pgmname [OPTION] filename\n" );
	mydie( "Will attempt to FIND the file name in the path ...\n" );
}

sub parse_args {
	my (@av) = @_;
	my $inf = '';
	while (@av) {
		my $arg = shift @av;
		my $ch = substr($arg,0,1);
		if (($ch eq '-')||($ch eq '/')) {
			$ch = uc(substr($arg,1,1));
			if ($ch eq '?') {
				give_help();
			} elsif ($ch eq 'V') {
				$verbose = 1;
			} else {
				prt( "ERROR: Unknown argument [$arg]!\n" );
				give_help();
			}
		} else {
			if (length($inf)) {
				prt( "ERROR: Only find one at a time ... already have $inf, now $arg ...\n" );
				give_help();
			} else {
				$inf = $arg;
			}
		}
	}
	if (length($inf)) {
		$in_file = $inf;
	} elsif ( !$debug ) {
		prt( "ERROR: No input file found ...\n" );
		give_help();
	}
}

# My particular time 'translation' - replaced date_string
sub YYYYMMDD {
	#  0    1    2     3     4    5     6     7     8
	my ($tm) = shift;
    my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime($tm);
	$year += 1900;
	$mon += 1;
	my $ymd = "$year/";
	if ($mon < 10) {
		$ymd .= '0'.$mon.'/';
	} else {
		$ymd .= "$mon/";
	}
	if ($mday < 10) {
		$ymd .= '0'.$mday;
	} else {
		$ymd .= "$mday";
	}
	return $ymd;
}

# My particular 'nice number'
sub get_nn { # perl nice number nicenum add commas
	my ($n) = shift;
	if (length($n) > 3) {
		my $mod = length($n) % 3;
		my $ret = (($mod > 0) ? substr( $n, 0, $mod ) : '');
		my $mx = int( length($n) / 3 );
		for (my $i = 0; $i < $mx; $i++ ) {
			if (($mod == 0) && ($i == 0)) {
				$ret .= substr( $n, ($mod+(3*$i)), 3 );
			} else {
				$ret .= ',' . substr( $n, ($mod+(3*$i)), 3 );
			}
		}
		return $ret;
	}
	return $n;
}


# eof
