#!/perl -w
# NAME: genfileindex.pl (see also genfolderindex.pl)
# AIM: Scan all the files in a FOLDER, and generate a HTML index file,
# containing links to all the files in the FOLDER, both in alphabetic order,
# and in date order, showing the date, name and size of the file.
# 21/08/2007 - use ImageMagick 'indentify.exe' (now installed) to get the IMAGE sizes,
# thus improving the bottom image display ...
#
# 28/06/2007  geoff mclane - geoffair.net/mperl
#
use strict;
use warnings;
use File::Basename;
use File::stat; # to get the file date
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
	my @tmpsp = split(/\\/,$pgmname);
	$pgmname = $tmpsp[-1];
}
my $outfile = 'temp.'.$pgmname.'.txt';
open_log($outfile);
prt( "$0 ... Hello, World ...\n" );
my $in_folder = 'C:\Documents and Settings\Geoff McLane\My Documents\Uwe\imgs1';
###my $in_folder = 'C:\Documents and Settings\Geoff McLane\My Documents\MISC\HKFlat';
###my $in_folder = 'C:\Documents and Settings\Geoff McLane\My Documents\tidy';
###my $in_folder = 'C:\Documents and Settings\Geoff McLane\My Documents\Hommage';
my $out_file = 'fileindex.htm';
my $out_path = $in_folder."\\".$out_file;
my $minimage = 1;	# adjust $targwid to less, if no images exceed it.
my $targwid = 200;

my $overwrite = 1;
my $recursive = 1;
my $writesubs = 1;
my $makelinkblank = 1;	# use target="_blank"
my $addcattable = 1;	# group by extension
my $simplelinks = 1;	# links in one line
my $adddate = 1;
my $addsize = 1;
my $adjusttd = 1;

my $maxlines = 20; # was 22 =# put a LINK line
my $imgSx = 0;
my $imgSy = 0;

my @html_ext = qw( .htm .html .shtml .php );
###my @graf_ext = qw( .jpg .jpeg .gif .png .bmp .ico .mpg .tif ); # BUT browser does NOT display TIF
my @graf_ext = qw( .jpg .jpeg .gif .png .bmp .ico .mpg );
my @special_ext = qw( .tif );
my @css_ext  = qw( .css );
my @script_ext = qw( .js .class .cgi );
my @docs_ext = qw( .doc .txt .bat );

my @fpfolders = qw( _vti_cnf _vti_pvt _private _derived );

my @skipped = ();
my @in_counts = ( 0, 0, 0, 0, 0, 0, 0, 0 );

my @in_files = ();
# @in_files offsets
my $if_fnm = 0;	# file name
my $if_dir = 1;	# directory
my $if_ext = 2;	# extension type
my $if_siz = 3;	# size
my $if_dat = 4;	# date/time
my $if_lev = 5;	# level
my $if_rel = 6;	# relative
my $if_isz = 7;	# images SIZE
my $if_ffn = 8;	# FULL FILE NAME

my %file_types = ();	# list via file TYPE, per folder, as 'folder*extension' => file list, '*' separated

# extension types
my $ex_unk = 0;	# uncased extension
my $ex_htm = 1;	# htm, html, ...
my $ex_grf = 2;	# jpg, gif, ...
my $ex_zip = 3;	# zip
my $ex_css = 4;	# css
my $ex_txt = 5;	# text file
my $ex_doc = 6;	# word doc
my $ex_scr = 7;	# script file
my $ex_spl = 8; # special file, like TIF

# DEBUG
my $dbg1 = 1;	# show folder being scanned
my $dbg2 = 0;	# show what we GOT, as it is got ...
my $dbg3 = 1;	# show SKIPPED files.

# HTML stuff
my $m_doctype = '<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"'."\n".
'"http://www.w3.org/TR/html4/loose.dtd">';
my $def_tdattr = "align=\"center\" valign=\"center\"";
my $href = 'href';
if ($makelinkblank) {
	$href = 'target="_blank" href';
}
if (-f $out_path) {
	if (!$overwrite) {
		mydie( "WARNING: $out_file already exists in $in_folder ... DELETE OR RENAME first ...\n" );
	}
}
if (! -d $in_folder) {
	mydie( "WARNING: $in_folder DOES NOT EXIST ...\n" );
}

scan_folder( $in_folder, 0, "" );
my $cnt = scalar @in_files;
prt( "Got $cnt files ... " );
my $num = 0;
foreach $cnt (@in_counts) {
	prt( "$num $cnt " );
	$num++;
}
prt("\n");

if (gen_findex($out_path)) {
	system($out_path);
}
if (@skipped && $dbg3) {
	prt( "WARNING: Skipped following ". scalar @skipped." FILES found ...\n" );
	foreach my $sk (@skipped) {
		prt( "$sk\n" );
	}
}

close_log($outfile,$dbg3);
exit(0);

#########################################################
# Passed an array of extensions,
# check if this is one of them?
#########################################################
sub is_my_ext {
	my ($fil, @exts) = @_;
	my ($nm,$dir,$ext) = fileparse( $fil, qr/\.[^.]*/ );
	foreach my $ex (@exts) {
		if (lc($ex) eq lc($ext)) {
			return 1;
		}
	}
	return 0;
}

############################################
# only looking for HTM, HTML, PHP,
# could be extended to others maybe ...
############################################
sub is_htm_ext {
	my ($fil) = shift;
	return( is_my_ext($fil, @html_ext) );
}
sub is_graphic_ext {
	my ($fil) = shift;
	return( is_my_ext($fil, @graf_ext) );
}
sub is_zip_ext {
	my ($fil) = shift;
	my @arr = qw( .zip );
	return( is_my_ext($fil, @arr) );
}
sub is_css_ext {
	my ($fil) = shift;
	return( is_my_ext($fil, @css_ext) );
}
sub is_txt_ext {
	my ($fil) = shift;
	my @arr = qw( .txt .htm .html .csv );
	return( is_my_ext($fil, @arr) );
}
sub is_doc_ext {
	my ($fil) = shift;
	my @arr = qw( .doc .pdf .xls .wmv );
	return( is_my_ext($fil, @arr) );
}
sub is_script_ext {
	my ($fil) = shift;
	return( is_my_ext($fil, @script_ext) );
}
sub is_special_ext {
	my ($fil) = shift;
	return( is_my_ext($fil, @special_ext) ); # like TIF - is graphic but NOT browser supported
}

# extension types
#my $ex_unk = 0;	# uncased extension
#my $ex_htm = 1;	# htm, html, ...
#my $ex_grf = 2;	# jpg, gif, ...
#my $ex_zip = 3;	# zip
#my $ex_css = 4;	# css
#my $ex_txt = 5;	# text file
#my $ex_doc = 6;	# word doc
#my $ex_scr = 7;	# script file
#my $ex_spl = 8;	# special file, like TIF
sub get_ext_type {
	my ($fil) = shift;
	if (is_htm_ext($fil)) {
		return $ex_htm;
	} elsif (is_graphic_ext($fil)) {
		return $ex_grf;
	} elsif (is_zip_ext($fil)) {
		return $ex_zip;
	} elsif (is_css_ext($fil)) {
		return $ex_css;
	} elsif (is_txt_ext($fil)) {
		return $ex_txt;
	} elsif (is_doc_ext($fil)) {
		return $ex_doc;
	} elsif (is_script_ext($fil)) {
		return $ex_scr;
	} elsif (is_special_ext($fil)) {
		return $ex_spl;
	}
	return $ex_unk;
}

sub scan_folder {
	my ($inf, $lev, $rel) = @_;
	prt( "Processing $inf folder ... Lev $lev, Rel [$rel]\n" ) if ($dbg1);
	my ($relkey, $relfil);
	if ( opendir( DIR, $inf ) ) {
		my @files = readdir(DIR);
		closedir DIR;
		foreach my $fil (@files) {
			if (($fil eq ".")||($fil eq "..")) {
				next;
			}
			my $ff = $inf."\\".$fil;
			my $msg = "NOT FOLDER OR FILE!!!";
			if ( -d $ff) {
				$msg = "FOLDER";
			} elsif ( -f $ff ) {
				$msg = "FILE";
			}
			prt( "Got [$fil] [$ff] ... $msg\n" ) if ($dbg2);
			if ( -d $ff ) {
				if ($recursive && !is_fp_folder($fil) ) {
					my $nrel = $fil;
					if (length($rel)) {
						$nrel = $rel."\\".$fil;
					}
					scan_folder( $ff, ($lev + 1), $nrel );
				}
			} elsif ( -f $ff ) {
				if (($fil =~ /^temp/i)||($fil =~ /^~\$/)||($fil eq $out_file)) {
					next;	# ignore TEMP???..., ~$???..., and fileindex.htm files ...
				}
				my $exn = get_ext_type($fil);
				my ($nm,$dir,$ext) = fileparse( $fil, qr/\.[^.]*/ );
				$relfil = $fil;
				if (length($rel)) {
					$relkey = $rel.'*'.lc($ext);
				} else {
					$relkey = '.*'.lc($ext);
				}
				###if (($exn == 2)||($exn == 3)||($exn == 5)||($exn == 6)) {
				if ($exn > 0) {
					my $sb = stat($ff);
					my $in_size = $sb->size;
					my $in_date = $sb->mtime; # keep DATE unchanged, so a SORT can be done
					my $isz = '';
					$isz = get_image_size($ff) if ($exn == $ex_grf);
					# my $if_        fnm   dir   ext   siz       dat       lev   rel   isz   ffn
					#                0     1     2     3         4         5     6     7     8
					push(@in_files, [$fil, $inf, $exn, $in_size, $in_date, $lev, $rel, $isz, $ff]);
					if ($exn < scalar @in_counts) {
						$in_counts[$exn]++;
					}
					#my %file_types = (); # list via file TYPE, per folder, as 'folder*extension' => file list, '*' separated
					if (defined $file_types{$relkey}) {
						$file_types{$relkey} .= '*'.$relfil;
					} else {
						$file_types{$relkey} = $relfil;
					}
				} else {
					$in_counts[$exn]++;
					push(@skipped, $ff);
				}
			} else {
				prt( "WARNING: CHECK ME: NOT DIR OR FILE [$ff] - WHAT IS THIS?\n" );
			}
		}
	} else {
		prt( "ERROR: FAILED TO OPEN [$inf] ... $! ...\n" );
	}
}

sub add_link_line {
	my ($fl, $val) = @_;
	print $fl "<span class=\"smfnt\">";
	print $fl "<a href=\"#bm_top\">top</a> \n" if ($val != 1);
	print $fl "<a href=\"#files\">files</a> \n" if ($val != 2);
	print $fl "<a href=\"#images\">images</a> \n" if ($val != 3);
	print $fl "<a href=\"#extension\">exts</a> \n" if ($addcattable);
	print $fl "<a href=\"#links\">subs</a> \n" if ($val != 5);
	print $fl "<a href=\"#bm_end\">end</a> \n" if ($val != 4);
	print $fl "</span>\n";
}

sub add_sub_table {
	my ($f, $sub) = @_;
	my ($i, $fil, $dir, $exn, $sz, $tm, $lev, $rel, $nfil);
	my $icnt = scalar @in_files;
	if ($icnt == 0) {
		print $f "<p><a name=\"files\"\n";
		print $f "   id=\"files\"></a>NO FILES in [$in_folder/$sub]!</p>\n";
		return;
	}
	my $imgcnt = 0;
	my $lnkcnt = 0;
	print $f "<p><a name=\"files\"\n";
	print $f "   id=\"files\"></a>Files in [$in_folder/$sub] are :-</p>\n";
	print $f "\n<table align=\"center\" border=\"1\" summary=\"list of files\">\n";
	print $f "<tr>\n";
	print $f "<th class=\"ctr\">Name</th>\n";
	print $f "<th class=\"ctr\">Date</th>\n";
	print $f "<th class=\"ctr\">Size</th>\n";
	print $f "</tr>\n\n";
	for ($i = 0; $i < $icnt; $i++) {
		# my $if_          fnm   dir   ext   siz       dat       lev   rel   isz   ffn
		# push(@in_files, [$fil, $inf, $exn, $in_size, $in_date, $lev, $rel, $isz, $ff]);
		$fil = $in_files[$i][$if_fnm];
		$dir = $in_files[$i][$if_dir];
		$exn = $in_files[$i][$if_ext];
		$sz = get_nn($in_files[$i][$if_siz]);
		$tm = YYYYMMDD($in_files[$i][$if_dat]);
		$lev = $in_files[$i][$if_lev];
		$rel = $in_files[$i][$if_rel];
		if ($rel ne $sub) {
			next;
		}
		print $f "<tr>\n";
		$nfil = $fil;
		#if (length($rel)) {
		#	$nfil = $rel.'/'.$fil;
		#}
		print $f "<td><a $href=\"$nfil\">$nfil</a></td>\n";
		print $f "<td>$tm</td>\n";
		print $f "<td align=\"right\">$sz</td>\n";
		print $f "</tr>\n\n";
		$imgcnt++ if ($exn == $ex_grf);
		$lnkcnt++;
		if ($lnkcnt > $maxlines) {
			if (($icnt - $i) > $maxlines) {
				print $f "<tr>\n";
				print $f "<td colspan=\"3\" align=\"center\">";
				add_link_line($f, 0);
				print $f "</td>\n";
				print $f "</tr>\n\n";
			}
			$lnkcnt = 0;
		}
	}
	print $f "</table>\n";

	if ($imgcnt) {
		print $f "\n<p align=\"center\">";
		add_link_line($f, 3);
		print $f "</p>\n";

		print $f "\n<p><a name=\"images\"\n";
		print $f "   id=\"images\"></a>Table of $imgcnt IMAGE files.</p>\n";

		print $f "\n<table align=\"center\" border=\"1\" summary=\"table of image\">\n";
		print $f "<tr>\n";
		print $f "<th class=\"ctr\">Image</th>\n";
		print $f "<th class=\"ctr\">Name</th>\n";
		if ($adddate) {
			print $f "<th class=\"ctr\">Date</th>\n";
		}
		if ($addsize) {
			print $f "<th class=\"ctr\">Size</th>\n";
		}
		print $f "</tr>\n\n";
		for ($i = 0; $i < $icnt; $i++) {
			# my $if_          fnm   dir   ext   siz       dat       lev   rel   isz   ffn
			# push(@in_files, [$fil, $inf, $exn, $in_size, $in_date, $lev, $rel, $isz, $ff]);
			$fil = $in_files[$i][$if_fnm];
			$dir = $in_files[$i][$if_dir];
			$exn = $in_files[$i][$if_ext];
			$sz = get_nn($in_files[$i][$if_siz]);
			$tm = YYYYMMDD($in_files[$i][$if_dat]);
			$lev = $in_files[$i][$if_lev];
			$rel = $in_files[$i][$if_rel];
			if ($rel ne $sub) {
				next;
			}
			if ($exn == $ex_grf) {
				# GRAPHIC FILE
				print $f "<tr>\n";
				$nfil = $fil;
				#if (length($rel)) {
				#	$nfil = $rel.'/'.$fil;
				#}
				my $tdattr = "width=\"$targwid\" height=\"$targwid\"";
				my $attr = $tdattr;
				$tdattr .= " $def_tdattr";
				my $isz = $in_files[$i][$if_isz];
				my $iw = get_image_width($isz);
				my $ih = get_image_height($isz);
				if (($iw > 0) && ($ih > 0)) {
					if (($iw > $targwid) || ($ih > $targwid)) {
						my $ratio = $iw / $ih;
						if($ratio > 1) {
							$imgSx = $targwid;
							$imgSy = int( ($targwid / $ratio) + 0.5 );
						} else {
							$imgSx = int( ($targwid * $ratio) + 0.5 );
							$imgSy = $targwid;
						}
						$attr = "width=\"$imgSx\" height=\"$imgSy\"";
					} else {
						$attr = "width=\"$iw\" height=\"$ih\"";
					}
				}
				print $f "<td $tdattr><a $href=\"$nfil\"><img src=\"$nfil\" $attr></a></td>\n";
				print $f "<td align=\"center\"><a href=\"$nfil\">$nfil</a>\n";
				print $f "<br>\n";
				print $f "$isz\n";
				print $f "<br>\n";
				add_link_line($f, 0);
				print $f "</td>\n";
				if ($adddate) {
					print $f "<td>$tm</td>\n";
				}
				if ($addsize) {
					print $f "<td align=\"right\">$sz</td>\n";
				}
				print $f "</tr>\n\n";
			}
		}
		print $f "</table>\n\n";
	} else {
		print $f "\n<p><a name=\"images\"\n";
		print $f "   id=\"images\"></a>No IMAGE files found!</p>\n";
	}
}

sub add_file_table {
	my ($f) = shift;
	my $icnt = scalar @in_files;
	my ($i, $fil, $dir, $exn, $sz, $tm, $lev, $rel, $nfil);
	if ($icnt == 0) {
		print $f "<p><a name=\"files\"\n";
		print $f "   id=\"files\"></a>NO FILES in [$in_folder]!</p>\n";
		return;
	}
	my $imgcnt = 0;
	my $lnkcnt = 0;
	print $f "<p><a name=\"files\"\n";
	print $f "   id=\"files\"></a>Files in [$in_folder] are :-</p>\n";
	###print $f "<p>Files in [$in_folder] are :-</p>\n";
	print $f "\n<table align=\"center\" border=\"1\" summary=\"list of files\">\n";
	print $f "<tr>\n";
	print $f "<th class=\"ctr\">Name</th>\n";
	if ($adddate) {
		print $f "<th class=\"ctr\">Date</th>\n";
	}
	if ($addsize) {
		print $f "<th class=\"ctr\">Size</th>\n";
	}
	print $f "</tr>\n\n";
	for ($i = 0; $i < $icnt; $i++) {
		# my $if_          fnm   dir   ext   siz       dat       lev   rel   isz   ffn
		# push(@in_files, [$fil, $inf, $exn, $in_size, $in_date, $lev, $rel, $isz, $ff]);
		$fil = $in_files[$i][$if_fnm];
		$dir = $in_files[$i][$if_dir];
		$exn = $in_files[$i][$if_ext];
		$sz = get_nn($in_files[$i][$if_siz]);
		$tm = YYYYMMDD($in_files[$i][$if_dat]);
		$lev = $in_files[$i][$if_lev];
		$rel = $in_files[$i][$if_rel];
		$imgcnt++ if ($exn == $ex_grf);
		$lnkcnt++;
		print $f "<tr>\n";
		$nfil = $fil;
		if (length($rel)) {
			$nfil = $rel.'/'.$fil;
		}
		print $f "<td><a $href=\"$nfil\">$nfil</a></td>\n";
		if ($adddate) {
			print $f "<td>$tm</td>\n";
		}
		if ($addsize) {
			print $f "<td align=\"right\">$sz</td>\n";
		}
		print $f "</tr>\n\n";
		if ($lnkcnt > $maxlines) {
			if (($icnt - $i) > $maxlines) {
				print $f "<tr>\n";
				print $f "<td colspan=\"3\" align=\"center\">";
				add_link_line($f, 0);
				print $f "</td>\n";
				print $f "</tr>\n\n";
			}
			$lnkcnt = 0;
		}
	}
	print $f "</table>\n";

	if ($imgcnt) {
		print $f "<p align=\"center\">";
		add_link_line($f, 3);	# no images link
		print $f "</p>\n";
		print $f "<hr>\n";
		print $f "\n<a name=\"images\"\n";
		print $f "   id=\"images\"></a>\n";
		print $f "<p><b>Table of $imgcnt IMAGE files.</b></p>\n";
		print $f "\n<table align=\"center\" border=\"1\" summary=\"table of image\">\n";
		print $f "<tr>\n";
		print $f "<th class=\"ctr\">Image</th>\n";
		print $f "<th class=\"ctr\">Name</th>\n";
		if ($adddate) {
			print $f "<th class=\"ctr\">Date</th>\n";
		}
		if ($addsize) {
			print $f "<th class=\"ctr\">Size</th>\n";
		}
		print $f "</tr>\n\n";
		for ($i = 0; $i < $icnt; $i++) {
			# my $if_          fnm   dir   ext   siz       dat       lev   rel   isz   ffn
			# push(@in_files, [$fil, $inf, $exn, $in_size, $in_date, $lev, $rel, $isz, $ff]);
			$fil = $in_files[$i][$if_fnm];
			$dir = $in_files[$i][$if_dir];
			$exn = $in_files[$i][$if_ext];
			$sz = get_nn($in_files[$i][$if_siz]);
			$tm = YYYYMMDD($in_files[$i][$if_dat]);
			$lev = $in_files[$i][$if_lev];
			$rel = $in_files[$i][$if_rel];
			if ($exn == $ex_grf) {
				# GRAPHIC FILE
				print $f "<tr>\n";
				$nfil = $fil;
				if (length($rel)) {
					$nfil = $rel.'/'.$fil;
				}
				my $tdattr = "width=\"$targwid\" height=\"$targwid\"";
				my $attr = $tdattr;
				$tdattr .= " $def_tdattr";
				my $isz = $in_files[$i][$if_isz];
				my $iw = get_image_width($isz);
				my $ih = get_image_height($isz);
				if (($iw > 0) && ($ih > 0)) {
					if (($iw > $targwid) || ($ih > $targwid)) {
						my $ratio = $iw / $ih;
						if($ratio > 1) {
							$imgSx = $targwid;
							$imgSy = int( ($targwid / $ratio) + 0.5 );
						} else {
							$imgSx = int( ($targwid * $ratio) + 0.5 );
							$imgSy = $targwid;
						}
						###$attr = "width=\"$imgSx\" height=\"$imgSy\"";
					} else {
						$imgSx = $iw;
						$imgSy = $ih;
						###$attr = "width=\"$iw\" height=\"$ih\"";
					}
					$attr = "width=\"$imgSx\" height=\"$imgSy\"";
					if ($adjusttd) {
						$tdattr = $attr;
						$tdattr .= " $def_tdattr";
					}
				}
				print $f "<td $tdattr><a href=\"$nfil\"><img src=\"$nfil\" $attr></a></td>\n";
				print $f "<td align=\"center\"><a $href=\"$nfil\">$nfil</a>\n";
				print $f "<br>\n";
				print $f "$isz\n";
				print $f "<br>\n";
				add_link_line($f, 0);
				print $f "</td>\n";
				if ($adddate) {
					print $f "<td>$tm</td>\n";
				}
				if ($addsize) {
					print $f "<td align=\"right\">$sz</td>\n";
				}
				print $f "</tr>\n\n";
			}
		}
		print $f "</table>\n\n";
	} else {
		print $f "\n<p><a name=\"images\"\n";
		print $f "   id=\"images\"></a>No IMAGE files found!</p>\n";
	}
}

sub write_html_head { # ($OF)
	my ($f) = shift;
	print $f "$m_doctype\n";
	print $f <<"EOF";
<html>
 <head>
  <title>
  Index to Files
  </title>
  <meta http-equiv="Content-Language" content="en-au">
  <meta http-equiv="Content-Type" content="text/html; charset=windows-1252">
  <style type="text/css">
<!-- /* Style Definitions */
  body {
  margin: 0cm 1cm 1cm 1cm;
  background: #efefff;
  text-align: justify;
  }
  h1 {
  background:#dfdfff;
  border-style: solid solid solid solid;
  border-color:#d9e2e2;
  border-width:1px;
  padding:2px 2px 2px 2px;
  font-size:200%;
  text-align:center;
  }
  .ctr { text-align: center; }
  .cn { font-family : "Courier New"; } 
  hr.mini { 
  margin : 0;
  border-style : none;
  padding : 0;
  width : 20%;
  text-align : center;
  }  
  p.top { 
  margin : 0;
  border-style : none;
  padding : 0;
  text-align : center;
  }
  .smfnt {
  font-size : small;
  }
  -->
</style>

 </head>

 <body>
 <h1 align="center"><a name="bm_top"
    id="bm_top"></a>Index to Files</h1>

EOF

	print $f "<p align=\"center\">";
	add_link_line($f, 1);
	print $f "</p>\n\n";

}

sub write_html_tail {	# ($OF);
	my ($f, $of) = @_;
	my ($msg);

	print $f <<"TEOF";

<p><a name="bm_end"
   id="bm_end">EOF - $of
</p>

TEOF

	print $f "<p align=\"center\">";
	add_link_line($f, 4);
	print $f "</p>\n\n";

	$msg = "<!-- generated by $pgmname on " . localtime(time()) . " -->\n";
	print $f $msg;

	print $f "</body>\n";
	print $f "</html>\n";
}


sub gen_sub_index {
	my ($rel, $lev) = @_;
	my $out = $in_folder."\\".$rel.'/'.$out_file;	# = 'fileindex.htm';
	my ($OUTF, $msg);
	if (!open $OUTF, ">$out") {
		prt( "WARNING: Failed to create [$out] ...\n" );
		return 0;	# quietly ignore failure
	}

	write_html_head($OUTF);

	add_sub_table($OUTF, $rel);

	add_type_table($OUTF, $rel) if ($addcattable);

	# add a RETURN to INDEX
	$msg = '';
	while ($lev) {
		$msg .= '/' if (length($msg));
		$msg .= '..';
		$lev--;
	}
	$msg .= '/' if (length($msg));
	$msg .= $out_file;
	print $OUTF "  <p align=\"center\"><a name=\"links\"\n  id=\"links\">\n   <a href=\"$msg\">$msg</a></p>\n";

	write_html_tail($OUTF, $out);

	close $OUTF;
	return 1;
}

sub in_list {
	my ($itm, @list) = @_;
	foreach my $it (@list) {
		if ($itm eq $it) {
			return 1;
		}
	}
	return 0;
}

# if ($addcattable) - process 
# my %file_types = ();	# list via file TYPE, per folder, as 'folder*extension' => file list, '*' separated
sub	add_type_table {
	my ($of, $actfld) = @_;
	my ($key, $fld, $ext, $flist, @files, $file, $cnt, $acnt, $wcnt);
	my @ar = ();
	$cnt = 0;
	foreach $key (keys %file_types) {
		@ar = split(/\*/,$key);
		$fld = $ar[0];
		if ($fld eq $actfld) {
			$cnt++;
		}
	}
	print $of "<hr>\n";
	print $of "<a name=\"extension\"\n  id=\"extension\"></a>\n";
	print $of "<p><b>File list by extension</b> - Count: $cnt types.\n";
	if ($cnt) {
		$cnt = 0;
		foreach $key (sort keys(%file_types)) {
			@ar = split(/\*/,$key);
			$fld = $ar[0];
			if ($fld eq $actfld) {
				$cnt++;
				$ext = $ar[1];
				$flist = $file_types{$key};
				@files = split(/\*/,$flist);
				$acnt = "$cnt";
				$wcnt = $acnt;
				while (length($acnt) < 4) {
					$acnt .= ' ';
					$wcnt .= '&nbsp;';
				}
				print $of "<br>$wcnt <b>$ext</b> = \n";
				foreach $file (sort @files) {
					print $of " [<a $href=\"$file\">$file</a>]\n";
				}
			}
		}
	} else {
		print $of " COUNT IS ZERO!";
	}
	print $of "</p>\n";
}

sub gen_findex {
	my ($of) = shift;
	my $icnt = scalar @in_files;
	my ($msg);
	my $scnt = 0;
	my $dcnt = 0;
	my @subs = ();
	my ($i, $lev, $rel, $isz, $iw, $ih, $exn, $max);

	if ($icnt == 0) {
		prt( "No index, since NO FILES ...\n" );
		return 0;
	}
	if ($minimage) {	# adjust $targwid to less, if no images exceed it.
		$max = 0;
		for ($i = 0; $i < $icnt; $i++) {
			$exn = $in_files[$i][$if_ext];
			if ($exn == $ex_grf) {
				$isz = $in_files[$i][$if_isz];
				$iw = get_image_width($isz);
				$ih = get_image_height($isz);
				if( ( $iw > $targwid ) || ( $ih > $targwid ) ) {
					$max = 0;
					last;
				}
				$max = $iw if ($iw > $max);
				$max = $ih if ($ih > $max);
			}
		}
		if ($max > 0) {
			$targwid = $max;
		}
	}

	if ($writesubs) {
		for ($i = 0; $i < $icnt; $i++) {
			#                  0     1     2     3         4         5     6
			# my $if_          fnm   dir   ext   siz       dat       lev   rel   isz   ffn
			# push(@in_files, [$fil, $inf, $exn, $in_size, $in_date, $lev, $rel, $isz, $ff]);
			$lev = $in_files[$i][$if_lev];
			$rel = $in_files[$i][$if_rel];
			if (length($rel) && ($lev > 0)) {
				if (!in_list($rel, @subs)) {
					if (gen_sub_index( $rel, $lev )) {
						push(@subs, $rel);	
					}
				}
			}
		}
	}

	open my $OF, ">$of" or mydie("ERROR: Unable to generate $of file ...aborting ...\n");
	prt( "Writing [$of] HTML with $icnt files ...\n" );

	write_html_head($OF);

	add_file_table($OF);

	add_type_table($OF, ".") if ($addcattable);

	if (@subs) {
		$scnt = scalar @subs;
		$dcnt = 0;
		if ($simplelinks) {
			print $OF "<hr>\n";
			print $OF "<a name=\"links\"\n";
			print $OF "    id=\"links\"></a>\n";
			print $OF "<p><b>Links to $scnt subs:</b> \n";
			foreach $msg (@subs) {
				print $OF " [<a href=\"$msg/$out_file\">$msg</a>] \n";
			}
			print $OF "</p>\n";
		} else {
			print $OF "<p align=\"center\"><a name=\"links\"\n";
			print $OF "    id=\"links\"></a>Links to $scnt subs:<br>\n";
			foreach $msg (@subs) {
				print $OF "<a href=\"$msg/$out_file\">$msg</a>";
				$dcnt++;
				if ($dcnt < $scnt) {
					print $OF "<br>";
				}
				print $OF "\n";
			}
		}
	}

	write_html_tail($OF, $of);

	close($OF);
	prt( "Done file [$of] with $icnt files ... and $scnt subs ...\n" );

	return 1;
}

################################################
# My particular time 'translation'
sub YYYYMMDD {
	#  0    1    2     3     4    5     6     7     8
	my ($tm) = shift;
    my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime($tm);
	$year += 1900;
	$mon += 1;
	my $ymd = "$year/";
	if ($mon < 10) {
		$ymd .= '0'.$mon.'/';
	} else {
		$ymd .= "$mon/";
	}
	if ($mday < 10) {
		$ymd .= '0'.$mday;
	} else {
		$ymd .= "$mday";
	}
	return $ymd;
}

##################################################
# My particular 'nice number'
sub get_nn { # perl nice number nicenum add commas
	my ($n) = shift;
	if (length($n) > 3) {
		my $mod = length($n) % 3;
		my $ret = (($mod > 0) ? substr( $n, 0, $mod ) : '');
		my $mx = int( length($n) / 3 );
		for (my $i = 0; $i < $mx; $i++ ) {
			if (($mod == 0) && ($i == 0)) {
				$ret .= substr( $n, ($mod+(3*$i)), 3 );
			} else {
				$ret .= ',' . substr( $n, ($mod+(3*$i)), 3 );
			}
		}
		return $ret;
	}
	return $n;
}

sub is_fp_folder {
	my ($inf) = shift;
	foreach my $fil (@fpfolders) {
		if (lc($inf) eq lc($fil)) {
			return 1;
		}
	}
	return 0;
}

#####################################################
### grace ImageMagick 'indentify' installed on PATH
sub get_image_width {
	my ($is) = shift;
	my $wid = 0;
	my @arr = split(/x/,$is);
	if (scalar @arr == 2) {
		$wid = $arr[0];
	}
	return $wid;
}

sub get_image_height {
	my ($is) = shift;
	my $hgt = 0;
	my @arr = split(/x/,$is);
	if (scalar @arr == 2) {
		$hgt = $arr[1];
	}
	return $hgt;
}

sub get_image_size {
	my ($if) = shift;
	my $is = '';
	if (open (IDT, "identify \"$if\"|")) {
		my @arr2 = <IDT>;
		close IDT;
		foreach my $ln (@arr2) {
			chomp $ln;
			##prt( "[$ln]\n" );
			if (substr($ln,0,length($if)) eq $if) {
				my $ln2 = substr($ln,length($if));
				$ln2 =~ s/^\s//;
				##prt( "$ln2\n" );
				if ($ln2 =~ /\s(\d+x\d+)\s/) {
					$is = $1;
				}
			}
		}
	} else {
		prt( "ERROR: I can't open [$if]\n" );
	}
	return $is;
}
####################################################


# eof - genfileindex.pl
