#!/perl -w
# NAME: gentime.pl
# AIM: Just a simple example showing the use of 'localtime' builtin function.
# 29/07/2007 - geoff mclane - http://geoffair.net/mperl/index.htm
use strict;
use warnings;

my $tm = time();
my @timeData = localtime($tm);
print "$tm (seconds since system epoch - Midnight, January 1, 1970 GMT on Unix)\n";
print join(' ', @timeData); 
print " (Array of values)\n";
my $ct = get_date_time();
print "$ct - human readable form\n";

sub get_date_time {
	my @months = qw(Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec);
	my @weekDays = qw(Sun Mon Tue Wed Thu Fri Sat Sun);
	my ($second, $minute, $hour, $dayOfMonth, $month, $yearOffset,
		$dayOfWeek, $dayOfYear, $daylightSavings) = localtime(time());
	my $year = 1900 + $yearOffset;
	my $theTime = "$hour:$minute:$second";
	my $theDate = "$weekDays[$dayOfWeek] $months[$month] $dayOfMonth, $year";
	return "$theTime, $theDate"; 
}

