#!/perl -w
# hex conversions - from / to
my $color = '9a4fff';
my $color2 = 'FF4F9A';
my $argb = hex_color_2_rgb($color);
my $ahex = rgb_color_2_hex($argb);
prt( "Color: $color returned ($argb) ...[$ahex]\n" );
my $argb2 = hex_color_2_rgb($color2);
my $ahex2 = rgb_color_2_hex($argb2);
prt( "Color: $color2 returned ($argb2) ...[".uc($ahex2)."]\n" );

sub hex_color_2_rgb {
	my ($colr) = shift;
	my $cl = length($colr);
	my $rgb = '';
	if ($cl == 6) {
		for (my $i = 0; $i < 6; $i += 2) {
			my $hclr = substr($colr,$i,2);
			my $num = hex($hclr);
			$rgb .= ',' if length($rgb);
			$rgb .= "$num";
		}
	} else {
		prt( "WARNING: Not 6 length hex color!\n" );
	}
	return $rgb;
}

sub rgb_color_2_hex {
	my ($argb) = shift;
	my $hex = '';
	my @arr = split(',',$argb);
	if (scalar @arr == 3) {
		$hex .= sprintf("%2.2x", $arr[0]);
		$hex .= sprintf("%2.2x", $arr[1]);
		$hex .= sprintf("%2.2x", $arr[2]);
	} else {
		prt( "WARNING: Not an array of 3 comma separated values!\n" );
	}
	return $hex;
}

sub prt {
	my ($txt) = shift;
	print $txt;
}

# eof
