#!/perl -w
# imgindex.pl
# AIM: To read a FOLDER, finding all image files, and preparing a simple table index
# geoff mclane - Dec 12, 2006
# Also see genimgindex.pl, which uses ImageMagic, if installed, to get the image sizes.
use strict;
use warnings;
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $outfile = 'temp.'.$0.'.txt';
open_log($outfile);
prt( "$0 ... Hello, World ...\n" );

my $dbg1 = 1;	# add full path to file
my $wrap = 4;
my $addlink = 0;
my $addhdrln = 1; # and following is set of headings
my @headings = qw(Image Image Image Image);
mydie( "ERROR: Heading list NOT equal WRAP size ...\n" ) if ($wrap != scalar @headings);
my $addsize = 1;
my $imgsz = ' width="128" height="128"';

my $in_folder = 'C:\Documents and Settings\Geoff McLane\My Documents\Sue';
my $img_folder = 'pics01';
##my $in_folder = 'C:\HOMEPAGE\Max5\tunisia';
##my $img_folder = '128x128';
##my $img_folder = '640x480';
my $in_dir = $in_folder . '\\' . $img_folder;


my $htm_file = 'tempindex2.htm';
prt ("Processing directory $in_dir ...\n");
opendir( DIR, $in_dir) || mydie( "ERROR: Can NOT open $in_dir ... $! ... aborting ...\n" );
my @files = readdir(DIR);
closedir DIR;
prt ("Found ".scalar @files." items in the directory ...\n");
my $file = '';
my @img_list = ();
foreach $file (@files) {
	if (($file eq '.')||($file eq '..')) {
		next;
	}
	my $ff = $in_dir . '\\' . $file;
	if ( -d $ff ) {
		#prt( "Ignore Directory $file ...\n");
	} else {
		if (is_img_file($file)) {
			push(@img_list, $file);
		}
	}
}
prt ("Found ".scalar @img_list." image files in the directory ...\n");

my $html_bgn = <<"EOF";
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" 
"http://www.w3.org/TR/html4/loose.dtd">

<html>
<head>
<meta http-equiv="Content-Language" content="en-gb">
<meta http-equiv="Content-Type" content="text/html; charset=windows-1252">
<meta name="generator" content="genindex3.pl">
<title>New Index</title>
<style type="text/css">
<!-- /* some style 2006.10.20 */
body {
   margin:0cm 1cm;
   background-image:url('../clds3.jpg');
}
h1{
	background:#efefef;
	border-style:solid;
	border-color:#d9e2e2;
	border-width:1px;
	padding-top:2px;
	padding-bottom:2px;
	padding-left:2px;
	padding-right:2px;
	font-size:200%;
	text-align:center;
}
h2 { font-size: 12pt; font-weight: bold; background-color: #CCCCFF }
.ctr { text-align:center; }
-->
</style>
</head>

<body>
<h1>New Index</h1>
<p class="ctr"><a href="../home2.htm">home</a></p>
<div align="center">
  <center>
  <table border="2" cellpadding="2" bordercolor="#0000FF" id="Num1" summary="Table of Images">

EOF

my $html_end = <<"EOF";
  </table>
  </center>
</div>
<p class="ctr"><a href="../home2.htm">home</a></p>
</body>
</html>
EOF

if (@img_list) {
	prt( "Creating [$htm_file] as output ...\n" );
	open OH, ">$htm_file" || mydie( "ERROR: Can NOT create out file $htm_file ... $! ... aborting ...\n");
	my $cnt = 0;
	my $ff = '';
	my $msg = '';
	my $tcnt = 0;
	print OH $html_bgn;
	if ($addhdrln) {
		print OH "<tr>\n";
		$cnt = 0;
		while ($cnt < $wrap) {
			print OH "<th>$headings[$cnt]</th>\n";
			$cnt++;
		}
		print OH "</tr>\n";
	}
	$cnt = 0;
	foreach $file (@img_list) {
		$tcnt++;
		print OH "<tr>\n" if ($cnt == 0);
		if ($dbg1) {
			$ff = $in_dir . '\\' . $file;
		} else {
			$ff = $img_folder . '\\' . $file;
		}
		$ff = to_web($ff);
		$msg = "<td>";
		$msg .= "<a href=\"$ff\">" if ($addlink);
		$msg .= "<img src=\"$ff\" alt=\"image number $tcnt\"";
		$msg .= $imgsz if ($addsize);
		$msg .= ">";
		$msg .= "</a>" if ($addlink);
		$msg .= "</td>\n";
		print OH $msg;
		$cnt++;
		if ($cnt >= $wrap) {
			print OH "</tr>\n";
			$cnt = 0;
		}
	}
	if ($cnt) {
		while ($cnt < $wrap) {
			$msg = "<td>no image</td>\n";
			print OH $msg;
			$cnt++;
		}
		print OH "</tr>\n";
	}
	print OH $html_end;
	close OH;
	system($htm_file);
}

close_log($outfile,0);
exit(0);

sub is_img_file {
	my ($f) = @_;
	my $ret = 0;
	if ($f =~ /(.*)\.jpg$/i) {
		$ret = 1;
	} elsif ($f =~ /(.*)\.gif$/i) {
		$ret = 1;
	}
	return $ret;
}

sub to_web {
	my ($txt) = shift;
	$txt =~ s/\\/\//g;
	return $txt;
}

# eof - imgindex.pl
