#!/perl -w
# NAME: k2m.pl
# AIM: convert kilometer to miles
# geoff mclane - http://geoffmclane.com/mprerl/index.htm - 2007-04-04
use strict;
use warnings;
# from simgear - constants
#/** Meters to Nautical Miles.  1 nm = 6076.11549 feet */
my $SG_METER_TO_NM = 0.0005399568034557235;
#/** Nautical Miles to Meters */
my $SG_NM_TO_METER = 1852.0000;
#/** Meters to Statute Miles. */
my $SG_METER_TO_SM = 0.0006213699494949496;
#/** Statute Miles to Meters. */
my $SG_SM_TO_METER = 1609.3412196;
#/** 2 * PI */
my $SGD_2PI = 6.28318530717958647692;
#/** PI / 2 */
my $SGD_PI_2 = 1.57079632679489661923;

my $kilo = $SG_SM_TO_METER / 1000;
my $stmiles = int((( $kilo * 1000 ) * $SG_METER_TO_SM) + 0.00001);
print "test: $kilo kilometers = $stmiles statute miles ...\n";
parse_args(@ARGV);
$stmiles = ( $kilo * 1000 ) * $SG_METER_TO_SM;
my $nm = ( $kilo * 1000 ) * $SG_METER_TO_NM;
print "$kilo kilometers = $stmiles statute miles ...($nm Nautical Miles)\n";

exit(0);

sub parse_args {
	my (@av) = @_;
	if (@av) {
		$kilo = shift @av;
	}
}

# eof - k2m.pl
