#!/perl -w
# NAME: linecount.pl
# AIM: To count the lines in a file, IGNORING lines that are ALL spacy, or with less that
# a certain number of characters ...
# 03/01/2008 - geoff mclane - http://geoffair.net/mperl/
use strict;
use warnings;
my $min_line = 1;
my $infile = 'C:\GTools\tools\testap3\testBubble.cxx';
my @in_files = ();

sub trimall($) {
	my ($ln) = shift;
	$ln =~ s/\n/ /gm;	# replace CR (\n)
	$ln =~ s/\r/ /gm;	# replace LF (\r)
	$ln =~ s/\t/ /g;	# TAB(s) to a SPACE
	$ln = substr($ln,1) while ($ln =~ /^\s/); # remove all LEADING space
	$ln = substr($ln,0, length($ln) - 1) while ($ln =~ /\s$/); # remove all TRAILING space
	$ln =~ s/\s{2}/ /g while ($ln =~ /\s{2}/);	# all double space to SINGLE
	return $ln;
}

sub prt($) {
	my ($txt) = shift;
	print $txt;
}

sub process_file($) {
	my ($in_file) = shift;
	my $blank_lines = 0;
	my $length_lines = 0;
	my $space_lines = 0;
	my $short_lines = 0;
	if (open IFH, "<$in_file") {
		my @lines = <IFH>;
		close IFH;
		my $lncnt = scalar @lines;
		prt( "$in_file had $lncnt lines ...\n" );
		for (my $i = 0; $i < $lncnt; $i++) {
			my $line = trimall($lines[$i]);
			my $ll = length($line);
			if ($ll) {
				if ($ll > $min_line) {
					if ($line =~ /\s/) {
						$space_lines++;
					} else {
						$length_lines++;
					}
				} else {
					$short_lines++;
				}
			} else {
				$blank_lines++;
			}
		}
		my $sig_lines = $space_lines + $length_lines;
		prt( "Results: $sig_lines lines with length, $space_lines with space, $short_lines short lines ...\n" );
	} else {
		prt( "ERROR: Unable to open file [$in_file] ... $! ...\n" );
	}
}

sub process_args {
	my (@av) = @_;
	while (@av) {
		my $arg = $av[0];
		push(@in_files, $arg);
		shift @av;
	}
}

process_args(@ARGV);
if (! @in_files) {
	push(@in_files, $infile);
}
foreach my $file (@in_files) {
	process_file( $file );
}

exit(0);

# eof
