#!/perl -w
# NAME: makesrcs.pl
# AIM: Read a makefile, and (hopefully) list the SOURCES
# 26/12/2007 - geoff mclane - http://geoffair.net/mperl
use strict;
use warnings;
use File::Basename;
use Cwd;
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
	my @tmpsp = split(/\\/,$pgmname);
	$pgmname = $tmpsp[-1];
}
my $outfile = "temp.$pgmname.txt";
open_log($outfile);

my $cwd = getcwd();
prt( "$0 ... Hello, World ... CWD: $cwd\n" );

my $in_file = "C:\\FG\\FGCOMXML\\xmlrpc-c\\src\\cpp\\makefile";
###my $in_file = "C:\\FG\\FGCOM2\\iaxclient\\lib\\makefile";
my %makemacs = ();
my @warnings = ();

my ($fil_name, $fil_dir) = fileparse($in_file);
$makemacs{'BLDDIR'} = $fil_dir;
$makemacs{'SRCDIR'} = $fil_dir;

get_sources( $in_file );

foreach my $item (keys %makemacs) {
	my $itexp = expand_it($item);
	if ($item ne $itexp) {
		prt( "Unexpanded = $item\n" );
	}
	prt("[$itexp] = {".$makemacs{$item}."}\n");
}

close_log($outfile,1);
exit(0);

#####################################################################
####### subs #######

sub unix_2_dos {
	my ($f) = shift;
	$f =~ s/\//\\/g;
	return $f;
}

# fix relative path
sub fix_rel { # fixed 26/12/2007 to remove '\\' entries
	my ($path) = shift;
	$path = unix_2_dos($path);	# ensure DOS separator
	my @a = split(/\\/, $path);	# split on DOS separator
	my $npath = '';
	my $wmsg = '';
	my $max = scalar @a;
	my @na = ();
	for (my $i = 0; $i < $max; $i++) {
		my $p = $a[$i];
		if ($p eq '.') {
			# ignore this
		} elsif ($p eq '..') {
			if (@na) {
				pop @na;	# discard previous
			} else {
				$wmsg = "WARNING: Got relative .. without previous!!! [$path]";
				prt( "$wmsg\n" );
				push(@warnings,$wmsg);
			}
		} elsif (length($p)) {	# added 26/12/2007
			push(@na,$p);
		}
	}
	foreach my $pt (@na) {
		$npath .= "\\" if length($npath);
		$npath .= $pt;
	}
	return $npath;
}

sub expand_it {
	my ($txt) = shift;
	my $len = length($txt);
	my ($j, $ch, $pch, $k, $nch, $tag);
	$pch = '';
	my $ntxt = '';
	for ($j = 0; $j < $len; $j++) {
		$ch = substr($txt,$j,1);
		$tag = '';
		if ($ch eq '$') {	# start of MACRO
			$k = $j + 1;
			if ($k < $len) {
				$nch = substr($txt,$k,1);
				if ($nch eq '(') {	# start $( - find )
					$k++;
					for (; $k < $len; $k++) {
						$pch = substr($txt,$k,1);
						if ($pch eq ')') {	# found CLOSE
							last;
						} elsif ($pch eq ':') {
							last;
						}
						$tag .= $pch;
					}
				}
			}
		}
		if (length($tag)) {
			if (defined $makemacs{$tag}) {
				$ntxt .= $makemacs{$tag};
				$j = $k;
			} else {
				$ntxt .= $ch;
			}
		} else {
			$ntxt .= $ch;
		}
	}
	return $ntxt;
}

sub get_sources {
	my ($inf) = shift;
	if (open INF, "<$inf") {
		my @lines = <INF>;
		close INF;
		my ($lc, $line, $i, $nxln, $ifeq, $equ, $ecnt, $con, $j, $iftyp);
		my ($lnnum, $bgnln, $endln, $inc);
		my ($pt1, $pt2, $disc, $pt2exp);
		$lc = scalar @lines;
		prt( "Get $lc from $inf ...\n" );
		my @cond = ();
		my @ifequ = ();
		for ($i = 0; $i < $lc; $i++) {
			$lnnum = $i + 1;
			$bgnln = $lnnum;
			$line = trim_all($lines[$i]);
			if (length($line)) {
				if (substr($line,0,1) eq '#') {
					next;
				} elsif ( $line =~ /\\$/ ) {
					$i++;
					$lnnum = $i + 1;
					$line =~ s/\\$/ /;
					for ( ; $i < $lc; $i++) {
						$lnnum = $i + 1;
						$nxln = trim_all($lines[$i]);
						if (length($nxln)) {
							if ($nxln =~ /\\$/) {
								$nxln =~ s/\\$/ /;
								$line .= $nxln;
							} else {
								$line .= $nxln;
								last;
							}
						} else {
							last;
						}
					}
					$endln = $lnnum;
				} elsif (( $line =~ /^ifeq\s+(.*)/ )||
					( $line =~ /^ifneq\s+(.*)/ )) {
					$ifeq = $1;
					$iftyp = substr($line,0,3);
					$bgnln = $lnnum;
					$i++;
					$lnnum = $i + 1;
					if ($ifeq =~ /,/) {
						@ifequ = split(',',$ifeq);
						$ecnt = scalar @ifequ;
						for ($j = 0; $j < $ecnt; $j++) {
							$equ = trim_all($ifequ[$j]);
							if ($equ =~ /^\(\$\((\w+)\)$/) {
								$con = $1;
								if (defined $makemacs{$con}) {
									prt( "$con = $makemacs{$con}\n" );
								} else {
									prt( "NO MATCH FOR $con\n" );
								}
							}
						}
					}
					push(@cond,$ifeq);
					for ( ; $i < $lc; $i++) {
						$lnnum = $i + 1;
						$nxln = trim_all($lines[$i]);
						if (length($nxln)) {
							if (substr($nxln,0,1) eq '#') {
								next;
							} elsif (( $nxln =~ /ifeq\s+(.*)/ )||
								( $nxln =~ /ifneq\s+(.*)/ )) {
								$ifeq = $1;
								push(@cond, $ifeq);
							}
							$line .= ' ' . $nxln;
							if ($nxln =~ /endif/) {
								pop @cond;
								if (! @cond) {
									last;
								}
							}
						}
					}
					$endln = $lnnum;
					prt( "$bgnln:$endln: IF [$ifeq] {$line}\n" );
					next;
				}
				if ($line =~ /=/) {
					my @parts = split('=',$line);
					my $pc = scalar @parts;
					if ($pc > 2) {
						for (my $j = 2; $j < $pc; $j++) {
							$parts[1] .= '='.$parts[$j];
						}
					}
					$pt1 = trim_all($parts[0]);
					$pt2 = trim_all($parts[1]);
					$disc = '';
					if ($pt1 =~ /^(\w+)\s*:/) {
						$disc = substr($pt1,length($1));
						$pt1 = $1;
					}
					$pt2exp = expand_it($pt2);
					if ($pt2 ne $pt2exp) {
						prt("un-expanded: [$pt1]=[$pt2]\n");
					}
					if (defined $makemacs{$pt1}) {
						prt("$bgnln:$lnnum: [$pt1]=[$pt2exp] added makemacs ($disc)\n");
						$makemacs{$pt1} .= " && " . $pt2exp;
					} else {
						prt("$bgnln:$lnnum: [$pt1]=[$pt2exp] to makemacs ($disc)\n");
						$makemacs{$pt1} = $pt2exp;
					}
				} elsif ($line =~ /^include\s+(.*)/) {
					$inc = trim_all($1);
					$pt2exp = expand_it($inc);
					if ($inc ne $pt2exp) {
						prt("un-expanded: [$inc]\n");
					}
					prt( "$bgnln:$lnnum: include {$pt2exp}\n" );
				} else {
					$pt2exp = expand_it($line);
					if ($line ne $pt2exp) {
						prt("un-expanded: [$line]\n");
					}
					prt( "$bgnln:$lnnum: {$pt2exp}\n" );
				}
			}
		}
	} else {
		prt( "ERROR: Unable to open $inf ...\n" );
	}
}


# eof - makesrcs.pl
