#!/perl

use IO::Socket;
#####################################
# Server Script: Copyright 2003 (c) Philip Yuson 
# (c) 2005 geoff mclane
# this program is distributed according to 
# the terms of the Perl license
# Use at your own risk
#####################################
my $hdr = 'SERVER:';
my $host = shift || 'localhost';
my $port = shift || '8081';  # Change the port if 8081 is being used

print "$hdr Creating tcp socket to host=$host, on port=$port ...\n";
my $local = IO::Socket::INET->new(
		Proto	 => 'tcp',		# protocol
		LocalAddr => "$host:$port", ## 'localhost:8081' # Host and port to listen to
		Reuse => 1
		) or die "$!";
print "$hdr Setting a listen ...\n";
$local->listen();	# listen
print "$hdr Setting auto-flush ...\n";
$local->autoflush(1);	# To send response immediately
print "$hdr At your service. Waiting...\n";
my $addr;	# Client handle
while ($addr = $local->accept() ) {	# receive a request
	print 	"$hdr Connected from: Host: ", $addr->peerhost();	# Display messages
	print	" Port: ", $addr->peerport(), "\n";
	my $result;		# variable for Result
	print "$hdr Waiting for a command ...\n";
	while (<$addr>) {	# Read all messages from client 
 # (Assume all valid numbers)
		last if m/^end/gi;	# if message is 'end' 
 # then exit loop
		print "Received: $_";	# Print received message
		$local->send("ACK\n");
	}
}

# EOF



