#!/perl

use IO::Socket;
##my $hdr = "$0 $$:";
my $hdr = 'SERVER5:';
my $host = shift || 'localhost';
my $port = shift || '7070';
my $msg;

print "$hdr Creating socket host=$host, port=$port ...\n";
my $sock = new IO::Socket::INET (
                                 LocalHost => $host, ### 'thekla'
                                 LocalPort => $port, ### '7070'
                                 Proto => 'tcp',
                                 Listen => 1,
                                 Reuse => 1,
                                );
die "$hdr Could not create socket: $!\n" unless $sock;

print "$hdr Setting an accept ... host=$host, port=$port ...\n";
my $new_sock = $sock->accept();
print "$hdr Waiting for input ... host=$host, port=$port ...\n";
my $line;
my $i = 0; # start counter
my $len;
my $gotend = 0;
while(defined($line = <$new_sock>)) {
    ###print "$hdr Received [$_]\n";
	$gotend = 0;
	$i++;
	$len = length($line);
	chomp $line;
    print "$hdr Received $i: $len [";
    print $line, "]\n";
	$msg = "$hdr ACK $i:";
	###if ($line eq 'end') {
	if ($line =~ m/^end/i ) {
		$msg .= ' bye, bye for now ...';
		$gotend = 1;
	} else {
		if ($i == 1) {
			$msg .= ' tks for welcome ...';
		} elsif ($i == 2) {
			$msg .= ' Fine, how are you?';
		}
	}
	print $new_sock "$msg\n";
	print "$hdr Sent $msg\n";
	last if ($gotend); # exit, if end, else
	print "$hdr Waiting for input ...\n";
}

## how, why did we exit?
if ($gotend) { ### $line starts with 'end'
	print "$hdr Got polite 'end' from client ...\n";
} else {
	print "$hdr New socket undefined ... Client closed?\n";
}

## tidy up ....
print "$hdr Closing socket ... host=$host, port=$port ...\n";
close($sock);

